"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetApiGatewayEndpointConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
/**
 * Override RestApis to use a set endpoint configuration.
 *
 * Some regions don't support EDGE endpoints, and some enterprises require
 * specific endpoint types for RestApis
 */
class SetApiGatewayEndpointConfiguration {
    constructor(props) {
        this._endpointType = props?.endpointType || aws_apigateway_1.EndpointType.REGIONAL;
    }
    visit(node) {
        if (node instanceof aws_cdk_lib_1.CfnResource) {
            const cfnResourceNode = node;
            if (cfnResourceNode.cfnResourceType == 'AWS::ApiGateway::RestApi') {
                cfnResourceNode.addPropertyOverride('EndpointConfiguration.Types', [
                    this._endpointType.toString(),
                ]);
                cfnResourceNode.addPropertyOverride('Parameters.endpointConfigurationTypes', this._endpointType.toString());
            }
        }
    }
}
exports.SetApiGatewayEndpointConfiguration = SetApiGatewayEndpointConfiguration;
_a = JSII_RTTI_SYMBOL_1;
SetApiGatewayEndpointConfiguration[_a] = { fqn: "@cdklabs/cdk-enterprise-iac.SetApiGatewayEndpointConfiguration", version: "0.0.411" };
//# sourceMappingURL=data:application/json;base64,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