try:
	from zohocrmsdk.src.com.zoho.crm.api.exception import SDKException
	from zohocrmsdk.src.com.zoho.crm.api.util import Choice, Constants
except Exception:
	from ..exception import SDKException
	from ..util import Choice, Constants


class HierarchyPreferences(object):
	def __init__(self):
		"""Creates an instance of HierarchyPreferences"""

		self.__type = None
		self.__strictly_reporting = None
		self.__key_modified = dict()

	def get_type(self):
		"""
		The method to get the type

		Returns:
			Choice: An instance of Choice
		"""

		return self.__type

	def set_type(self, type):
		"""
		The method to set the value to type

		Parameters:
			type (Choice) : An instance of Choice
		"""

		if type is not None and not isinstance(type, Choice):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: type EXPECTED TYPE: Choice', None, None)
		
		self.__type = type
		self.__key_modified['type'] = 1

	def get_strictly_reporting(self):
		"""
		The method to get the strictly_reporting

		Returns:
			bool: A bool representing the strictly_reporting
		"""

		return self.__strictly_reporting

	def set_strictly_reporting(self, strictly_reporting):
		"""
		The method to set the value to strictly_reporting

		Parameters:
			strictly_reporting (bool) : A bool representing the strictly_reporting
		"""

		if strictly_reporting is not None and not isinstance(strictly_reporting, bool):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: strictly_reporting EXPECTED TYPE: bool', None, None)
		
		self.__strictly_reporting = strictly_reporting
		self.__key_modified['strictly_reporting'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string representing the key

		Returns:
			int: An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string representing the key
			modification (int) : An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if modification is not None and not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
