try:
	from zohocrmsdk.src.com.zoho.crm.api.exception import SDKException
	from zohocrmsdk.src.com.zoho.crm.api.util import Constants
except Exception:
	from ..exception import SDKException
	from ..util import Constants


class SpamControl(object):
	def __init__(self):
		"""Creates an instance of SpamControl"""

		self.__status = None
		self.__exclude_score = None
		self.__spam_possibility_threshold = None
		self.__key_modified = dict()

	def get_status(self):
		"""
		The method to get the status

		Returns:
			string: A string representing the status
		"""

		return self.__status

	def set_status(self, status):
		"""
		The method to set the value to status

		Parameters:
			status (string) : A string representing the status
		"""

		if status is not None and not isinstance(status, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: status EXPECTED TYPE: str', None, None)
		
		self.__status = status
		self.__key_modified['status'] = 1

	def get_exclude_score(self):
		"""
		The method to get the exclude_score

		Returns:
			string: A string representing the exclude_score
		"""

		return self.__exclude_score

	def set_exclude_score(self, exclude_score):
		"""
		The method to set the value to exclude_score

		Parameters:
			exclude_score (string) : A string representing the exclude_score
		"""

		if exclude_score is not None and not isinstance(exclude_score, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: exclude_score EXPECTED TYPE: str', None, None)
		
		self.__exclude_score = exclude_score
		self.__key_modified['exclude_score'] = 1

	def get_spam_possibility_threshold(self):
		"""
		The method to get the spam_possibility_threshold

		Returns:
			int: An int representing the spam_possibility_threshold
		"""

		return self.__spam_possibility_threshold

	def set_spam_possibility_threshold(self, spam_possibility_threshold):
		"""
		The method to set the value to spam_possibility_threshold

		Parameters:
			spam_possibility_threshold (int) : An int representing the spam_possibility_threshold
		"""

		if spam_possibility_threshold is not None and not isinstance(spam_possibility_threshold, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: spam_possibility_threshold EXPECTED TYPE: int', None, None)
		
		self.__spam_possibility_threshold = spam_possibility_threshold
		self.__key_modified['spam_possibility_threshold'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string representing the key

		Returns:
			int: An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string representing the key
			modification (int) : An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if modification is not None and not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
