# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BlockSnapshotArgs', 'BlockSnapshot']

@pulumi.input_type
class BlockSnapshotArgs:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input['BlockSnapshotExportArgs']] = None,
                 import_: Optional[pulumi.Input['BlockSnapshotImportArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BlockSnapshot resource.
        :param pulumi.Input['BlockSnapshotExportArgs'] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input['BlockSnapshotImportArgs'] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[_builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['BlockSnapshotExportArgs']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['BlockSnapshotExportArgs']]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['BlockSnapshotImportArgs']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['BlockSnapshotImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _BlockSnapshotState:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input['BlockSnapshotExportArgs']] = None,
                 import_: Optional[pulumi.Input['BlockSnapshotImportArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BlockSnapshot resources.
        :param pulumi.Input['BlockSnapshotExportArgs'] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input['BlockSnapshotImportArgs'] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[_builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['BlockSnapshotExportArgs']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['BlockSnapshotExportArgs']]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['BlockSnapshotImportArgs']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['BlockSnapshotImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/blocksnapshot.BlockSnapshot has been deprecated in favor of scaleway.block/snapshot.Snapshot""", DeprecationWarning)


@pulumi.type_token("scaleway:index/blockSnapshot:BlockSnapshot")
class BlockSnapshot(pulumi.CustomResource):
    warnings.warn("""scaleway.index/blocksnapshot.BlockSnapshot has been deprecated in favor of scaleway.block/snapshot.Snapshot""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export: Optional[pulumi.Input[Union['BlockSnapshotExportArgs', 'BlockSnapshotExportArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['BlockSnapshotImportArgs', 'BlockSnapshotImportArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `block.Snapshot` resource is used to create and manage snapshots of Block Storage volumes.

        Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.

        ## Example Usage

        ### Create a snapshot of a Block Storage volume

        The following command allows you to create a snapshot (`some-snapshot-name`) from a Block Storage volume specified by its ID.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        block_volume = scaleway.block.Volume("block_volume",
            iops=5000,
            name="some-volume-name",
            size_in_gb=20)
        block_snapshot = scaleway.block.Snapshot("block_snapshot",
            name="some-snapshot-name",
            volume_id=block_volume.id)
        ```

        ### How to import from Object Storage

        ### How to export to Object Storage

        ## Import

        This section explains how to import the snapshot of a Block Storage volume using the zoned ID format (`{zone}/{id}`).

        bash

        ```sh
        $ pulumi import scaleway:index/blockSnapshot:BlockSnapshot main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BlockSnapshotExportArgs', 'BlockSnapshotExportArgsDict']] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input[Union['BlockSnapshotImportArgs', 'BlockSnapshotImportArgsDict']] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[_builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BlockSnapshotArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `block.Snapshot` resource is used to create and manage snapshots of Block Storage volumes.

        Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.

        ## Example Usage

        ### Create a snapshot of a Block Storage volume

        The following command allows you to create a snapshot (`some-snapshot-name`) from a Block Storage volume specified by its ID.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        block_volume = scaleway.block.Volume("block_volume",
            iops=5000,
            name="some-volume-name",
            size_in_gb=20)
        block_snapshot = scaleway.block.Snapshot("block_snapshot",
            name="some-snapshot-name",
            volume_id=block_volume.id)
        ```

        ### How to import from Object Storage

        ### How to export to Object Storage

        ## Import

        This section explains how to import the snapshot of a Block Storage volume using the zoned ID format (`{zone}/{id}`).

        bash

        ```sh
        $ pulumi import scaleway:index/blockSnapshot:BlockSnapshot main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param BlockSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlockSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export: Optional[pulumi.Input[Union['BlockSnapshotExportArgs', 'BlockSnapshotExportArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['BlockSnapshotImportArgs', 'BlockSnapshotImportArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""BlockSnapshot is deprecated: scaleway.index/blocksnapshot.BlockSnapshot has been deprecated in favor of scaleway.block/snapshot.Snapshot""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlockSnapshotArgs.__new__(BlockSnapshotArgs)

            __props__.__dict__["export"] = export
            __props__.__dict__["import_"] = import_
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["zone"] = zone
        super(BlockSnapshot, __self__).__init__(
            'scaleway:index/blockSnapshot:BlockSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            export: Optional[pulumi.Input[Union['BlockSnapshotExportArgs', 'BlockSnapshotExportArgsDict']]] = None,
            import_: Optional[pulumi.Input[Union['BlockSnapshotImportArgs', 'BlockSnapshotImportArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'BlockSnapshot':
        """
        Get an existing BlockSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BlockSnapshotExportArgs', 'BlockSnapshotExportArgsDict']] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input[Union['BlockSnapshotImportArgs', 'BlockSnapshotImportArgsDict']] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[_builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlockSnapshotState.__new__(_BlockSnapshotState)

        __props__.__dict__["export"] = export
        __props__.__dict__["import_"] = import_
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volume_id"] = volume_id
        __props__.__dict__["zone"] = zone
        return BlockSnapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def export(self) -> pulumi.Output[Optional['outputs.BlockSnapshotExport']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> pulumi.Output[Optional['outputs.BlockSnapshotImport']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

