# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TokenArgs', 'Token']

@pulumi.input_type
class TokenArgs:
    def __init__(__self__, *,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Token resource.
        :param pulumi.Input[_builtins.str] container_id: The unique identifier of the container.
               
               > Only one of `namespace_id` or `container_id` must be set.
        :param pulumi.Input[_builtins.str] description: The description of the token.
        :param pulumi.Input[_builtins.str] expires_at: The expiration date of the token.
        :param pulumi.Input[_builtins.str] namespace_id: The unique identifier of the Containers namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
               
               > **Important** Updating any of the arguments above will recreate the token.
        """
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the container.

        > Only one of `namespace_id` or `container_id` must be set.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration date of the token.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Containers namespace.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.

        > **Important** Updating any of the arguments above will recreate the token.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TokenState:
    def __init__(__self__, *,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Token resources.
        :param pulumi.Input[_builtins.str] container_id: The unique identifier of the container.
               
               > Only one of `namespace_id` or `container_id` must be set.
        :param pulumi.Input[_builtins.str] description: The description of the token.
        :param pulumi.Input[_builtins.str] expires_at: The expiration date of the token.
        :param pulumi.Input[_builtins.str] namespace_id: The unique identifier of the Containers namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
               
               > **Important** Updating any of the arguments above will recreate the token.
        :param pulumi.Input[_builtins.str] value: The token.
        """
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the container.

        > Only one of `namespace_id` or `container_id` must be set.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration date of the token.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Containers namespace.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.

        > **Important** Updating any of the arguments above will recreate the token.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("scaleway:containers/token:Token")
class Token(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `containers.Token` resource allows you to create and manage authentication tokens for Scaleway [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Containers tokens [documentation](https://www.scaleway.com/en/docs/serverless/containers/how-to/create-auth-token-from-console/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/#path-tokens-list-all-tokens) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main", name="test-container-token-ns")
        main_container = scaleway.containers.Container("main", namespace_id=main.id)
        # Namespace Token
        namespace = scaleway.containers.Token("namespace",
            namespace_id=main.id,
            expires_at="2022-10-18T11:35:15+02:00")
        # Container Token
        container = scaleway.containers.Token("container", container_id=main_container.id)
        ```

        ## Import

        Tokens can be imported using `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:containers/token:Token main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_id: The unique identifier of the container.
               
               > Only one of `namespace_id` or `container_id` must be set.
        :param pulumi.Input[_builtins.str] description: The description of the token.
        :param pulumi.Input[_builtins.str] expires_at: The expiration date of the token.
        :param pulumi.Input[_builtins.str] namespace_id: The unique identifier of the Containers namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
               
               > **Important** Updating any of the arguments above will recreate the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `containers.Token` resource allows you to create and manage authentication tokens for Scaleway [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Containers tokens [documentation](https://www.scaleway.com/en/docs/serverless/containers/how-to/create-auth-token-from-console/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/#path-tokens-list-all-tokens) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main", name="test-container-token-ns")
        main_container = scaleway.containers.Container("main", namespace_id=main.id)
        # Namespace Token
        namespace = scaleway.containers.Token("namespace",
            namespace_id=main.id,
            expires_at="2022-10-18T11:35:15+02:00")
        # Container Token
        container = scaleway.containers.Token("container", container_id=main_container.id)
        ```

        ## Import

        Tokens can be imported using `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:containers/token:Token main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param TokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenArgs.__new__(TokenArgs)

            __props__.__dict__["container_id"] = container_id
            __props__.__dict__["description"] = description
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["region"] = region
            __props__.__dict__["value"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/containerToken:ContainerToken")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Token, __self__).__init__(
            'scaleway:containers/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_id: The unique identifier of the container.
               
               > Only one of `namespace_id` or `container_id` must be set.
        :param pulumi.Input[_builtins.str] description: The description of the token.
        :param pulumi.Input[_builtins.str] expires_at: The expiration date of the token.
        :param pulumi.Input[_builtins.str] namespace_id: The unique identifier of the Containers namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
               
               > **Important** Updating any of the arguments above will recreate the token.
        :param pulumi.Input[_builtins.str] value: The token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenState.__new__(_TokenState)

        __props__.__dict__["container_id"] = container_id
        __props__.__dict__["description"] = description
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["region"] = region
        __props__.__dict__["value"] = value
        return Token(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier of the container.

        > Only one of `namespace_id` or `container_id` must be set.
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration date of the token.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier of the Containers namespace.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.

        > **Important** Updating any of the arguments above will recreate the token.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The token.
        """
        return pulumi.get(self, "value")

