# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAclResult',
    'AwaitableGetAclResult',
    'get_acl',
    'get_acl_output',
]

@pulumi.output_type
class GetAclResult:
    """
    A collection of values returned by getAcl.
    """
    def __init__(__self__, acl_rules=None, id=None, instance_id=None, region=None):
        if acl_rules and not isinstance(acl_rules, list):
            raise TypeError("Expected argument 'acl_rules' to be a list")
        pulumi.set(__self__, "acl_rules", acl_rules)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> Sequence['outputs.GetAclAclRuleResult']:
        """
        A list of ACLs rules (structure is described below)
        """
        return pulumi.get(self, "acl_rules")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetAclResult(GetAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclResult(
            acl_rules=self.acl_rules,
            id=self.id,
            instance_id=self.instance_id,
            region=self.region)


def get_acl(instance_id: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclResult:
    """
    Gets information about the Database Instance network Access Control List.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get the database ACL for the instance id 11111111-1111-1111-1111-111111111111 located in the default region e.g: fr-par
    my_acl = scaleway.databases.get_acl(instance_id="11111111-1111-1111-1111-111111111111")
    ```


    :param _builtins.str instance_id: The RDB instance ID.
    :param _builtins.str region: `region`) The region in which the Database Instance should be created.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:databases/getAcl:getAcl', __args__, opts=opts, typ=GetAclResult).value

    return AwaitableGetAclResult(
        acl_rules=pulumi.get(__ret__, 'acl_rules'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        region=pulumi.get(__ret__, 'region'))
def get_acl_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclResult]:
    """
    Gets information about the Database Instance network Access Control List.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get the database ACL for the instance id 11111111-1111-1111-1111-111111111111 located in the default region e.g: fr-par
    my_acl = scaleway.databases.get_acl(instance_id="11111111-1111-1111-1111-111111111111")
    ```


    :param _builtins.str instance_id: The RDB instance ID.
    :param _builtins.str region: `region`) The region in which the Database Instance should be created.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:databases/getAcl:getAcl', __args__, opts=opts, typ=GetAclResult)
    return __ret__.apply(lambda __response__: GetAclResult(
        acl_rules=pulumi.get(__response__, 'acl_rules'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        region=pulumi.get(__response__, 'region')))
