# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclRule',
    'InstanceLoadBalancer',
    'InstanceLogsPolicy',
    'InstancePrivateIp',
    'InstancePrivateNetwork',
    'InstanceReadReplica',
    'InstanceUpgradableVersion',
    'ReadReplicaDirectAccess',
    'ReadReplicaPrivateNetwork',
    'GetAclAclRuleResult',
    'GetInstanceLoadBalancerResult',
    'GetInstanceLogsPolicyResult',
    'GetInstancePrivateIpResult',
    'GetInstancePrivateNetworkResult',
    'GetInstanceReadReplicaResult',
    'GetInstanceUpgradableVersionResult',
]

@pulumi.output_type
class AclAclRule(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param _builtins.str description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str hostname: Hostname of the endpoint.
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceLogsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeRetention":
            suggest = "max_age_retention"
        elif key == "totalDiskRetention":
            suggest = "total_disk_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLogsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLogsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLogsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_retention: Optional[_builtins.int] = None,
                 total_disk_retention: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param _builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        if max_age_retention is not None:
            pulumi.set(__self__, "max_age_retention", max_age_retention)
        if total_disk_retention is not None:
            pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @_builtins.property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> Optional[_builtins.int]:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @_builtins.property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> Optional[_builtins.int]:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class InstancePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: Version ID to use in upgrade requests.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Version ID to use in upgrade requests.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "ipNet":
            suggest = "ip_net"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 enable_ipam: Optional[_builtins.bool] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 ip_net: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str pn_id: The private network ID
        :param _builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str hostname: Hostname of the endpoint.
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str ip_net: The IP with the given mask within the private subnet
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        :param _builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_net is not None:
            pulumi.set(__self__, "ip_net", ip_net)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[_builtins.bool]:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> Optional[_builtins.str]:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceReadReplica(dict):
    def __init__(__self__, *,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceUpgradableVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minorVersion":
            suggest = "minor_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceUpgradableVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceUpgradableVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceUpgradableVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 minor_version: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Version ID to use in upgrade requests.
        :param _builtins.str minor_version: Minor version string (e.g., `15.5.0`).
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.str version: Version string (e.g., `15.5`).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if minor_version is not None:
            pulumi.set(__self__, "minor_version", minor_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Version ID to use in upgrade requests.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> Optional[_builtins.str]:
        """
        Minor version string (e.g., `15.5.0`).
        """
        return pulumi.get(self, "minor_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version string (e.g., `15.5`).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ReadReplicaDirectAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaDirectAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaDirectAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaDirectAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param _builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param _builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param _builtins.str name: Name of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ReadReplicaPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "serviceIp":
            suggest = "service_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: _builtins.str,
                 enable_ipam: Optional[_builtins.bool] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 service_ip: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str private_network_id: UUID of the Private Netork to be connected to the Read Replica.
        :param _builtins.bool enable_ipam: If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        :param _builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param _builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param _builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param _builtins.str name: Name of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        :param _builtins.str service_ip: The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        :param _builtins.str zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> _builtins.str:
        """
        UUID of the Private Netork to be connected to the Read Replica.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[_builtins.bool]:
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[_builtins.str]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        return pulumi.get(self, "service_ip")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetAclAclRuleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str description: A simple text describing this rule
        :param _builtins.str ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A simple text describing this rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetInstanceLoadBalancerResult(dict):
    def __init__(__self__, *,
                 endpoint_id: _builtins.str,
                 hostname: _builtins.str,
                 ip: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str endpoint_id: The endpoint ID
        :param _builtins.str hostname: The hostname of your endpoint
        :param _builtins.str ip: The IP of your load balancer service
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.int port: The port of your load balancer service
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP of your load balancer service
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of your load balancer service
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetInstanceLogsPolicyResult(dict):
    def __init__(__self__, *,
                 max_age_retention: _builtins.int,
                 total_disk_retention: _builtins.int):
        """
        :param _builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param _builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        pulumi.set(__self__, "max_age_retention", max_age_retention)
        pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @_builtins.property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> _builtins.int:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @_builtins.property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> _builtins.int:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class GetInstancePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address
        :param _builtins.str id: The ID of the Database Instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Database Instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 enable_ipam: _builtins.bool,
                 endpoint_id: _builtins.str,
                 hostname: _builtins.str,
                 ip: _builtins.str,
                 ip_net: _builtins.str,
                 name: _builtins.str,
                 pn_id: _builtins.str,
                 port: _builtins.int,
                 zone: _builtins.str):
        """
        :param _builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param _builtins.str endpoint_id: The endpoint ID
        :param _builtins.str hostname: The hostname of your endpoint
        :param _builtins.str ip: The IP of your Instance within the private service
        :param _builtins.str ip_net: The IP with the given mask within the private subnet
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.str pn_id: The private network ID
        :param _builtins.int port: The port of your private service
        :param _builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "enable_ipam", enable_ipam)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> _builtins.bool:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP of your Instance within the private service
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> _builtins.str:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of your private service
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceReadReplicaResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str ip: IP of the replica
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.int port: Port of the replica
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP of the replica
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the replica
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetInstanceUpgradableVersionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 minor_version: _builtins.str,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str id: The ID of the Database Instance.
        :param _builtins.str minor_version: Minor version string
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.str version: Version string
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "minor_version", minor_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Database Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> _builtins.str:
        """
        Minor version string
        """
        return pulumi.get(self, "minor_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version string
        """
        return pulumi.get(self, "version")


