# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DeploymentPublicNetworkArgs',
    'DeploymentPublicNetworkArgsDict',
    'DeploymentPublicNetworkServiceArgs',
    'DeploymentPublicNetworkServiceArgsDict',
]

MYPY = False

if not MYPY:
    class DeploymentPublicNetworkArgsDict(TypedDict):
        dns_record: NotRequired[pulumi.Input[_builtins.str]]
        """
        DNS record for the public endpoint.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the public endpoint.
        """
        services: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkServiceArgsDict']]]]
        """
        List of services exposed on the public endpoint.
        """
elif False:
    DeploymentPublicNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentPublicNetworkArgs:
    def __init__(__self__, *,
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkServiceArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] dns_record: DNS record for the public endpoint.
        :param pulumi.Input[_builtins.str] id: The ID of the public endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkServiceArgs']]] services: List of services exposed on the public endpoint.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS record for the public endpoint.
        """
        return pulumi.get(self, "dns_record")

    @dns_record.setter
    def dns_record(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the public endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkServiceArgs']]]]:
        """
        List of services exposed on the public endpoint.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkServiceArgs']]]]):
        pulumi.set(self, "services", value)


if not MYPY:
    class DeploymentPublicNetworkServiceArgsDict(TypedDict):
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        TCP port number.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Service protocol (e.g., "tcp", "https", "mysql").
        """
elif False:
    DeploymentPublicNetworkServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentPublicNetworkServiceArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] port: TCP port number.
        :param pulumi.Input[_builtins.str] protocol: Service protocol (e.g., "tcp", "https", "mysql").
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service protocol (e.g., "tcp", "https", "mysql").
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


