# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 cpu_max: pulumi.Input[_builtins.int],
                 cpu_min: pulumi.Input[_builtins.int],
                 ram_per_cpu: pulumi.Input[_builtins.int],
                 replica_count: pulumi.Input[_builtins.int],
                 version: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[_builtins.int] cpu_max: Maximum CPU count. Must be greater than or equal to `cpu_min`.
        :param pulumi.Input[_builtins.int] cpu_min: Minimum CPU count. Must be less than or equal to `cpu_max`.
        :param pulumi.Input[_builtins.int] ram_per_cpu: RAM per CPU in GB.
        :param pulumi.Input[_builtins.int] replica_count: Number of replicas.
        :param pulumi.Input[_builtins.str] version: ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        :param pulumi.Input[_builtins.str] name: Name of the Data Warehouse deployment.
        :param pulumi.Input[_builtins.str] password: Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
               
               > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.
               
               > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the deployment should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to apply to the deployment.
        """
        pulumi.set(__self__, "cpu_max", cpu_max)
        pulumi.set(__self__, "cpu_min", cpu_min)
        pulumi.set(__self__, "ram_per_cpu", ram_per_cpu)
        pulumi.set(__self__, "replica_count", replica_count)
        pulumi.set(__self__, "version", version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cpuMax")
    def cpu_max(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum CPU count. Must be greater than or equal to `cpu_min`.
        """
        return pulumi.get(self, "cpu_max")

    @cpu_max.setter
    def cpu_max(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_max", value)

    @_builtins.property
    @pulumi.getter(name="cpuMin")
    def cpu_min(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum CPU count. Must be less than or equal to `cpu_max`.
        """
        return pulumi.get(self, "cpu_min")

    @cpu_min.setter
    def cpu_min(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_min", value)

    @_builtins.property
    @pulumi.getter(name="ramPerCpu")
    def ram_per_cpu(self) -> pulumi.Input[_builtins.int]:
        """
        RAM per CPU in GB.
        """
        return pulumi.get(self, "ram_per_cpu")

    @ram_per_cpu.setter
    def ram_per_cpu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ram_per_cpu", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Input[_builtins.int]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Data Warehouse deployment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.

        > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.

        > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the deployment should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags to apply to the deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 cpu_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_min: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_networks: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkArgs']]]] = None,
                 ram_per_cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[_builtins.int] cpu_max: Maximum CPU count. Must be greater than or equal to `cpu_min`.
        :param pulumi.Input[_builtins.int] cpu_min: Minimum CPU count. Must be less than or equal to `cpu_max`.
        :param pulumi.Input[_builtins.str] created_at: Date and time of deployment creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] name: Name of the Data Warehouse deployment.
        :param pulumi.Input[_builtins.str] password: Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
               
               > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.
               
               > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkArgs']]] public_networks: Public endpoint information (always created automatically).
        :param pulumi.Input[_builtins.int] ram_per_cpu: RAM per CPU in GB.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the deployment should be created.
        :param pulumi.Input[_builtins.int] replica_count: Number of replicas.
        :param pulumi.Input[_builtins.str] status: The status of the deployment (e.g., "ready", "provisioning").
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to apply to the deployment.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of deployment last update (RFC 3339 format).
        :param pulumi.Input[_builtins.str] version: ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        if cpu_max is not None:
            pulumi.set(__self__, "cpu_max", cpu_max)
        if cpu_min is not None:
            pulumi.set(__self__, "cpu_min", cpu_min)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_networks is not None:
            pulumi.set(__self__, "public_networks", public_networks)
        if ram_per_cpu is not None:
            pulumi.set(__self__, "ram_per_cpu", ram_per_cpu)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="cpuMax")
    def cpu_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum CPU count. Must be greater than or equal to `cpu_min`.
        """
        return pulumi.get(self, "cpu_max")

    @cpu_max.setter
    def cpu_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_max", value)

    @_builtins.property
    @pulumi.getter(name="cpuMin")
    def cpu_min(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum CPU count. Must be less than or equal to `cpu_max`.
        """
        return pulumi.get(self, "cpu_min")

    @cpu_min.setter
    def cpu_min(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_min", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of deployment creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Data Warehouse deployment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.

        > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.

        > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworks")
    def public_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkArgs']]]]:
        """
        Public endpoint information (always created automatically).
        """
        return pulumi.get(self, "public_networks")

    @public_networks.setter
    def public_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPublicNetworkArgs']]]]):
        pulumi.set(self, "public_networks", value)

    @_builtins.property
    @pulumi.getter(name="ramPerCpu")
    def ram_per_cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        RAM per CPU in GB.
        """
        return pulumi.get(self, "ram_per_cpu")

    @ram_per_cpu.setter
    def ram_per_cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ram_per_cpu", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the deployment should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the deployment (e.g., "ready", "provisioning").
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags to apply to the deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of deployment last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("scaleway:datawarehouse/deployment:Deployment")
class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_min: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_per_cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Data Warehouse deployments.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/data-warehouse/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        ```

        ### With Tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "production",
                "analytics",
            ])
        ```

        ## Import

        Data Warehouse deployments can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:datawarehouse/deployment:Deployment main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cpu_max: Maximum CPU count. Must be greater than or equal to `cpu_min`.
        :param pulumi.Input[_builtins.int] cpu_min: Minimum CPU count. Must be less than or equal to `cpu_max`.
        :param pulumi.Input[_builtins.str] name: Name of the Data Warehouse deployment.
        :param pulumi.Input[_builtins.str] password: Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
               
               > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.
               
               > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        :param pulumi.Input[_builtins.int] ram_per_cpu: RAM per CPU in GB.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the deployment should be created.
        :param pulumi.Input[_builtins.int] replica_count: Number of replicas.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to apply to the deployment.
        :param pulumi.Input[_builtins.str] version: ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Data Warehouse deployments.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/data-warehouse/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        ```

        ### With Tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "production",
                "analytics",
            ])
        ```

        ## Import

        Data Warehouse deployments can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:datawarehouse/deployment:Deployment main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_max: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_min: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_per_cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if cpu_max is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_max'")
            __props__.__dict__["cpu_max"] = cpu_max
            if cpu_min is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_min'")
            __props__.__dict__["cpu_min"] = cpu_min
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["project_id"] = project_id
            if ram_per_cpu is None and not opts.urn:
                raise TypeError("Missing required property 'ram_per_cpu'")
            __props__.__dict__["ram_per_cpu"] = ram_per_cpu
            __props__.__dict__["region"] = region
            if replica_count is None and not opts.urn:
                raise TypeError("Missing required property 'replica_count'")
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["public_networks"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Deployment, __self__).__init__(
            'scaleway:datawarehouse/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_max: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_min: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPublicNetworkArgs', 'DeploymentPublicNetworkArgsDict']]]]] = None,
            ram_per_cpu: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cpu_max: Maximum CPU count. Must be greater than or equal to `cpu_min`.
        :param pulumi.Input[_builtins.int] cpu_min: Minimum CPU count. Must be less than or equal to `cpu_max`.
        :param pulumi.Input[_builtins.str] created_at: Date and time of deployment creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] name: Name of the Data Warehouse deployment.
        :param pulumi.Input[_builtins.str] password: Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
               
               > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.
               
               > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPublicNetworkArgs', 'DeploymentPublicNetworkArgsDict']]]] public_networks: Public endpoint information (always created automatically).
        :param pulumi.Input[_builtins.int] ram_per_cpu: RAM per CPU in GB.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the deployment should be created.
        :param pulumi.Input[_builtins.int] replica_count: Number of replicas.
        :param pulumi.Input[_builtins.str] status: The status of the deployment (e.g., "ready", "provisioning").
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to apply to the deployment.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of deployment last update (RFC 3339 format).
        :param pulumi.Input[_builtins.str] version: ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["cpu_max"] = cpu_max
        __props__.__dict__["cpu_min"] = cpu_min
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_networks"] = public_networks
        __props__.__dict__["ram_per_cpu"] = ram_per_cpu
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["version"] = version
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cpuMax")
    def cpu_max(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum CPU count. Must be greater than or equal to `cpu_min`.
        """
        return pulumi.get(self, "cpu_max")

    @_builtins.property
    @pulumi.getter(name="cpuMin")
    def cpu_min(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum CPU count. Must be less than or equal to `cpu_max`.
        """
        return pulumi.get(self, "cpu_min")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of deployment creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Data Warehouse deployment.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for the first user of the deployment. If not specified, a random password will be generated. Note: password is only used during deployment creation.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the deployment is associated with.

        > **Important:** Private endpoints are not yet supported by the API. A public endpoint is always created automatically.

        > **Note:** During the private beta phase, modifying `cpu_min`, `cpu_max`, and `replica_count` has no effect until the feature is launched in general availability.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicNetworks")
    def public_networks(self) -> pulumi.Output[Sequence['outputs.DeploymentPublicNetwork']]:
        """
        Public endpoint information (always created automatically).
        """
        return pulumi.get(self, "public_networks")

    @_builtins.property
    @pulumi.getter(name="ramPerCpu")
    def ram_per_cpu(self) -> pulumi.Output[_builtins.int]:
        """
        RAM per CPU in GB.
        """
        return pulumi.get(self, "ram_per_cpu")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region in which the deployment should be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the deployment (e.g., "ready", "provisioning").
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags to apply to the deployment.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of deployment last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        ClickHouse version to use (e.g., "v25"). Changing this forces recreation of the deployment.
        """
        return pulumi.get(self, "version")

