# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DeploymentPublicNetwork',
    'DeploymentPublicNetworkService',
]

@pulumi.output_type
class DeploymentPublicNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsRecord":
            suggest = "dns_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPublicNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPublicNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPublicNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_record: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 services: Optional[Sequence['outputs.DeploymentPublicNetworkService']] = None):
        """
        :param _builtins.str dns_record: DNS record for the public endpoint.
        :param _builtins.str id: The ID of the public endpoint.
        :param Sequence['DeploymentPublicNetworkServiceArgs'] services: List of services exposed on the public endpoint.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[_builtins.str]:
        """
        DNS record for the public endpoint.
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the public endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.DeploymentPublicNetworkService']]:
        """
        List of services exposed on the public endpoint.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class DeploymentPublicNetworkService(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: TCP port number.
        :param _builtins.str protocol: Service protocol (e.g., "tcp", "https", "mysql").
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Service protocol (e.g., "tcp", "https", "mysql").
        """
        return pulumi.get(self, "protocol")


