# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RecordGeoIp',
    'RecordGeoIpMatch',
    'RecordHttpService',
    'RecordView',
    'RecordWeighted',
    'RegistrationAdministrativeContact',
    'RegistrationAdministrativeContactExtensionEu',
    'RegistrationAdministrativeContactExtensionFr',
    'RegistrationAdministrativeContactExtensionFrAssociationInfo',
    'RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationAdministrativeContactExtensionFrDunsInfo',
    'RegistrationAdministrativeContactExtensionFrIndividualInfo',
    'RegistrationAdministrativeContactExtensionFrTrademarkInfo',
    'RegistrationDsRecord',
    'RegistrationDsRecordDigest',
    'RegistrationDsRecordDigestPublicKey',
    'RegistrationDsRecordPublicKey',
    'RegistrationOwnerContact',
    'RegistrationOwnerContactExtensionEu',
    'RegistrationOwnerContactExtensionFr',
    'RegistrationOwnerContactExtensionFrAssociationInfo',
    'RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationOwnerContactExtensionFrDunsInfo',
    'RegistrationOwnerContactExtensionFrIndividualInfo',
    'RegistrationOwnerContactExtensionFrTrademarkInfo',
    'RegistrationTechnicalContact',
    'RegistrationTechnicalContactExtensionEu',
    'RegistrationTechnicalContactExtensionFr',
    'RegistrationTechnicalContactExtensionFrAssociationInfo',
    'RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationTechnicalContactExtensionFrDunsInfo',
    'RegistrationTechnicalContactExtensionFrIndividualInfo',
    'RegistrationTechnicalContactExtensionFrTrademarkInfo',
    'GetRecordGeoIpResult',
    'GetRecordGeoIpMatchResult',
    'GetRecordHttpServiceResult',
    'GetRecordViewResult',
    'GetRecordWeightedResult',
]

@pulumi.output_type
class RecordGeoIp(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.RecordGeoIpMatch']):
        """
        :param Sequence['RecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.RecordGeoIpMatch']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class RecordGeoIpMatch(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 continents: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param Sequence[_builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[_builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def continents(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")


@pulumi.output_type
class RecordHttpService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mustContain":
            suggest = "must_contain"
        elif key == "userAgent":
            suggest = "user_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordHttpService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordHttpService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordHttpService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Sequence[_builtins.str],
                 must_contain: _builtins.str,
                 strategy: _builtins.str,
                 url: _builtins.str,
                 user_agent: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] ips: IPs to check
        :param _builtins.str must_contain: Text to search
        :param _builtins.str strategy: Strategy to return an IP from the IPs list
        :param _builtins.str url: URL to match the must_contain text to validate an IP
        :param _builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> _builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[_builtins.str]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class RecordView(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 subnet: _builtins.str):
        """
        :param _builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param _builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class RecordWeighted(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip: The weighted IP
        :param _builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RegistrationAdministrativeContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: _builtins.str,
                 city: _builtins.str,
                 company_identification_code: _builtins.str,
                 country: _builtins.str,
                 email: _builtins.str,
                 firstname: _builtins.str,
                 lastname: _builtins.str,
                 legal_form: _builtins.str,
                 phone_number: _builtins.str,
                 vat_identification_code: _builtins.str,
                 zip: _builtins.str,
                 address_line2: Optional[_builtins.str] = None,
                 company_name: Optional[_builtins.str] = None,
                 email_alt: Optional[_builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationAdministrativeContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationAdministrativeContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[_builtins.str]] = None,
                 fax_number: Optional[_builtins.str] = None,
                 lang: Optional[_builtins.str] = None,
                 resale: Optional[_builtins.bool] = None,
                 state: Optional[_builtins.str] = None,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address_line1: Primary address line for the contact.
        :param _builtins.str city: City of the contact's address.
        :param _builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param _builtins.str country: Country code of the contact's address (ISO format).
        :param _builtins.str email: Primary email address of the contact.
        :param _builtins.str firstname: First name of the contact.
        :param _builtins.str lastname: Last name of the contact.
        :param _builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param _builtins.str phone_number: Primary phone number of the contact.
        :param _builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param _builtins.str zip: Postal code of the contact's address.
        :param _builtins.str address_line2: Secondary address line for the contact (optional).
        :param _builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param _builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationAdministrativeContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationAdministrativeContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[_builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param _builtins.str fax_number: Fax number for the contact (if available).
        :param _builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param _builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param _builtins.str state: State or region of the contact.
        :param _builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> _builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> _builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def firstname(self) -> _builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @_builtins.property
    @pulumi.getter
    def lastname(self) -> _builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @_builtins.property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> _builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> _builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @_builtins.property
    @pulumi.getter
    def zip(self) -> _builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @_builtins.property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[_builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @_builtins.property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[_builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @_builtins.property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[_builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @_builtins.property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @_builtins.property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @_builtins.property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def resale(self) -> Optional[_builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[_builtins.str] = None):
        """
        :param _builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @_builtins.property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[_builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[_builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationAdministrativeContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationAdministrativeContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationAdministrativeContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param _builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationAdministrativeContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @_builtins.property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @_builtins.property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @_builtins.property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[_builtins.str] = None,
                 publication_jo_page: Optional[_builtins.int] = None):
        """
        :param _builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param _builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @_builtins.property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[_builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @_builtins.property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[_builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[_builtins.str] = None):
        """
        :param _builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[_builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param _builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @_builtins.property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[_builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[_builtins.str] = None):
        """
        :param _builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @_builtins.property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[_builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class RegistrationDsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 digests: Optional[Sequence['outputs.RegistrationDsRecordDigest']] = None,
                 key_id: Optional[_builtins.int] = None,
                 public_keys: Optional[Sequence['outputs.RegistrationDsRecordPublicKey']] = None):
        """
        :param _builtins.str algorithm: The algorithm used for dnssec (e.g., rsasha256, ecdsap256sha256).
        :param Sequence['RegistrationDsRecordDigestArgs'] digests: Details about the digest.
        :param _builtins.int key_id: The identifier for the dnssec key.
        :param Sequence['RegistrationDsRecordPublicKeyArgs'] public_keys: Public key associated with the dnssec record.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digests is not None:
            pulumi.set(__self__, "digests", digests)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        The algorithm used for dnssec (e.g., rsasha256, ecdsap256sha256).
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digests(self) -> Optional[Sequence['outputs.RegistrationDsRecordDigest']]:
        """
        Details about the digest.
        """
        return pulumi.get(self, "digests")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.int]:
        """
        The identifier for the dnssec key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.RegistrationDsRecordPublicKey']]:
        """
        Public key associated with the dnssec record.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class RegistrationDsRecordDigest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDsRecordDigest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDsRecordDigest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDsRecordDigest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: Optional[_builtins.str] = None,
                 public_keys: Optional[Sequence['outputs.RegistrationDsRecordDigestPublicKey']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str digest: The digest value.
        :param Sequence['RegistrationDsRecordDigestPublicKeyArgs'] public_keys: The public key associated with the digest.
        :param _builtins.str type: The digest type for the DS record (e.g., sha_1, sha_256, gost_r_34_11_94, sha_384).
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[_builtins.str]:
        """
        The digest value.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.RegistrationDsRecordDigestPublicKey']]:
        """
        The public key associated with the digest.
        """
        return pulumi.get(self, "public_keys")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The digest type for the DS record (e.g., sha_1, sha_256, gost_r_34_11_94, sha_384).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RegistrationDsRecordDigestPublicKey(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: The public key value.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The public key value.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class RegistrationDsRecordPublicKey(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: The public key value.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The public key value.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class RegistrationOwnerContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: _builtins.str,
                 city: _builtins.str,
                 company_identification_code: _builtins.str,
                 country: _builtins.str,
                 email: _builtins.str,
                 firstname: _builtins.str,
                 lastname: _builtins.str,
                 legal_form: _builtins.str,
                 phone_number: _builtins.str,
                 vat_identification_code: _builtins.str,
                 zip: _builtins.str,
                 address_line2: Optional[_builtins.str] = None,
                 company_name: Optional[_builtins.str] = None,
                 email_alt: Optional[_builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationOwnerContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationOwnerContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[_builtins.str]] = None,
                 fax_number: Optional[_builtins.str] = None,
                 lang: Optional[_builtins.str] = None,
                 resale: Optional[_builtins.bool] = None,
                 state: Optional[_builtins.str] = None,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address_line1: Primary address line for the contact.
        :param _builtins.str city: City of the contact's address.
        :param _builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param _builtins.str country: Country code of the contact's address (ISO format).
        :param _builtins.str email: Primary email address of the contact.
        :param _builtins.str firstname: First name of the contact.
        :param _builtins.str lastname: Last name of the contact.
        :param _builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param _builtins.str phone_number: Primary phone number of the contact.
        :param _builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param _builtins.str zip: Postal code of the contact's address.
        :param _builtins.str address_line2: Secondary address line for the contact (optional).
        :param _builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param _builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationOwnerContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationOwnerContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[_builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param _builtins.str fax_number: Fax number for the contact (if available).
        :param _builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param _builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param _builtins.str state: State or region of the contact.
        :param _builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> _builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> _builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def firstname(self) -> _builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @_builtins.property
    @pulumi.getter
    def lastname(self) -> _builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @_builtins.property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> _builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> _builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @_builtins.property
    @pulumi.getter
    def zip(self) -> _builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @_builtins.property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[_builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @_builtins.property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[_builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @_builtins.property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[_builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @_builtins.property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationOwnerContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @_builtins.property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationOwnerContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @_builtins.property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def resale(self) -> Optional[_builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationOwnerContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[_builtins.str] = None):
        """
        :param _builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @_builtins.property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[_builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationOwnerContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationOwnerContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationOwnerContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationOwnerContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[_builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationOwnerContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationOwnerContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationOwnerContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationOwnerContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationOwnerContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param _builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationOwnerContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @_builtins.property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @_builtins.property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @_builtins.property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[_builtins.str] = None,
                 publication_jo_page: Optional[_builtins.int] = None):
        """
        :param _builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param _builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @_builtins.property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[_builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @_builtins.property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[_builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[_builtins.str] = None):
        """
        :param _builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[_builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param _builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @_builtins.property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[_builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[_builtins.str] = None):
        """
        :param _builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @_builtins.property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[_builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class RegistrationTechnicalContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: _builtins.str,
                 city: _builtins.str,
                 company_identification_code: _builtins.str,
                 country: _builtins.str,
                 email: _builtins.str,
                 firstname: _builtins.str,
                 lastname: _builtins.str,
                 legal_form: _builtins.str,
                 phone_number: _builtins.str,
                 vat_identification_code: _builtins.str,
                 zip: _builtins.str,
                 address_line2: Optional[_builtins.str] = None,
                 company_name: Optional[_builtins.str] = None,
                 email_alt: Optional[_builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationTechnicalContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationTechnicalContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[_builtins.str]] = None,
                 fax_number: Optional[_builtins.str] = None,
                 lang: Optional[_builtins.str] = None,
                 resale: Optional[_builtins.bool] = None,
                 state: Optional[_builtins.str] = None,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address_line1: Primary address line for the contact.
        :param _builtins.str city: City of the contact's address.
        :param _builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param _builtins.str country: Country code of the contact's address (ISO format).
        :param _builtins.str email: Primary email address of the contact.
        :param _builtins.str firstname: First name of the contact.
        :param _builtins.str lastname: Last name of the contact.
        :param _builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param _builtins.str phone_number: Primary phone number of the contact.
        :param _builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param _builtins.str zip: Postal code of the contact's address.
        :param _builtins.str address_line2: Secondary address line for the contact (optional).
        :param _builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param _builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationTechnicalContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationTechnicalContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[_builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param _builtins.str fax_number: Fax number for the contact (if available).
        :param _builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param _builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param _builtins.str state: State or region of the contact.
        :param _builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> _builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> _builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def firstname(self) -> _builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @_builtins.property
    @pulumi.getter
    def lastname(self) -> _builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @_builtins.property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> _builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> _builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @_builtins.property
    @pulumi.getter
    def zip(self) -> _builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @_builtins.property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[_builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @_builtins.property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[_builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @_builtins.property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[_builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @_builtins.property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationTechnicalContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @_builtins.property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @_builtins.property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def resale(self) -> Optional[_builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationTechnicalContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[_builtins.str] = None):
        """
        :param _builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @_builtins.property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[_builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationTechnicalContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationTechnicalContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationTechnicalContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[_builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationTechnicalContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationTechnicalContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationTechnicalContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationTechnicalContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param _builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationTechnicalContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @_builtins.property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @_builtins.property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @_builtins.property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[_builtins.str] = None,
                 publication_jo_page: Optional[_builtins.int] = None):
        """
        :param _builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param _builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @_builtins.property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[_builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @_builtins.property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[_builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[_builtins.str] = None):
        """
        :param _builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @_builtins.property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[_builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[_builtins.str] = None,
                 local_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param _builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @_builtins.property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[_builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[_builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @_builtins.property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[_builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[_builtins.str] = None):
        """
        :param _builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @_builtins.property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[_builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class GetRecordGeoIpResult(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.GetRecordGeoIpMatchResult']):
        """
        :param Sequence['GetRecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetRecordGeoIpMatchResult']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class GetRecordGeoIpMatchResult(dict):
    def __init__(__self__, *,
                 continents: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 data: _builtins.str):
        """
        :param Sequence[_builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[_builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        :param _builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        pulumi.set(__self__, "continents", continents)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def continents(self) -> Sequence[_builtins.str]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GetRecordHttpServiceResult(dict):
    def __init__(__self__, *,
                 ips: Sequence[_builtins.str],
                 must_contain: _builtins.str,
                 strategy: _builtins.str,
                 url: _builtins.str,
                 user_agent: _builtins.str):
        """
        :param Sequence[_builtins.str] ips: IPs to check
        :param _builtins.str must_contain: Text to search
        :param _builtins.str strategy: Strategy to return an IP from the IPs list
        :param _builtins.str url: URL to match the must_contain text to validate an IP
        :param _builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_agent", user_agent)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> _builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> _builtins.str:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetRecordViewResult(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 subnet: _builtins.str):
        """
        :param _builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        :param _builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetRecordWeightedResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip: The weighted IP
        :param _builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


