# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeServicesHeadStageArgs', 'EdgeServicesHeadStage']

@pulumi.input_type
class EdgeServicesHeadStageArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[_builtins.str],
                 head_stage_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesHeadStage resource.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] head_stage_id: The ID of head stage of the pipeline.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if head_stage_id is not None:
            pulumi.set(__self__, "head_stage_id", head_stage_id)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="headStageId")
    def head_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of head stage of the pipeline.
        """
        return pulumi.get(self, "head_stage_id")

    @head_stage_id.setter
    def head_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_stage_id", value)


@pulumi.input_type
class _EdgeServicesHeadStageState:
    def __init__(__self__, *,
                 head_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesHeadStage resources.
        :param pulumi.Input[_builtins.str] head_stage_id: The ID of head stage of the pipeline.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        """
        if head_stage_id is not None:
            pulumi.set(__self__, "head_stage_id", head_stage_id)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)

    @_builtins.property
    @pulumi.getter(name="headStageId")
    def head_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of head stage of the pipeline.
        """
        return pulumi.get(self, "head_stage_id")

    @head_stage_id.setter
    def head_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_stage_id", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)


@pulumi.type_token("scaleway:index/edgeServicesHeadStage:EdgeServicesHeadStage")
class EdgeServicesHeadStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 head_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Sets the Scaleway Edge Services head stage of your pipeline.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="my-edge_services-pipeline",
            description="pipeline description")
        main_edge_services_dns_stage = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main.id,
            tls_stage_id=main_scaleway_edge_services_tls_stage["id"],
            fqdns=["subdomain.example.com"])
        main_edge_services_head_stage = scaleway.EdgeServicesHeadStage("main",
            pipeline_id=main.id,
            head_stage_id=main_edge_services_dns_stage.id)
        ```

        ## Import

        Head stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesHeadStage:EdgeServicesHeadStage main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] head_stage_id: The ID of head stage of the pipeline.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesHeadStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets the Scaleway Edge Services head stage of your pipeline.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="my-edge_services-pipeline",
            description="pipeline description")
        main_edge_services_dns_stage = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main.id,
            tls_stage_id=main_scaleway_edge_services_tls_stage["id"],
            fqdns=["subdomain.example.com"])
        main_edge_services_head_stage = scaleway.EdgeServicesHeadStage("main",
            pipeline_id=main.id,
            head_stage_id=main_edge_services_dns_stage.id)
        ```

        ## Import

        Head stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesHeadStage:EdgeServicesHeadStage main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesHeadStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesHeadStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 head_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesHeadStageArgs.__new__(EdgeServicesHeadStageArgs)

            __props__.__dict__["head_stage_id"] = head_stage_id
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
        super(EdgeServicesHeadStage, __self__).__init__(
            'scaleway:index/edgeServicesHeadStage:EdgeServicesHeadStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            head_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeServicesHeadStage':
        """
        Get an existing EdgeServicesHeadStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] head_stage_id: The ID of head stage of the pipeline.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesHeadStageState.__new__(_EdgeServicesHeadStageState)

        __props__.__dict__["head_stage_id"] = head_stage_id
        __props__.__dict__["pipeline_id"] = pipeline_id
        return EdgeServicesHeadStage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="headStageId")
    def head_stage_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of head stage of the pipeline.
        """
        return pulumi.get(self, "head_stage_id")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

