# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeServicesRouteStageArgs', 'EdgeServicesRouteStage']

@pulumi.input_type
class EdgeServicesRouteStageArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]] = None,
                 waf_stage_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesRouteStage resource.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the route stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]] rules: The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        :param pulumi.Input[_builtins.str] waf_stage_id: The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if waf_stage_id is not None:
            pulumi.set(__self__, "waf_stage_id", waf_stage_id)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the route stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]]:
        """
        The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        return pulumi.get(self, "waf_stage_id")

    @waf_stage_id.setter
    def waf_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_stage_id", value)


@pulumi.input_type
class _EdgeServicesRouteStageState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_stage_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesRouteStage resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the route stage.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the route stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]] rules: The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the route stage.
        :param pulumi.Input[_builtins.str] waf_stage_id: The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if waf_stage_id is not None:
            pulumi.set(__self__, "waf_stage_id", waf_stage_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the route stage.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the route stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]]:
        """
        The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesRouteStageRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the route stage.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        return pulumi.get(self, "waf_stage_id")

    @waf_stage_id.setter
    def waf_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_stage_id", value)


@pulumi.type_token("scaleway:index/edgeServicesRouteStage:EdgeServicesRouteStage")
class EdgeServicesRouteStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesRouteStageRuleArgs', 'EdgeServicesRouteStageRuleArgsDict']]]]] = None,
                 waf_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services Route Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesRouteStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            waf_stage_id=waf["id"],
            rules=[{
                "backend_stage_id": backend["id"],
                "rule_http_match": {
                    "method_filters": [
                        "get",
                        "post",
                    ],
                    "path_filter": {
                        "path_filter_type": "regex",
                        "value": ".*",
                    },
                },
            }])
        ```

        ## Import

        Route stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesRouteStage:EdgeServicesRouteStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the route stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesRouteStageRuleArgs', 'EdgeServicesRouteStageRuleArgsDict']]]] rules: The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        :param pulumi.Input[_builtins.str] waf_stage_id: The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesRouteStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services Route Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesRouteStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            waf_stage_id=waf["id"],
            rules=[{
                "backend_stage_id": backend["id"],
                "rule_http_match": {
                    "method_filters": [
                        "get",
                        "post",
                    ],
                    "path_filter": {
                        "path_filter_type": "regex",
                        "value": ".*",
                    },
                },
            }])
        ```

        ## Import

        Route stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesRouteStage:EdgeServicesRouteStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesRouteStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesRouteStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesRouteStageRuleArgs', 'EdgeServicesRouteStageRuleArgsDict']]]]] = None,
                 waf_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesRouteStageArgs.__new__(EdgeServicesRouteStageArgs)

            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["rules"] = rules
            __props__.__dict__["waf_stage_id"] = waf_stage_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesRouteStage, __self__).__init__(
            'scaleway:index/edgeServicesRouteStage:EdgeServicesRouteStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesRouteStageRuleArgs', 'EdgeServicesRouteStageRuleArgsDict']]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            waf_stage_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeServicesRouteStage':
        """
        Get an existing EdgeServicesRouteStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the route stage.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the route stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesRouteStageRuleArgs', 'EdgeServicesRouteStageRuleArgsDict']]]] rules: The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the route stage.
        :param pulumi.Input[_builtins.str] waf_stage_id: The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesRouteStageState.__new__(_EdgeServicesRouteStageState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["waf_stage_id"] = waf_stage_id
        return EdgeServicesRouteStage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the route stage.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the route stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeServicesRouteStageRule']]]:
        """
        The list of rules to be checked against every HTTP request. The first matching rule will forward the request to its specified backend stage. If no rules are matched, the request is forwarded to the WAF stage defined by `waf_stage_id`.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the route stage.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the WAF stage HTTP requests should be forwarded to when no rules are matched.
        """
        return pulumi.get(self, "waf_stage_id")

