# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPartitionSchemaResult',
    'AwaitableGetPartitionSchemaResult',
    'get_partition_schema',
    'get_partition_schema_output',
]

@pulumi.output_type
class GetPartitionSchemaResult:
    """
    A collection of values returned by getPartitionSchema.
    """
    def __init__(__self__, ext4_mountpoint=None, extra_partition=None, id=None, json_partition=None, offer_id=None, os_id=None, swap=None):
        if ext4_mountpoint and not isinstance(ext4_mountpoint, str):
            raise TypeError("Expected argument 'ext4_mountpoint' to be a str")
        pulumi.set(__self__, "ext4_mountpoint", ext4_mountpoint)
        if extra_partition and not isinstance(extra_partition, bool):
            raise TypeError("Expected argument 'extra_partition' to be a bool")
        pulumi.set(__self__, "extra_partition", extra_partition)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json_partition and not isinstance(json_partition, str):
            raise TypeError("Expected argument 'json_partition' to be a str")
        pulumi.set(__self__, "json_partition", json_partition)
        if offer_id and not isinstance(offer_id, str):
            raise TypeError("Expected argument 'offer_id' to be a str")
        pulumi.set(__self__, "offer_id", offer_id)
        if os_id and not isinstance(os_id, str):
            raise TypeError("Expected argument 'os_id' to be a str")
        pulumi.set(__self__, "os_id", os_id)
        if swap and not isinstance(swap, bool):
            raise TypeError("Expected argument 'swap' to be a bool")
        pulumi.set(__self__, "swap", swap)

    @_builtins.property
    @pulumi.getter(name="ext4Mountpoint")
    def ext4_mountpoint(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ext4_mountpoint")

    @_builtins.property
    @pulumi.getter(name="extraPartition")
    def extra_partition(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "extra_partition")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jsonPartition")
    def json_partition(self) -> _builtins.str:
        """
        — A validated partitioning schema in JSON format that can be directly used for BareMetal server deployment.
        """
        return pulumi.get(self, "json_partition")

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> _builtins.str:
        return pulumi.get(self, "offer_id")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> _builtins.str:
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def swap(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "swap")


class AwaitableGetPartitionSchemaResult(GetPartitionSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPartitionSchemaResult(
            ext4_mountpoint=self.ext4_mountpoint,
            extra_partition=self.extra_partition,
            id=self.id,
            json_partition=self.json_partition,
            offer_id=self.offer_id,
            os_id=self.os_id,
            swap=self.swap)


def get_partition_schema(ext4_mountpoint: Optional[_builtins.str] = None,
                         extra_partition: Optional[_builtins.bool] = None,
                         offer_id: Optional[_builtins.str] = None,
                         os_id: Optional[_builtins.str] = None,
                         swap: Optional[_builtins.bool] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPartitionSchemaResult:
    """
    The elasticmetal_get_partition_schema data source allows you to retrieve a ready-to-use partitioning schema for a BareMetal server. This schema can be used for custom installations with optional swap and extra partitions.

    This data source simplifies the process of generating valid partitioning configurations, especially useful when dealing with OS and offer compatibility requirements.

    ## Partitioning Details

    The partitioning schema generated by the `elasticmetal_get_partition_schema` data source includes a root (`/`) partition that is **20GB** in size by default.

    If additional storage is required, you can enable the `extra_partition` option to mount extra space on a custom path (e.g., `/data`).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    default = scaleway.elasticmetal.get_partition_schema(offer_id="11111111-1111-1111-1111-111111111111",
        os_id="22222222-2222-2222-2222-222222222222",
        swap=True,
        extra_partition=True,
        ext4_mountpoint="/data")
    ```


    :param _builtins.str ext4_mountpoint: The mount point for the extra partition. Must be an absolute path using alphanumeric characters and underscores.
    :param _builtins.bool extra_partition: Whether to add an extra ext4 data partition.
    :param _builtins.str offer_id: The UUID of the BareMetal offer.
    :param _builtins.str os_id: The UUID of the OS image.
    :param _builtins.bool swap: Whether to include a swap partition.
    """
    __args__ = dict()
    __args__['ext4Mountpoint'] = ext4_mountpoint
    __args__['extraPartition'] = extra_partition
    __args__['offerId'] = offer_id
    __args__['osId'] = os_id
    __args__['swap'] = swap
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:elasticmetal/getPartitionSchema:getPartitionSchema', __args__, opts=opts, typ=GetPartitionSchemaResult).value

    return AwaitableGetPartitionSchemaResult(
        ext4_mountpoint=pulumi.get(__ret__, 'ext4_mountpoint'),
        extra_partition=pulumi.get(__ret__, 'extra_partition'),
        id=pulumi.get(__ret__, 'id'),
        json_partition=pulumi.get(__ret__, 'json_partition'),
        offer_id=pulumi.get(__ret__, 'offer_id'),
        os_id=pulumi.get(__ret__, 'os_id'),
        swap=pulumi.get(__ret__, 'swap'))
def get_partition_schema_output(ext4_mountpoint: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                extra_partition: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                                os_id: Optional[pulumi.Input[_builtins.str]] = None,
                                swap: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPartitionSchemaResult]:
    """
    The elasticmetal_get_partition_schema data source allows you to retrieve a ready-to-use partitioning schema for a BareMetal server. This schema can be used for custom installations with optional swap and extra partitions.

    This data source simplifies the process of generating valid partitioning configurations, especially useful when dealing with OS and offer compatibility requirements.

    ## Partitioning Details

    The partitioning schema generated by the `elasticmetal_get_partition_schema` data source includes a root (`/`) partition that is **20GB** in size by default.

    If additional storage is required, you can enable the `extra_partition` option to mount extra space on a custom path (e.g., `/data`).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    default = scaleway.elasticmetal.get_partition_schema(offer_id="11111111-1111-1111-1111-111111111111",
        os_id="22222222-2222-2222-2222-222222222222",
        swap=True,
        extra_partition=True,
        ext4_mountpoint="/data")
    ```


    :param _builtins.str ext4_mountpoint: The mount point for the extra partition. Must be an absolute path using alphanumeric characters and underscores.
    :param _builtins.bool extra_partition: Whether to add an extra ext4 data partition.
    :param _builtins.str offer_id: The UUID of the BareMetal offer.
    :param _builtins.str os_id: The UUID of the OS image.
    :param _builtins.bool swap: Whether to include a swap partition.
    """
    __args__ = dict()
    __args__['ext4Mountpoint'] = ext4_mountpoint
    __args__['extraPartition'] = extra_partition
    __args__['offerId'] = offer_id
    __args__['osId'] = os_id
    __args__['swap'] = swap
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:elasticmetal/getPartitionSchema:getPartitionSchema', __args__, opts=opts, typ=GetPartitionSchemaResult)
    return __ret__.apply(lambda __response__: GetPartitionSchemaResult(
        ext4_mountpoint=pulumi.get(__response__, 'ext4_mountpoint'),
        extra_partition=pulumi.get(__response__, 'extra_partition'),
        id=pulumi.get(__response__, 'id'),
        json_partition=pulumi.get(__response__, 'json_partition'),
        offer_id=pulumi.get(__response__, 'offer_id'),
        os_id=pulumi.get(__response__, 'os_id'),
        swap=pulumi.get(__response__, 'swap')))
