# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServerIp',
    'ServerIpv4',
    'ServerIpv6',
    'ServerOption',
    'ServerPrivateIp',
    'ServerPrivateNetwork',
    'GetIpsIpResult',
    'GetIpsIpMacAddressResult',
    'GetOfferCpuResult',
    'GetOfferDiskResult',
    'GetOfferMemoryResult',
    'GetServerIpResult',
    'GetServerIpv4Result',
    'GetServerIpv6Result',
    'GetServerOptionResult',
    'GetServerPrivateIpResult',
    'GetServerPrivateNetworkResult',
]

@pulumi.output_type
class ServerIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerIpv4(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerIpv6(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 expires_at: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        :param _builtins.str expires_at: The auto expiration date for compatible options
        :param _builtins.str name: The name of the server.
        """
        pulumi.set(__self__, "id", id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[_builtins.str]:
        """
        The auto expiration date for compatible options
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "mappingId":
            suggest = "mapping_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 created_at: Optional[_builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[_builtins.str]] = None,
                 mapping_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 vlan: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The id of the private network to attach.
        :param _builtins.str created_at: The date and time of the creation of the private network.
        :param Sequence[_builtins.str] ipam_ip_ids: List of IPAM IP IDs to assign to the server in the requested private network.
        :param _builtins.str mapping_id: The ID of the Server-to-Private Network mapping.
        :param _builtins.str status: The private network status.
        :param _builtins.str updated_at: The date and time of the last update of the private network.
        :param _builtins.int vlan: The VLAN ID associated to the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if mapping_id is not None:
            pulumi.set(__self__, "mapping_id", mapping_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the private network.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPAM IP IDs to assign to the server in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Server-to-Private Network mapping.
        """
        return pulumi.get(self, "mapping_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The private network status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the private network.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.int]:
        """
        The VLAN ID associated to the private network.
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class GetIpsIpResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 mac_addresses: Sequence['outputs.GetIpsIpMacAddressResult'],
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 reverse: _builtins.str,
                 status: _builtins.str,
                 tags: Sequence[_builtins.str],
                 updated_at: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param _builtins.str description: The description of the flexible IP.
        :param _builtins.str id: The MAC address ID.
        :param _builtins.str ip_address: IP address of the flexible IP
        :param Sequence['GetIpsIpMacAddressArgs'] mac_addresses: The MAC address of the Virtual MAC.
        :param _builtins.str organization_id: (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        :param _builtins.str project_id: (Defaults to provider `project_id`) The ID of the project the IP is in.
        :param _builtins.str reverse: The reverse domain associated with this IP.
        :param _builtins.str status: The status of virtual MAC.
        :param Sequence[_builtins.str] tags: List of tags used as filter. IPs with these exact tags are listed.
        :param _builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param _builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_addresses", mac_addresses)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the flexible IP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        IP address of the flexible IP
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Sequence['outputs.GetIpsIpMacAddressResult']:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_addresses")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        (Defaults to provider `project_id`) The ID of the project the IP is in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags used as filter. IPs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetIpsIpMacAddressResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 mac_address: _builtins.str,
                 mac_type: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param _builtins.str id: The MAC address ID.
        :param _builtins.str mac_address: The MAC address of the Virtual MAC.
        :param _builtins.str mac_type: The type of virtual MAC.
        :param _builtins.str status: The status of virtual MAC.
        :param _builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param _builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mac_type", mac_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="macType")
    def mac_type(self) -> _builtins.str:
        """
        The type of virtual MAC.
        """
        return pulumi.get(self, "mac_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetOfferCpuResult(dict):
    def __init__(__self__, *,
                 core_count: _builtins.int,
                 frequency: _builtins.int,
                 name: _builtins.str,
                 thread_count: _builtins.int):
        """
        :param _builtins.int core_count: Number of core on this CPU.
        :param _builtins.int frequency: Frequency of the memory in MHz.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.int thread_count: Number of thread on this CPU.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thread_count", thread_count)

    @_builtins.property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> _builtins.int:
        """
        Number of core on this CPU.
        """
        return pulumi.get(self, "core_count")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="threadCount")
    def thread_count(self) -> _builtins.int:
        """
        Number of thread on this CPU.
        """
        return pulumi.get(self, "thread_count")


@pulumi.output_type
class GetOfferDiskResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int capacity: Capacity of the memory in GB.
        :param _builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOfferMemoryResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 frequency: _builtins.int,
                 is_ecc: _builtins.bool,
                 type: _builtins.str):
        """
        :param _builtins.int capacity: Capacity of the memory in GB.
        :param _builtins.int frequency: Frequency of the memory in MHz.
        :param _builtins.bool is_ecc: True if error-correcting code is available on this memory.
        :param _builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "is_ecc", is_ecc)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="isEcc")
    def is_ecc(self) -> _builtins.bool:
        """
        True if error-correcting code is available on this memory.
        """
        return pulumi.get(self, "is_ecc")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerIpv4Result(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerIpv6Result(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerOptionResult(dict):
    def __init__(__self__, *,
                 expires_at: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str expires_at: Auto expire the option after this date
        :param _builtins.str id: The ID of the server.
        :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> _builtins.str:
        """
        Auto expire the option after this date
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the server.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 ipam_ip_ids: Sequence[_builtins.str],
                 mapping_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 vlan: _builtins.int):
        """
        :param _builtins.str created_at: The date and time of the creation of the private network
        :param _builtins.str id: The ID of the server.
        :param Sequence[_builtins.str] ipam_ip_ids: List of IPAM IP IDs to attach to the server
        :param _builtins.str mapping_id: The ID of the Server-to-Private Network mapping
        :param _builtins.str status: The private network status
        :param _builtins.str updated_at: The date and time of the last update of the private network
        :param _builtins.int vlan: The VLAN ID associated to the private network
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        pulumi.set(__self__, "mapping_id", mapping_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the private network
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Sequence[_builtins.str]:
        """
        List of IPAM IP IDs to attach to the server
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> _builtins.str:
        """
        The ID of the Server-to-Private Network mapping
        """
        return pulumi.get(self, "mapping_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The private network status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the private network
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> _builtins.int:
        """
        The VLAN ID associated to the private network
        """
        return pulumi.get(self, "vlan")


