# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBaremetalOsResult',
    'AwaitableGetBaremetalOsResult',
    'get_baremetal_os',
    'get_baremetal_os_output',
]

warnings.warn("""scaleway.index/getbaremetalos.getBaremetalOs has been deprecated in favor of scaleway.elasticmetal/getos.getOs""", DeprecationWarning)

@pulumi.output_type
class GetBaremetalOsResult:
    """
    A collection of values returned by getBaremetalOs.
    """
    def __init__(__self__, id=None, name=None, os_id=None, version=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_id and not isinstance(os_id, str):
            raise TypeError("Expected argument 'os_id' to be a str")
        pulumi.set(__self__, "os_id", os_id)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "os_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetBaremetalOsResult(GetBaremetalOsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBaremetalOsResult(
            id=self.id,
            name=self.name,
            os_id=self.os_id,
            version=self.version,
            zone=self.zone)


def get_baremetal_os(name: Optional[_builtins.str] = None,
                     os_id: Optional[_builtins.str] = None,
                     version: Optional[_builtins.str] = None,
                     zone: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBaremetalOsResult:
    """
    Gets information about a baremetal operating system.
    For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses).

    You can also use the [scaleway-cli](https://github.com/scaleway/scaleway-cli) with `scw baremetal os list` to list all available operating systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by os name and version
    by_name = scaleway.elasticmetal.get_os(name="Ubuntu",
        version="20.04 LTS (Focal Fossa)")
    # Get info by os id
    by_id = scaleway.elasticmetal.get_os(os_id="03b7f4ba-a6a1-4305-984e-b54fafbf1681")
    ```


    :param _builtins.str name: The os name. Only one of `name` and `os_id` should be specified.
    :param _builtins.str os_id: The operating system id. Only one of `name` and `os_id` should be specified.
    :param _builtins.str version: The os version.
    :param _builtins.str zone: `zone`) The zone in which the os exists.
    """
    pulumi.log.warn("""get_baremetal_os is deprecated: scaleway.index/getbaremetalos.getBaremetalOs has been deprecated in favor of scaleway.elasticmetal/getos.getOs""")
    __args__ = dict()
    __args__['name'] = name
    __args__['osId'] = os_id
    __args__['version'] = version
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getBaremetalOs:getBaremetalOs', __args__, opts=opts, typ=GetBaremetalOsResult).value

    return AwaitableGetBaremetalOsResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        os_id=pulumi.get(__ret__, 'os_id'),
        version=pulumi.get(__ret__, 'version'),
        zone=pulumi.get(__ret__, 'zone'))
def get_baremetal_os_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            os_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBaremetalOsResult]:
    """
    Gets information about a baremetal operating system.
    For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses).

    You can also use the [scaleway-cli](https://github.com/scaleway/scaleway-cli) with `scw baremetal os list` to list all available operating systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by os name and version
    by_name = scaleway.elasticmetal.get_os(name="Ubuntu",
        version="20.04 LTS (Focal Fossa)")
    # Get info by os id
    by_id = scaleway.elasticmetal.get_os(os_id="03b7f4ba-a6a1-4305-984e-b54fafbf1681")
    ```


    :param _builtins.str name: The os name. Only one of `name` and `os_id` should be specified.
    :param _builtins.str os_id: The operating system id. Only one of `name` and `os_id` should be specified.
    :param _builtins.str version: The os version.
    :param _builtins.str zone: `zone`) The zone in which the os exists.
    """
    pulumi.log.warn("""get_baremetal_os is deprecated: scaleway.index/getbaremetalos.getBaremetalOs has been deprecated in favor of scaleway.elasticmetal/getos.getOs""")
    __args__ = dict()
    __args__['name'] = name
    __args__['osId'] = os_id
    __args__['version'] = version
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getBaremetalOs:getBaremetalOs', __args__, opts=opts, typ=GetBaremetalOsResult)
    return __ret__.apply(lambda __response__: GetBaremetalOsResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        os_id=pulumi.get(__response__, 'os_id'),
        version=pulumi.get(__response__, 'version'),
        zone=pulumi.get(__response__, 'zone')))
