# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetInstanceIpResult',
    'AwaitableGetInstanceIpResult',
    'get_instance_ip',
    'get_instance_ip_output',
]

warnings.warn("""scaleway.index/getinstanceip.getInstanceIp has been deprecated in favor of scaleway.instance/getip.getIp""", DeprecationWarning)

@pulumi.output_type
class GetInstanceIpResult:
    """
    A collection of values returned by getInstanceIp.
    """
    def __init__(__self__, address=None, id=None, organization_id=None, prefix=None, project_id=None, reverse=None, server_id=None, tags=None, type=None, zone=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The organization ID the IP is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The IP Prefix.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The reverse dns attached to this IP
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the IP
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetInstanceIpResult(GetInstanceIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceIpResult(
            address=self.address,
            id=self.id,
            organization_id=self.organization_id,
            prefix=self.prefix,
            project_id=self.project_id,
            reverse=self.reverse,
            server_id=self.server_id,
            tags=self.tags,
            type=self.type,
            zone=self.zone)


def get_instance_ip(address: Optional[_builtins.str] = None,
                    id: Optional[_builtins.str] = None,
                    project_id: Optional[_builtins.str] = None,
                    zone: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceIpResult:
    """
    Gets information about an instance IP.


    :param _builtins.str address: The IPv4 address to retrieve
           Only one of `address` and `id` should be specified.
    :param _builtins.str id: The ID of the IP address to retrieve
           Only one of `address` and `id` should be specified.
    :param _builtins.str project_id: `project_id`) The ID of the project the IP is associated with.
    :param _builtins.str zone: `zone`) The zone in which the IP should be reserved.
    """
    pulumi.log.warn("""get_instance_ip is deprecated: scaleway.index/getinstanceip.getInstanceIp has been deprecated in favor of scaleway.instance/getip.getIp""")
    __args__ = dict()
    __args__['address'] = address
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getInstanceIp:getInstanceIp', __args__, opts=opts, typ=GetInstanceIpResult).value

    return AwaitableGetInstanceIpResult(
        address=pulumi.get(__ret__, 'address'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        prefix=pulumi.get(__ret__, 'prefix'),
        project_id=pulumi.get(__ret__, 'project_id'),
        reverse=pulumi.get(__ret__, 'reverse'),
        server_id=pulumi.get(__ret__, 'server_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        zone=pulumi.get(__ret__, 'zone'))
def get_instance_ip_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceIpResult]:
    """
    Gets information about an instance IP.


    :param _builtins.str address: The IPv4 address to retrieve
           Only one of `address` and `id` should be specified.
    :param _builtins.str id: The ID of the IP address to retrieve
           Only one of `address` and `id` should be specified.
    :param _builtins.str project_id: `project_id`) The ID of the project the IP is associated with.
    :param _builtins.str zone: `zone`) The zone in which the IP should be reserved.
    """
    pulumi.log.warn("""get_instance_ip is deprecated: scaleway.index/getinstanceip.getInstanceIp has been deprecated in favor of scaleway.instance/getip.getIp""")
    __args__ = dict()
    __args__['address'] = address
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getInstanceIp:getInstanceIp', __args__, opts=opts, typ=GetInstanceIpResult)
    return __ret__.apply(lambda __response__: GetInstanceIpResult(
        address=pulumi.get(__response__, 'address'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        prefix=pulumi.get(__response__, 'prefix'),
        project_id=pulumi.get(__response__, 'project_id'),
        reverse=pulumi.get(__response__, 'reverse'),
        server_id=pulumi.get(__response__, 'server_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        zone=pulumi.get(__response__, 'zone')))
