# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetK8sVersionResult',
    'AwaitableGetK8sVersionResult',
    'get_k8s_version',
    'get_k8s_version_output',
]

warnings.warn("""scaleway.index/getk8sversion.getK8sVersion has been deprecated in favor of scaleway.kubernetes/getversion.getVersion""", DeprecationWarning)

@pulumi.output_type
class GetK8sVersionResult:
    """
    A collection of values returned by getK8sVersion.
    """
    def __init__(__self__, available_cnis=None, available_container_runtimes=None, available_feature_gates=None, id=None, major_minor_only=None, name=None, region=None):
        if available_cnis and not isinstance(available_cnis, list):
            raise TypeError("Expected argument 'available_cnis' to be a list")
        pulumi.set(__self__, "available_cnis", available_cnis)
        if available_container_runtimes and not isinstance(available_container_runtimes, list):
            raise TypeError("Expected argument 'available_container_runtimes' to be a list")
        pulumi.set(__self__, "available_container_runtimes", available_container_runtimes)
        if available_feature_gates and not isinstance(available_feature_gates, list):
            raise TypeError("Expected argument 'available_feature_gates' to be a list")
        pulumi.set(__self__, "available_feature_gates", available_feature_gates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if major_minor_only and not isinstance(major_minor_only, str):
            raise TypeError("Expected argument 'major_minor_only' to be a str")
        pulumi.set(__self__, "major_minor_only", major_minor_only)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="availableCnis")
    def available_cnis(self) -> Sequence[_builtins.str]:
        """
        The list of supported Container Network Interface (CNI) plugins for this version.
        """
        return pulumi.get(self, "available_cnis")

    @_builtins.property
    @pulumi.getter(name="availableContainerRuntimes")
    def available_container_runtimes(self) -> Sequence[_builtins.str]:
        """
        The list of supported container runtimes for this version.
        """
        return pulumi.get(self, "available_container_runtimes")

    @_builtins.property
    @pulumi.getter(name="availableFeatureGates")
    def available_feature_gates(self) -> Sequence[_builtins.str]:
        """
        The list of supported feature gates for this version.
        """
        return pulumi.get(self, "available_feature_gates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="majorMinorOnly")
    def major_minor_only(self) -> _builtins.str:
        return pulumi.get(self, "major_minor_only")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetK8sVersionResult(GetK8sVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetK8sVersionResult(
            available_cnis=self.available_cnis,
            available_container_runtimes=self.available_container_runtimes,
            available_feature_gates=self.available_feature_gates,
            id=self.id,
            major_minor_only=self.major_minor_only,
            name=self.name,
            region=self.region)


def get_k8s_version(name: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetK8sVersionResult:
    """
    Gets information about a Kubernetes version.
    For more information, see the [API documentation](https://developers.scaleway.com/en/products/k8s/api).

    You can also use the [scaleway-cli](https://github.com/scaleway/scaleway-cli) with `scw k8s version list` to list all available versions.

    ## Example Usage

    ### Use the latest version

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    latest = scaleway.kubernetes.get_version(name="latest")
    ```

    ### Use a specific version

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_name = scaleway.kubernetes.get_version(name="1.26.0")
    ```


    :param _builtins.str name: The name of the Kubernetes version.
    :param _builtins.str region: `region`) The region in which the version exists.
    """
    pulumi.log.warn("""get_k8s_version is deprecated: scaleway.index/getk8sversion.getK8sVersion has been deprecated in favor of scaleway.kubernetes/getversion.getVersion""")
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getK8sVersion:getK8sVersion', __args__, opts=opts, typ=GetK8sVersionResult).value

    return AwaitableGetK8sVersionResult(
        available_cnis=pulumi.get(__ret__, 'available_cnis'),
        available_container_runtimes=pulumi.get(__ret__, 'available_container_runtimes'),
        available_feature_gates=pulumi.get(__ret__, 'available_feature_gates'),
        id=pulumi.get(__ret__, 'id'),
        major_minor_only=pulumi.get(__ret__, 'major_minor_only'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_k8s_version_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetK8sVersionResult]:
    """
    Gets information about a Kubernetes version.
    For more information, see the [API documentation](https://developers.scaleway.com/en/products/k8s/api).

    You can also use the [scaleway-cli](https://github.com/scaleway/scaleway-cli) with `scw k8s version list` to list all available versions.

    ## Example Usage

    ### Use the latest version

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    latest = scaleway.kubernetes.get_version(name="latest")
    ```

    ### Use a specific version

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_name = scaleway.kubernetes.get_version(name="1.26.0")
    ```


    :param _builtins.str name: The name of the Kubernetes version.
    :param _builtins.str region: `region`) The region in which the version exists.
    """
    pulumi.log.warn("""get_k8s_version is deprecated: scaleway.index/getk8sversion.getK8sVersion has been deprecated in favor of scaleway.kubernetes/getversion.getVersion""")
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getK8sVersion:getK8sVersion', __args__, opts=opts, typ=GetK8sVersionResult)
    return __ret__.apply(lambda __response__: GetK8sVersionResult(
        available_cnis=pulumi.get(__response__, 'available_cnis'),
        available_container_runtimes=pulumi.get(__response__, 'available_container_runtimes'),
        available_feature_gates=pulumi.get(__response__, 'available_feature_gates'),
        id=pulumi.get(__response__, 'id'),
        major_minor_only=pulumi.get(__response__, 'major_minor_only'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
