# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HostingCpanelUrl',
    'HostingNameServer',
    'HostingOption',
    'HostingRecord',
    'GetHostingCpanelUrlResult',
    'GetHostingNameServerResult',
    'GetHostingOptionResult',
    'GetHostingRecordResult',
    'GetOfferOfferResult',
    'GetOfferOfferOptionResult',
    'GetOfferProductResult',
]

@pulumi.output_type
class HostingCpanelUrl(dict):
    def __init__(__self__, *,
                 dashboard: Optional[_builtins.str] = None,
                 webmail: Optional[_builtins.str] = None):
        """
        :param _builtins.str dashboard: The URL of the Dashboard.
        :param _builtins.str webmail: The URL of the Webmail interface.
        """
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if webmail is not None:
            pulumi.set(__self__, "webmail", webmail)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> Optional[_builtins.str]:
        """
        The URL of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter
    def webmail(self) -> Optional[_builtins.str]:
        """
        The URL of the Webmail interface.
        """
        return pulumi.get(self, "webmail")


@pulumi.output_type
class HostingNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDefault":
            suggest = "is_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 is_default: Optional[_builtins.bool] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: Hostname of the server
        :param _builtins.bool is_default: Whether or not the webhosting is the default one
        :param _builtins.str status: The hosting status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the server
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Whether or not the webhosting is the default one
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class HostingOption(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The option ID.
        :param _builtins.str name: The option name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The option ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The option name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class HostingRecord(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None,
                 ttl: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The option name.
        :param _builtins.int priority: Priority of DNS records associated with the webhosting.
        :param _builtins.str status: The hosting status.
        :param _builtins.int ttl: Time to live in seconds of the record
        :param _builtins.str type: Type of the DNS record
        :param _builtins.str value: Value of the DNS record
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        Time to live in seconds of the record
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the DNS record
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Value of the DNS record
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetHostingCpanelUrlResult(dict):
    def __init__(__self__, *,
                 dashboard: _builtins.str,
                 webmail: _builtins.str):
        """
        :param _builtins.str dashboard: URL to connect to dashboard interface
        :param _builtins.str webmail: URL to connect to Webmail interface
        """
        pulumi.set(__self__, "dashboard", dashboard)
        pulumi.set(__self__, "webmail", webmail)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> _builtins.str:
        """
        URL to connect to dashboard interface
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter
    def webmail(self) -> _builtins.str:
        """
        URL to connect to Webmail interface
        """
        return pulumi.get(self, "webmail")


@pulumi.output_type
class GetHostingNameServerResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 is_default: _builtins.bool,
                 status: _builtins.str):
        """
        :param _builtins.str hostname: Hostname of the server
        :param _builtins.bool is_default: Whether or not the webhosting is the default one
        :param _builtins.str status: Status of the nameserver
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Hostname of the server
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether or not the webhosting is the default one
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the nameserver
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHostingOptionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: ID of the active option
        :param _builtins.str name: Name of the option
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the active option
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the option
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetHostingRecordResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 priority: _builtins.int,
                 status: _builtins.str,
                 ttl: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the DNS record
        :param _builtins.int priority: Priority of DNS records associated with the webhosting.
        :param _builtins.str status: Status of the hosting record
        :param _builtins.int ttl: Time to live in seconds of the record
        :param _builtins.str type: Type of the DNS record
        :param _builtins.str value: Value of the DNS record
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the DNS record
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the hosting record
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Time to live in seconds of the record
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the DNS record
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the DNS record
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOfferOfferResult(dict):
    def __init__(__self__, *,
                 available: _builtins.bool,
                 billing_operation_path: _builtins.str,
                 control_panel_name: _builtins.str,
                 end_of_life: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 options: Sequence['outputs.GetOfferOfferOptionResult'],
                 price: _builtins.str,
                 quota_warning: _builtins.str):
        """
        :param _builtins.bool available: Indicates if the offer is available.
        :param _builtins.str billing_operation_path: The billing operation identifier for the option.
        :param _builtins.str control_panel_name: The name of the control panel (e.g., Cpanel or Plesk).
        :param _builtins.bool end_of_life: Indicates if the offer is deprecated or no longer supported.
        :param _builtins.str id: The unique identifier of the option.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param Sequence['GetOfferOfferOptionArgs'] options: A list of available options for the offer:
        :param _builtins.str price: The offer price.
        :param _builtins.str quota_warning: Warning information regarding quota limitations for the option.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "billing_operation_path", billing_operation_path)
        pulumi.set(__self__, "control_panel_name", control_panel_name)
        pulumi.set(__self__, "end_of_life", end_of_life)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "quota_warning", quota_warning)

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Indicates if the offer is available.
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter(name="billingOperationPath")
    def billing_operation_path(self) -> _builtins.str:
        """
        The billing operation identifier for the option.
        """
        return pulumi.get(self, "billing_operation_path")

    @_builtins.property
    @pulumi.getter(name="controlPanelName")
    def control_panel_name(self) -> _builtins.str:
        """
        The name of the control panel (e.g., Cpanel or Plesk).
        """
        return pulumi.get(self, "control_panel_name")

    @_builtins.property
    @pulumi.getter(name="endOfLife")
    def end_of_life(self) -> _builtins.bool:
        """
        Indicates if the offer is deprecated or no longer supported.
        """
        return pulumi.get(self, "end_of_life")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetOfferOfferOptionResult']:
        """
        A list of available options for the offer:
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        """
        The offer price.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="quotaWarning")
    def quota_warning(self) -> _builtins.str:
        """
        Warning information regarding quota limitations for the option.
        """
        return pulumi.get(self, "quota_warning")


@pulumi.output_type
class GetOfferOfferOptionResult(dict):
    def __init__(__self__, *,
                 billing_operation_path: _builtins.str,
                 current_value: _builtins.int,
                 id: _builtins.str,
                 max_value: _builtins.int,
                 min_value: _builtins.int,
                 name: _builtins.str,
                 price: _builtins.str,
                 quota_warning: _builtins.str):
        """
        :param _builtins.str billing_operation_path: The billing operation identifier for the option.
        :param _builtins.int current_value: The current value set for the option.
        :param _builtins.str id: The unique identifier of the option.
        :param _builtins.int max_value: The maximum allowed value for the option.
        :param _builtins.int min_value: The minimum value for the option.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.str price: The offer price.
        :param _builtins.str quota_warning: Warning information regarding quota limitations for the option.
        """
        pulumi.set(__self__, "billing_operation_path", billing_operation_path)
        pulumi.set(__self__, "current_value", current_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "quota_warning", quota_warning)

    @_builtins.property
    @pulumi.getter(name="billingOperationPath")
    def billing_operation_path(self) -> _builtins.str:
        """
        The billing operation identifier for the option.
        """
        return pulumi.get(self, "billing_operation_path")

    @_builtins.property
    @pulumi.getter(name="currentValue")
    def current_value(self) -> _builtins.int:
        """
        The current value set for the option.
        """
        return pulumi.get(self, "current_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> _builtins.int:
        """
        The maximum allowed value for the option.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> _builtins.int:
        """
        The minimum value for the option.
        """
        return pulumi.get(self, "min_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        """
        The offer price.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="quotaWarning")
    def quota_warning(self) -> _builtins.str:
        """
        Warning information regarding quota limitations for the option.
        """
        return pulumi.get(self, "quota_warning")


@pulumi.output_type
class GetOfferProductResult(dict):
    def __init__(__self__, *,
                 databases_quota: _builtins.int,
                 email_accounts_quota: _builtins.int,
                 email_storage_quota: _builtins.int,
                 hosting_storage_quota: _builtins.int,
                 name: _builtins.str,
                 option: _builtins.bool,
                 ram: _builtins.int,
                 support_included: _builtins.bool,
                 v_cpu: _builtins.int):
        """
        :param _builtins.int databases_quota: The quota of databases.
        :param _builtins.int email_accounts_quota: The quota of email accounts.
        :param _builtins.int email_storage_quota: The quota of email storage.
        :param _builtins.int hosting_storage_quota: The quota of hosting storage.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.bool option: The product option.
        :param _builtins.int ram: The capacity of the memory in GB.
        :param _builtins.bool support_included: If support is included.
        :param _builtins.int v_cpu: The number of cores.
        """
        pulumi.set(__self__, "databases_quota", databases_quota)
        pulumi.set(__self__, "email_accounts_quota", email_accounts_quota)
        pulumi.set(__self__, "email_storage_quota", email_storage_quota)
        pulumi.set(__self__, "hosting_storage_quota", hosting_storage_quota)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "option", option)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "support_included", support_included)
        pulumi.set(__self__, "v_cpu", v_cpu)

    @_builtins.property
    @pulumi.getter(name="databasesQuota")
    def databases_quota(self) -> _builtins.int:
        """
        The quota of databases.
        """
        return pulumi.get(self, "databases_quota")

    @_builtins.property
    @pulumi.getter(name="emailAccountsQuota")
    def email_accounts_quota(self) -> _builtins.int:
        """
        The quota of email accounts.
        """
        return pulumi.get(self, "email_accounts_quota")

    @_builtins.property
    @pulumi.getter(name="emailStorageQuota")
    def email_storage_quota(self) -> _builtins.int:
        """
        The quota of email storage.
        """
        return pulumi.get(self, "email_storage_quota")

    @_builtins.property
    @pulumi.getter(name="hostingStorageQuota")
    def hosting_storage_quota(self) -> _builtins.int:
        """
        The quota of hosting storage.
        """
        return pulumi.get(self, "hosting_storage_quota")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.bool:
        """
        The product option.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The capacity of the memory in GB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter(name="supportIncluded")
    def support_included(self) -> _builtins.bool:
        """
        If support is included.
        """
        return pulumi.get(self, "support_included")

    @_builtins.property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> _builtins.int:
        """
        The number of cores.
        """
        return pulumi.get(self, "v_cpu")


