# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 application_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_membership: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_ids: The list of IDs of the applications attached to the group.
        :param pulumi.Input[_builtins.str] description: The description of the IAM group.
        :param pulumi.Input[_builtins.bool] external_membership: Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        :param pulumi.Input[_builtins.str] name: The name of the IAM group.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: The list of IDs of the users attached to the group.
        """
        if application_ids is not None:
            pulumi.set(__self__, "application_ids", application_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_membership is not None:
            pulumi.set(__self__, "external_membership", external_membership)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @_builtins.property
    @pulumi.getter(name="applicationIds")
    def application_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IDs of the applications attached to the group.
        """
        return pulumi.get(self, "application_ids")

    @application_ids.setter
    def application_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IAM group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalMembership")
    def external_membership(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        """
        return pulumi.get(self, "external_membership")

    @external_membership.setter
    def external_membership(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_membership", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IAM group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `organization_id`) The ID of the organization the group is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IDs of the users attached to the group.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 application_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_membership: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_ids: The list of IDs of the applications attached to the group.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the group
        :param pulumi.Input[_builtins.str] description: The description of the IAM group.
        :param pulumi.Input[_builtins.bool] external_membership: Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        :param pulumi.Input[_builtins.str] name: The name of the IAM group.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the group.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: The list of IDs of the users attached to the group.
        """
        if application_ids is not None:
            pulumi.set(__self__, "application_ids", application_ids)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_membership is not None:
            pulumi.set(__self__, "external_membership", external_membership)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @_builtins.property
    @pulumi.getter(name="applicationIds")
    def application_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IDs of the applications attached to the group.
        """
        return pulumi.get(self, "application_ids")

    @application_ids.setter
    def application_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_ids", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the group
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IAM group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalMembership")
    def external_membership(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        """
        return pulumi.get(self, "external_membership")

    @external_membership.setter
    def external_membership(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_membership", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IAM group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `organization_id`) The ID of the organization the group is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the group
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IDs of the users attached to the group.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.type_token("scaleway:iam/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_membership: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway IAM Groups.
        For more information refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#groups-f592eb).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        basic = scaleway.iam.Group("basic",
            name="iam_group_basic",
            description="basic description",
            application_ids=[],
            user_ids=[])
        ```

        ### With applications

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        app = scaleway.iam.Application("app")
        with_app = scaleway.iam.Group("with_app",
            name="iam_group_with_app",
            application_ids=[app.id],
            user_ids=[])
        ```

        ## Import

        IAM groups can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/group:Group basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_ids: The list of IDs of the applications attached to the group.
        :param pulumi.Input[_builtins.str] description: The description of the IAM group.
        :param pulumi.Input[_builtins.bool] external_membership: Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        :param pulumi.Input[_builtins.str] name: The name of the IAM group.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: The list of IDs of the users attached to the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway IAM Groups.
        For more information refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#groups-f592eb).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        basic = scaleway.iam.Group("basic",
            name="iam_group_basic",
            description="basic description",
            application_ids=[],
            user_ids=[])
        ```

        ### With applications

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        app = scaleway.iam.Application("app")
        with_app = scaleway.iam.Group("with_app",
            name="iam_group_with_app",
            application_ids=[app.id],
            user_ids=[])
        ```

        ## Import

        IAM groups can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/group:Group basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_membership: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["application_ids"] = application_ids
            __props__.__dict__["description"] = description
            __props__.__dict__["external_membership"] = external_membership
            __props__.__dict__["name"] = name
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_ids"] = user_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/iamGroup:IamGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Group, __self__).__init__(
            'scaleway:iam/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_membership: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_ids: The list of IDs of the applications attached to the group.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the group
        :param pulumi.Input[_builtins.str] description: The description of the IAM group.
        :param pulumi.Input[_builtins.bool] external_membership: Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        :param pulumi.Input[_builtins.str] name: The name of the IAM group.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the group.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: The list of IDs of the users attached to the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["application_ids"] = application_ids
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["external_membership"] = external_membership
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_ids"] = user_ids
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationIds")
    def application_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of IDs of the applications attached to the group.
        """
        return pulumi.get(self, "application_ids")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the group
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the IAM group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalMembership")
    def external_membership(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Manage membership externally. This make the resource ignore user_ids and application_ids. Should be used when using iam_group_membership
        """
        return pulumi.get(self, "external_membership")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IAM group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        `organization_id`) The ID of the organization the group is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the group
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of IDs of the users attached to the group.
        """
        return pulumi.get(self, "user_ids")

