# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IamUserArgs', 'IamUser']

@pulumi.input_type
class IamUserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 send_password_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 send_welcome_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IamUser resource.
        :param pulumi.Input[_builtins.str] email: The email of the IAM user. For Guest users, this argument is not editable.
        :param pulumi.Input[_builtins.str] username: The username of the IAM user.
        :param pulumi.Input[_builtins.str] first_name: The user's first name.
        :param pulumi.Input[_builtins.str] last_name: The user's last name.
        :param pulumi.Input[_builtins.str] locale: The user's locale (e.g., en_US).
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] password: The password for first access.
        :param pulumi.Input[_builtins.str] phone_number: The user's phone number.
        :param pulumi.Input[_builtins.bool] send_password_email: Whether or not to send an email containing the password for first access.
        :param pulumi.Input[_builtins.bool] send_welcome_email: Whether or not to send a welcome email that includes onboarding information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "username", username)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if send_password_email is not None:
            pulumi.set(__self__, "send_password_email", send_password_email)
        if send_welcome_email is not None:
            pulumi.set(__self__, "send_welcome_email", send_welcome_email)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email of the IAM user. For Guest users, this argument is not editable.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the IAM user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's locale (e.g., en_US).
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `organization_id`) The ID of the organization the user is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for first access.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's phone number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="sendPasswordEmail")
    def send_password_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to send an email containing the password for first access.
        """
        return pulumi.get(self, "send_password_email")

    @send_password_email.setter
    def send_password_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_password_email", value)

    @_builtins.property
    @pulumi.getter(name="sendWelcomeEmail")
    def send_welcome_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to send a welcome email that includes onboarding information.
        """
        return pulumi.get(self, "send_welcome_email")

    @send_welcome_email.setter
    def send_welcome_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_welcome_email", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the user.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IamUserState:
    def __init__(__self__, *,
                 account_root_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletable: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_login_at: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 mfa: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 send_password_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 send_welcome_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IamUser resources.
        :param pulumi.Input[_builtins.str] account_root_user_id: The ID of the account root user associated with the user.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the IAM user.
        :param pulumi.Input[_builtins.bool] deletable: Whether the IAM user is deletable.
        :param pulumi.Input[_builtins.str] email: The email of the IAM user. For Guest users, this argument is not editable.
        :param pulumi.Input[_builtins.str] first_name: The user's first name.
        :param pulumi.Input[_builtins.str] last_login_at: The date of the last login.
        :param pulumi.Input[_builtins.str] last_name: The user's last name.
        :param pulumi.Input[_builtins.str] locale: The user's locale (e.g., en_US).
        :param pulumi.Input[_builtins.bool] locked: Whether the user is locked.
        :param pulumi.Input[_builtins.bool] mfa: Whether the MFA is enabled.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] password: The password for first access.
        :param pulumi.Input[_builtins.str] phone_number: The user's phone number.
        :param pulumi.Input[_builtins.bool] send_password_email: Whether or not to send an email containing the password for first access.
        :param pulumi.Input[_builtins.bool] send_welcome_email: Whether or not to send a welcome email that includes onboarding information.
        :param pulumi.Input[_builtins.str] status: The status of user invitation. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the user.
        :param pulumi.Input[_builtins.str] type: The type of user. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the IAM user.
        :param pulumi.Input[_builtins.str] username: The username of the IAM user.
        """
        if account_root_user_id is not None:
            pulumi.set(__self__, "account_root_user_id", account_root_user_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletable is not None:
            pulumi.set(__self__, "deletable", deletable)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_login_at is not None:
            pulumi.set(__self__, "last_login_at", last_login_at)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if mfa is not None:
            pulumi.set(__self__, "mfa", mfa)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if send_password_email is not None:
            pulumi.set(__self__, "send_password_email", send_password_email)
        if send_welcome_email is not None:
            pulumi.set(__self__, "send_welcome_email", send_welcome_email)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="accountRootUserId")
    def account_root_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the account root user associated with the user.
        """
        return pulumi.get(self, "account_root_user_id")

    @account_root_user_id.setter
    def account_root_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_root_user_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the IAM user.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def deletable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IAM user is deletable.
        """
        return pulumi.get(self, "deletable")

    @deletable.setter
    def deletable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletable", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the IAM user. For Guest users, this argument is not editable.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="lastLoginAt")
    def last_login_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date of the last login.
        """
        return pulumi.get(self, "last_login_at")

    @last_login_at.setter
    def last_login_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_login_at", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's locale (e.g., en_US).
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def mfa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the MFA is enabled.
        """
        return pulumi.get(self, "mfa")

    @mfa.setter
    def mfa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mfa", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `organization_id`) The ID of the organization the user is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for first access.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's phone number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="sendPasswordEmail")
    def send_password_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to send an email containing the password for first access.
        """
        return pulumi.get(self, "send_password_email")

    @send_password_email.setter
    def send_password_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_password_email", value)

    @_builtins.property
    @pulumi.getter(name="sendWelcomeEmail")
    def send_welcome_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to send a welcome email that includes onboarding information.
        """
        return pulumi.get(self, "send_welcome_email")

    @send_welcome_email.setter
    def send_welcome_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_welcome_email", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of user invitation. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the user.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of user. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the IAM user.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the IAM user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


warnings.warn("""scaleway.index/iamuser.IamUser has been deprecated in favor of scaleway.iam/user.User""", DeprecationWarning)


@pulumi.type_token("scaleway:index/iamUser:IamUser")
class IamUser(pulumi.CustomResource):
    warnings.warn("""scaleway.index/iamuser.IamUser has been deprecated in favor of scaleway.iam/user.User""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 send_password_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 send_welcome_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway IAM [Users](https://www.scaleway.com/en/docs/iam/concepts/#member).
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/iam/#path-users-list-users-of-an-organization).

        ## Example Usage

        ### User

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        user = scaleway.iam.User("user",
            email="foo@test.com",
            tags=["test-tag"],
            username="foo",
            first_name="Foo",
            last_name="Bar")
        ```

        ### Multiple users

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        users = [
            {
                "email": "test@test.com",
                "username": "test",
            },
            {
                "email": "test2@test.com",
                "username": "test2",
            },
        ]
        users_user = []
        for range in [{"value": i} for i in range(0, len(users))]:
            users_user.append(scaleway.iam.User(f"users-{range['value']}",
                email=users[range["value"]]["email"],
                username=users[range["value"]]["username"]))
        ```

        ## Import

        IAM users can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/iamUser:IamUser basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the IAM user. For Guest users, this argument is not editable.
        :param pulumi.Input[_builtins.str] first_name: The user's first name.
        :param pulumi.Input[_builtins.str] last_name: The user's last name.
        :param pulumi.Input[_builtins.str] locale: The user's locale (e.g., en_US).
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] password: The password for first access.
        :param pulumi.Input[_builtins.str] phone_number: The user's phone number.
        :param pulumi.Input[_builtins.bool] send_password_email: Whether or not to send an email containing the password for first access.
        :param pulumi.Input[_builtins.bool] send_welcome_email: Whether or not to send a welcome email that includes onboarding information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the user.
        :param pulumi.Input[_builtins.str] username: The username of the IAM user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway IAM [Users](https://www.scaleway.com/en/docs/iam/concepts/#member).
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/iam/#path-users-list-users-of-an-organization).

        ## Example Usage

        ### User

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        user = scaleway.iam.User("user",
            email="foo@test.com",
            tags=["test-tag"],
            username="foo",
            first_name="Foo",
            last_name="Bar")
        ```

        ### Multiple users

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        users = [
            {
                "email": "test@test.com",
                "username": "test",
            },
            {
                "email": "test2@test.com",
                "username": "test2",
            },
        ]
        users_user = []
        for range in [{"value": i} for i in range(0, len(users))]:
            users_user.append(scaleway.iam.User(f"users-{range['value']}",
                email=users[range["value"]]["email"],
                username=users[range["value"]]["username"]))
        ```

        ## Import

        IAM users can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/iamUser:IamUser basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param IamUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 send_password_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 send_welcome_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""IamUser is deprecated: scaleway.index/iamuser.IamUser has been deprecated in favor of scaleway.iam/user.User""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamUserArgs.__new__(IamUserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["locale"] = locale
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["send_password_email"] = send_password_email
            __props__.__dict__["send_welcome_email"] = send_welcome_email
            __props__.__dict__["tags"] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["account_root_user_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deletable"] = None
            __props__.__dict__["last_login_at"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["mfa"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IamUser, __self__).__init__(
            'scaleway:index/iamUser:IamUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_root_user_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletable: Optional[pulumi.Input[_builtins.bool]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_login_at: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            mfa: Optional[pulumi.Input[_builtins.bool]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            send_password_email: Optional[pulumi.Input[_builtins.bool]] = None,
            send_welcome_email: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'IamUser':
        """
        Get an existing IamUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_root_user_id: The ID of the account root user associated with the user.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the IAM user.
        :param pulumi.Input[_builtins.bool] deletable: Whether the IAM user is deletable.
        :param pulumi.Input[_builtins.str] email: The email of the IAM user. For Guest users, this argument is not editable.
        :param pulumi.Input[_builtins.str] first_name: The user's first name.
        :param pulumi.Input[_builtins.str] last_login_at: The date of the last login.
        :param pulumi.Input[_builtins.str] last_name: The user's last name.
        :param pulumi.Input[_builtins.str] locale: The user's locale (e.g., en_US).
        :param pulumi.Input[_builtins.bool] locked: Whether the user is locked.
        :param pulumi.Input[_builtins.bool] mfa: Whether the MFA is enabled.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] password: The password for first access.
        :param pulumi.Input[_builtins.str] phone_number: The user's phone number.
        :param pulumi.Input[_builtins.bool] send_password_email: Whether or not to send an email containing the password for first access.
        :param pulumi.Input[_builtins.bool] send_welcome_email: Whether or not to send a welcome email that includes onboarding information.
        :param pulumi.Input[_builtins.str] status: The status of user invitation. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the user.
        :param pulumi.Input[_builtins.str] type: The type of user. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the IAM user.
        :param pulumi.Input[_builtins.str] username: The username of the IAM user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamUserState.__new__(_IamUserState)

        __props__.__dict__["account_root_user_id"] = account_root_user_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletable"] = deletable
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_login_at"] = last_login_at
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["locale"] = locale
        __props__.__dict__["locked"] = locked
        __props__.__dict__["mfa"] = mfa
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["password"] = password
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["send_password_email"] = send_password_email
        __props__.__dict__["send_welcome_email"] = send_welcome_email
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["username"] = username
        return IamUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountRootUserId")
    def account_root_user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the account root user associated with the user.
        """
        return pulumi.get(self, "account_root_user_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the IAM user.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def deletable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the IAM user is deletable.
        """
        return pulumi.get(self, "deletable")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the IAM user. For Guest users, this argument is not editable.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user's first name.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastLoginAt")
    def last_login_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date of the last login.
        """
        return pulumi.get(self, "last_login_at")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user's last name.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[_builtins.str]:
        """
        The user's locale (e.g., en_US).
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the user is locked.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def mfa(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the MFA is enabled.
        """
        return pulumi.get(self, "mfa")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        `organization_id`) The ID of the organization the user is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for first access.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user's phone number.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="sendPasswordEmail")
    def send_password_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to send an email containing the password for first access.
        """
        return pulumi.get(self, "send_password_email")

    @_builtins.property
    @pulumi.getter(name="sendWelcomeEmail")
    def send_welcome_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to send a welcome email that includes onboarding information.
        """
        return pulumi.get(self, "send_welcome_email")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of user invitation. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the user.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of user. Check the possible values in the [API doc](https://www.scaleway.com/en/developers/api/iam/#path-users-get-a-given-user).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the IAM user.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the IAM user.
        """
        return pulumi.get(self, "username")

