# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetModelResult',
    'AwaitableGetModelResult',
    'get_model',
    'get_model_output',
]

@pulumi.output_type
class GetModelResult:
    """
    A collection of values returned by getModel.
    """
    def __init__(__self__, created_at=None, description=None, has_eula=None, id=None, model_id=None, name=None, nodes_supports=None, parameter_size_bits=None, project_id=None, region=None, secret=None, size_bytes=None, status=None, tags=None, updated_at=None, url=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if has_eula and not isinstance(has_eula, bool):
            raise TypeError("Expected argument 'has_eula' to be a bool")
        pulumi.set(__self__, "has_eula", has_eula)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nodes_supports and not isinstance(nodes_supports, list):
            raise TypeError("Expected argument 'nodes_supports' to be a list")
        pulumi.set(__self__, "nodes_supports", nodes_supports)
        if parameter_size_bits and not isinstance(parameter_size_bits, int):
            raise TypeError("Expected argument 'parameter_size_bits' to be a int")
        pulumi.set(__self__, "parameter_size_bits", parameter_size_bits)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if size_bytes and not isinstance(size_bytes, int):
            raise TypeError("Expected argument 'size_bytes' to be a int")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A textual description of the model (if available).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hasEula")
    def has_eula(self) -> _builtins.bool:
        """
        Whether the model requires end-user license agreement acceptance before use.
        """
        return pulumi.get(self, "has_eula")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodesSupports")
    def nodes_supports(self) -> Sequence['outputs.GetModelNodesSupportResult']:
        """
        List of supported node types and their quantization options. Each entry contains:
        """
        return pulumi.get(self, "nodes_supports")

    @_builtins.property
    @pulumi.getter(name="parameterSizeBits")
    def parameter_size_bits(self) -> _builtins.int:
        """
        Size, in bits, of the model parameters.
        """
        return pulumi.get(self, "parameter_size_bits")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> _builtins.int:
        """
        Total size, in bytes, of the model archive.
        """
        return pulumi.get(self, "size_bytes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the model (e.g., ready, error, etc.).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags associated with the model.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "url")


class AwaitableGetModelResult(GetModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelResult(
            created_at=self.created_at,
            description=self.description,
            has_eula=self.has_eula,
            id=self.id,
            model_id=self.model_id,
            name=self.name,
            nodes_supports=self.nodes_supports,
            parameter_size_bits=self.parameter_size_bits,
            project_id=self.project_id,
            region=self.region,
            secret=self.secret,
            size_bytes=self.size_bytes,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at,
            url=self.url)


def get_model(model_id: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              url: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelResult:
    """
    The `inference.Model` data source allows you to retrieve information about an inference model available in the Scaleway Inference API, either by providing the model's `name` or its `model_id`.

    ## Example Usage

    ### Basic

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_model = scaleway.inference.get_model(name="meta/llama-3.1-8b-instruct:fp8")
    ```


    :param _builtins.str model_id: The ID of the model to retrieve. Must be a valid UUID with locality (i.e., Scaleway's zoned UUID format).
    :param _builtins.str name: The fully qualified name of the model to look up (e.g., "meta/llama-3.1-8b-instruct:fp8"). The provider will search for a model with an exact name match in the selected region and project.
    """
    __args__ = dict()
    __args__['modelId'] = model_id
    __args__['name'] = name
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:inference/getModel:getModel', __args__, opts=opts, typ=GetModelResult).value

    return AwaitableGetModelResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        has_eula=pulumi.get(__ret__, 'has_eula'),
        id=pulumi.get(__ret__, 'id'),
        model_id=pulumi.get(__ret__, 'model_id'),
        name=pulumi.get(__ret__, 'name'),
        nodes_supports=pulumi.get(__ret__, 'nodes_supports'),
        parameter_size_bits=pulumi.get(__ret__, 'parameter_size_bits'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        secret=pulumi.get(__ret__, 'secret'),
        size_bytes=pulumi.get(__ret__, 'size_bytes'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        url=pulumi.get(__ret__, 'url'))
def get_model_output(model_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     url: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelResult]:
    """
    The `inference.Model` data source allows you to retrieve information about an inference model available in the Scaleway Inference API, either by providing the model's `name` or its `model_id`.

    ## Example Usage

    ### Basic

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_model = scaleway.inference.get_model(name="meta/llama-3.1-8b-instruct:fp8")
    ```


    :param _builtins.str model_id: The ID of the model to retrieve. Must be a valid UUID with locality (i.e., Scaleway's zoned UUID format).
    :param _builtins.str name: The fully qualified name of the model to look up (e.g., "meta/llama-3.1-8b-instruct:fp8"). The provider will search for a model with an exact name match in the selected region and project.
    """
    __args__ = dict()
    __args__['modelId'] = model_id
    __args__['name'] = name
    __args__['url'] = url
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:inference/getModel:getModel', __args__, opts=opts, typ=GetModelResult)
    return __ret__.apply(lambda __response__: GetModelResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        has_eula=pulumi.get(__response__, 'has_eula'),
        id=pulumi.get(__response__, 'id'),
        model_id=pulumi.get(__response__, 'model_id'),
        name=pulumi.get(__response__, 'name'),
        nodes_supports=pulumi.get(__response__, 'nodes_supports'),
        parameter_size_bits=pulumi.get(__response__, 'parameter_size_bits'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        secret=pulumi.get(__response__, 'secret'),
        size_bytes=pulumi.get(__response__, 'size_bytes'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        url=pulumi.get(__response__, 'url')))
