# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DeploymentPrivateEndpoint',
    'DeploymentPrivateIp',
    'DeploymentPublicEndpoint',
    'ModelNodesSupport',
    'ModelNodesSupportQuantization',
    'GetModelNodesSupportResult',
    'GetModelNodesSupportQuantizationResult',
]

@pulumi.output_type
class DeploymentPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAuth":
            suggest = "disable_auth"
        elif key == "privateNetworkId":
            suggest = "private_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auth: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 private_network_id: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable_auth: Disable the authentication on the endpoint.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        :param _builtins.str private_network_id: The ID of the private network to use.
        :param _builtins.str url: (Optional) The URL of the endpoint.
        """
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[_builtins.bool]:
        """
        Disable the authentication on the endpoint.
        """
        return pulumi.get(self, "disable_auth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[_builtins.str]:
        """
        The ID of the private network to use.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Optional) The URL of the endpoint.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DeploymentPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DeploymentPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAuth":
            suggest = "disable_auth"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auth: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable_auth: Disable the authentication on the endpoint.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        :param _builtins.bool is_enabled: Enable or disable public endpoint.
        :param _builtins.str url: (Optional) The URL of the endpoint.
        """
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[_builtins.bool]:
        """
        Disable the authentication on the endpoint.
        """
        return pulumi.get(self, "disable_auth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable public endpoint.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Optional) The URL of the endpoint.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ModelNodesSupport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeTypeName":
            suggest = "node_type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelNodesSupport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelNodesSupport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelNodesSupport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_type_name: Optional[_builtins.str] = None,
                 quantizations: Optional[Sequence['outputs.ModelNodesSupportQuantization']] = None):
        """
        :param _builtins.str node_type_name: The type of node supported.
        :param Sequence['ModelNodesSupportQuantizationArgs'] quantizations: A list of supported quantization options, including:
        """
        if node_type_name is not None:
            pulumi.set(__self__, "node_type_name", node_type_name)
        if quantizations is not None:
            pulumi.set(__self__, "quantizations", quantizations)

    @_builtins.property
    @pulumi.getter(name="nodeTypeName")
    def node_type_name(self) -> Optional[_builtins.str]:
        """
        The type of node supported.
        """
        return pulumi.get(self, "node_type_name")

    @_builtins.property
    @pulumi.getter
    def quantizations(self) -> Optional[Sequence['outputs.ModelNodesSupportQuantization']]:
        """
        A list of supported quantization options, including:
        """
        return pulumi.get(self, "quantizations")


@pulumi.output_type
class ModelNodesSupportQuantization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxContextSize":
            suggest = "max_context_size"
        elif key == "quantizationBits":
            suggest = "quantization_bits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelNodesSupportQuantization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelNodesSupportQuantization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelNodesSupportQuantization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed: Optional[_builtins.bool] = None,
                 max_context_size: Optional[_builtins.int] = None,
                 quantization_bits: Optional[_builtins.int] = None):
        """
        :param _builtins.bool allowed: Whether this quantization is allowed.
        :param _builtins.int max_context_size: Maximum context length supported by this quantization.
        :param _builtins.int quantization_bits: Number of bits used for quantization (e.g., 8, 16).
        """
        if allowed is not None:
            pulumi.set(__self__, "allowed", allowed)
        if max_context_size is not None:
            pulumi.set(__self__, "max_context_size", max_context_size)
        if quantization_bits is not None:
            pulumi.set(__self__, "quantization_bits", quantization_bits)

    @_builtins.property
    @pulumi.getter
    def allowed(self) -> Optional[_builtins.bool]:
        """
        Whether this quantization is allowed.
        """
        return pulumi.get(self, "allowed")

    @_builtins.property
    @pulumi.getter(name="maxContextSize")
    def max_context_size(self) -> Optional[_builtins.int]:
        """
        Maximum context length supported by this quantization.
        """
        return pulumi.get(self, "max_context_size")

    @_builtins.property
    @pulumi.getter(name="quantizationBits")
    def quantization_bits(self) -> Optional[_builtins.int]:
        """
        Number of bits used for quantization (e.g., 8, 16).
        """
        return pulumi.get(self, "quantization_bits")


@pulumi.output_type
class GetModelNodesSupportResult(dict):
    def __init__(__self__, *,
                 node_type_name: _builtins.str,
                 quantizations: Sequence['outputs.GetModelNodesSupportQuantizationResult']):
        """
        :param _builtins.str node_type_name: The type of node supported.
        :param Sequence['GetModelNodesSupportQuantizationArgs'] quantizations: A list of supported quantization options, including:
        """
        pulumi.set(__self__, "node_type_name", node_type_name)
        pulumi.set(__self__, "quantizations", quantizations)

    @_builtins.property
    @pulumi.getter(name="nodeTypeName")
    def node_type_name(self) -> _builtins.str:
        """
        The type of node supported.
        """
        return pulumi.get(self, "node_type_name")

    @_builtins.property
    @pulumi.getter
    def quantizations(self) -> Sequence['outputs.GetModelNodesSupportQuantizationResult']:
        """
        A list of supported quantization options, including:
        """
        return pulumi.get(self, "quantizations")


@pulumi.output_type
class GetModelNodesSupportQuantizationResult(dict):
    def __init__(__self__, *,
                 allowed: _builtins.bool,
                 max_context_size: _builtins.int,
                 quantization_bits: _builtins.int):
        """
        :param _builtins.bool allowed: Whether this quantization is allowed.
        :param _builtins.int max_context_size: Maximum context length supported by this quantization.
        :param _builtins.int quantization_bits: Number of bits used for quantization (e.g., 8, 16).
        """
        pulumi.set(__self__, "allowed", allowed)
        pulumi.set(__self__, "max_context_size", max_context_size)
        pulumi.set(__self__, "quantization_bits", quantization_bits)

    @_builtins.property
    @pulumi.getter
    def allowed(self) -> _builtins.bool:
        """
        Whether this quantization is allowed.
        """
        return pulumi.get(self, "allowed")

    @_builtins.property
    @pulumi.getter(name="maxContextSize")
    def max_context_size(self) -> _builtins.int:
        """
        Maximum context length supported by this quantization.
        """
        return pulumi.get(self, "max_context_size")

    @_builtins.property
    @pulumi.getter(name="quantizationBits")
    def quantization_bits(self) -> _builtins.int:
        """
        Number of bits used for quantization (e.g., 8, 16).
        """
        return pulumi.get(self, "quantization_bits")


