# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPlacementGroupResult',
    'AwaitableGetPlacementGroupResult',
    'get_placement_group',
    'get_placement_group_output',
]

@pulumi.output_type
class GetPlacementGroupResult:
    """
    A collection of values returned by getPlacementGroup.
    """
    def __init__(__self__, id=None, name=None, organization_id=None, placement_group_id=None, policy_mode=None, policy_respected=None, policy_type=None, project_id=None, tags=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if placement_group_id and not isinstance(placement_group_id, str):
            raise TypeError("Expected argument 'placement_group_id' to be a str")
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        if policy_mode and not isinstance(policy_mode, str):
            raise TypeError("Expected argument 'policy_mode' to be a str")
        pulumi.set(__self__, "policy_mode", policy_mode)
        if policy_respected and not isinstance(policy_respected, bool):
            raise TypeError("Expected argument 'policy_respected' to be a bool")
        pulumi.set(__self__, "policy_respected", policy_respected)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The organization ID the placement group is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "placement_group_id")

    @_builtins.property
    @pulumi.getter(name="policyMode")
    def policy_mode(self) -> _builtins.str:
        """
        The [policy mode](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) of the placement group.
        """
        return pulumi.get(self, "policy_mode")

    @_builtins.property
    @pulumi.getter(name="policyRespected")
    def policy_respected(self) -> _builtins.bool:
        """
        Is true when the policy is respected.
        """
        return pulumi.get(self, "policy_respected")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The [policy type](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) of the placement group.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of tags to apply to the placement group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetPlacementGroupResult(GetPlacementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlacementGroupResult(
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            placement_group_id=self.placement_group_id,
            policy_mode=self.policy_mode,
            policy_respected=self.policy_respected,
            policy_type=self.policy_type,
            project_id=self.project_id,
            tags=self.tags,
            zone=self.zone)


def get_placement_group(name: Optional[_builtins.str] = None,
                        placement_group_id: Optional[_builtins.str] = None,
                        project_id: Optional[_builtins.str] = None,
                        zone: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlacementGroupResult:
    """
    Gets information about a Security Group.


    :param _builtins.str name: The placement group name. Only one of `name` and `placement_group_id` should be specified.
    :param _builtins.str placement_group_id: The placement group id. Only one of `name` and `placement_group_id` should be specified.
    :param _builtins.str project_id: `project_id`) The ID of the project the placement group is associated with.
    :param _builtins.str zone: `zone`) The zone in which the placement group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['placementGroupId'] = placement_group_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getPlacementGroup:getPlacementGroup', __args__, opts=opts, typ=GetPlacementGroupResult).value

    return AwaitableGetPlacementGroupResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        placement_group_id=pulumi.get(__ret__, 'placement_group_id'),
        policy_mode=pulumi.get(__ret__, 'policy_mode'),
        policy_respected=pulumi.get(__ret__, 'policy_respected'),
        policy_type=pulumi.get(__ret__, 'policy_type'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        zone=pulumi.get(__ret__, 'zone'))
def get_placement_group_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               placement_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlacementGroupResult]:
    """
    Gets information about a Security Group.


    :param _builtins.str name: The placement group name. Only one of `name` and `placement_group_id` should be specified.
    :param _builtins.str placement_group_id: The placement group id. Only one of `name` and `placement_group_id` should be specified.
    :param _builtins.str project_id: `project_id`) The ID of the project the placement group is associated with.
    :param _builtins.str zone: `zone`) The zone in which the placement group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['placementGroupId'] = placement_group_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getPlacementGroup:getPlacementGroup', __args__, opts=opts, typ=GetPlacementGroupResult)
    return __ret__.apply(lambda __response__: GetPlacementGroupResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        placement_group_id=pulumi.get(__response__, 'placement_group_id'),
        policy_mode=pulumi.get(__response__, 'policy_mode'),
        policy_respected=pulumi.get(__response__, 'policy_respected'),
        policy_type=pulumi.get(__response__, 'policy_type'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        zone=pulumi.get(__response__, 'zone')))
