# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPrivateNicResult',
    'AwaitableGetPrivateNicResult',
    'get_private_nic',
    'get_private_nic_output',
]

@pulumi.output_type
class GetPrivateNicResult:
    """
    A collection of values returned by getPrivateNic.
    """
    def __init__(__self__, id=None, ip_ids=None, ipam_ip_ids=None, mac_address=None, private_ips=None, private_network_id=None, private_nic_id=None, server_id=None, tags=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_ids and not isinstance(ip_ids, list):
            raise TypeError("Expected argument 'ip_ids' to be a list")
        pulumi.set(__self__, "ip_ids", ip_ids)
        if ipam_ip_ids and not isinstance(ipam_ip_ids, list):
            raise TypeError("Expected argument 'ipam_ip_ids' to be a list")
        pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if private_nic_id and not isinstance(private_nic_id, str):
            raise TypeError("Expected argument 'private_nic_id' to be a str")
        pulumi.set(__self__, "private_nic_id", private_nic_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ip_ids")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetPrivateNicPrivateIpResult']:
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="privateNicId")
    def private_nic_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_nic_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetPrivateNicResult(GetPrivateNicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateNicResult(
            id=self.id,
            ip_ids=self.ip_ids,
            ipam_ip_ids=self.ipam_ip_ids,
            mac_address=self.mac_address,
            private_ips=self.private_ips,
            private_network_id=self.private_network_id,
            private_nic_id=self.private_nic_id,
            server_id=self.server_id,
            tags=self.tags,
            zone=self.zone)


def get_private_nic(private_network_id: Optional[_builtins.str] = None,
                    private_nic_id: Optional[_builtins.str] = None,
                    server_id: Optional[_builtins.str] = None,
                    tags: Optional[Sequence[_builtins.str]] = None,
                    zone: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateNicResult:
    """
    Gets information about an instance private NIC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_nic_id = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        private_nic_id="11111111-1111-1111-1111-111111111111")
    by_pn_id = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        private_network_id="11111111-1111-1111-1111-111111111111")
    by_tags = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        tags=["mytag"])
    ```


    :param _builtins.str private_network_id: The ID of the private network
           Only one of `private_nic_id` and `private_network_id` should be specified.
    :param _builtins.str private_nic_id: The ID of the instance server private nic
           Only one of `private_nic_id` and `private_network_id` should be specified.
    :param _builtins.str server_id: The server's id
    :param Sequence[_builtins.str] tags: The tags associated with the private NIC.
           As datasource only returns one private NIC, the search with given tags must return only one result
    :param _builtins.str zone: `zone`) The zone in which the private nic exists.
    """
    __args__ = dict()
    __args__['privateNetworkId'] = private_network_id
    __args__['privateNicId'] = private_nic_id
    __args__['serverId'] = server_id
    __args__['tags'] = tags
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getPrivateNic:getPrivateNic', __args__, opts=opts, typ=GetPrivateNicResult).value

    return AwaitableGetPrivateNicResult(
        id=pulumi.get(__ret__, 'id'),
        ip_ids=pulumi.get(__ret__, 'ip_ids'),
        ipam_ip_ids=pulumi.get(__ret__, 'ipam_ip_ids'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        private_nic_id=pulumi.get(__ret__, 'private_nic_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        tags=pulumi.get(__ret__, 'tags'),
        zone=pulumi.get(__ret__, 'zone'))
def get_private_nic_output(private_network_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           private_nic_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           server_id: Optional[pulumi.Input[_builtins.str]] = None,
                           tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateNicResult]:
    """
    Gets information about an instance private NIC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_nic_id = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        private_nic_id="11111111-1111-1111-1111-111111111111")
    by_pn_id = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        private_network_id="11111111-1111-1111-1111-111111111111")
    by_tags = scaleway.instance.get_private_nic(server_id="11111111-1111-1111-1111-111111111111",
        tags=["mytag"])
    ```


    :param _builtins.str private_network_id: The ID of the private network
           Only one of `private_nic_id` and `private_network_id` should be specified.
    :param _builtins.str private_nic_id: The ID of the instance server private nic
           Only one of `private_nic_id` and `private_network_id` should be specified.
    :param _builtins.str server_id: The server's id
    :param Sequence[_builtins.str] tags: The tags associated with the private NIC.
           As datasource only returns one private NIC, the search with given tags must return only one result
    :param _builtins.str zone: `zone`) The zone in which the private nic exists.
    """
    __args__ = dict()
    __args__['privateNetworkId'] = private_network_id
    __args__['privateNicId'] = private_nic_id
    __args__['serverId'] = server_id
    __args__['tags'] = tags
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getPrivateNic:getPrivateNic', __args__, opts=opts, typ=GetPrivateNicResult)
    return __ret__.apply(lambda __response__: GetPrivateNicResult(
        id=pulumi.get(__response__, 'id'),
        ip_ids=pulumi.get(__response__, 'ip_ids'),
        ipam_ip_ids=pulumi.get(__response__, 'ipam_ip_ids'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        private_network_id=pulumi.get(__response__, 'private_network_id'),
        private_nic_id=pulumi.get(__response__, 'private_nic_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        tags=pulumi.get(__response__, 'tags'),
        zone=pulumi.get(__response__, 'zone')))
