# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServersResult',
    'AwaitableGetServersResult',
    'get_servers',
    'get_servers_output',
]

@pulumi.output_type
class GetServersResult:
    """
    A collection of values returned by getServers.
    """
    def __init__(__self__, id=None, name=None, organization_id=None, project_id=None, servers=None, tags=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetServersServerResult']:
        """
        List of found servers
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone in which the server is.
        """
        return pulumi.get(self, "zone")


class AwaitableGetServersResult(GetServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServersResult(
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            servers=self.servers,
            tags=self.tags,
            zone=self.zone)


def get_servers(name: Optional[_builtins.str] = None,
                project_id: Optional[_builtins.str] = None,
                tags: Optional[Sequence[_builtins.str]] = None,
                zone: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServersResult:
    """
    Gets information about multiple instance servers.

    ## Examples


    :param _builtins.str name: The server name used as filter. Servers with a name like it are listed.
    :param _builtins.str project_id: The ID of the project the server is associated with.
    :param Sequence[_builtins.str] tags: List of tags used as filter. Servers with these exact tags are listed.
    :param _builtins.str zone: `zone`) The zone in which servers exist.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['tags'] = tags
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getServers:getServers', __args__, opts=opts, typ=GetServersResult).value

    return AwaitableGetServersResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        servers=pulumi.get(__ret__, 'servers'),
        tags=pulumi.get(__ret__, 'tags'),
        zone=pulumi.get(__ret__, 'zone'))
def get_servers_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServersResult]:
    """
    Gets information about multiple instance servers.

    ## Examples


    :param _builtins.str name: The server name used as filter. Servers with a name like it are listed.
    :param _builtins.str project_id: The ID of the project the server is associated with.
    :param Sequence[_builtins.str] tags: List of tags used as filter. Servers with these exact tags are listed.
    :param _builtins.str zone: `zone`) The zone in which servers exist.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['tags'] = tags
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getServers:getServers', __args__, opts=opts, typ=GetServersResult)
    return __ret__.apply(lambda __response__: GetServersResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        servers=pulumi.get(__response__, 'servers'),
        tags=pulumi.get(__response__, 'tags'),
        zone=pulumi.get(__response__, 'zone')))
