# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 root_volume_id: pulumi.Input[_builtins.str],
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] root_volume_id: The ID of the snapshot of the volume to be used as root in the image.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_volume_ids: List of IDs of the snapshots of the additional volumes to be attached to the image.
        :param pulumi.Input[_builtins.str] architecture: The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project the image is associated with.
        :param pulumi.Input[_builtins.bool] public: Set to `true` if the image is public.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[_builtins.str] zone: The zone in which the image should be created.
        """
        pulumi.set(__self__, "root_volume_id", root_volume_id)
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="rootVolumeId")
    def root_volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the snapshot of the volume to be used as root in the image.
        """
        return pulumi.get(self, "root_volume_id")

    @root_volume_id.setter
    def root_volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_volume_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IDs of the snapshots of the additional volumes to be attached to the image.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project the image is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` if the image is public.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAdditionalVolumeArgs']]]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 from_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 root_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRootVolumeArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_volume_ids: List of IDs of the snapshots of the additional volumes to be attached to the image.
        :param pulumi.Input[Sequence[pulumi.Input['ImageAdditionalVolumeArgs']]] additional_volumes: The description of the extra volumes attached to the image.
        :param pulumi.Input[_builtins.str] architecture: The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        :param pulumi.Input[_builtins.str] creation_date: Date of the image creation.
        :param pulumi.Input[_builtins.str] from_server_id: ID of the server the image is based on (in case it is a backup).
        :param pulumi.Input[_builtins.str] modification_date: Date of image latest update.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The organization ID the image is associated with.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project the image is associated with.
        :param pulumi.Input[_builtins.bool] public: Set to `true` if the image is public.
        :param pulumi.Input[_builtins.str] root_volume_id: The ID of the snapshot of the volume to be used as root in the image.
        :param pulumi.Input[Sequence[pulumi.Input['ImageRootVolumeArgs']]] root_volumes: The description of the root volume attached to the image.
        :param pulumi.Input[_builtins.str] state: State of the image. Possible values are: `available`, `creating` or `error`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[_builtins.str] zone: The zone in which the image should be created.
        """
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if additional_volumes is not None:
            pulumi.set(__self__, "additional_volumes", additional_volumes)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if from_server_id is not None:
            pulumi.set(__self__, "from_server_id", from_server_id)
        if modification_date is not None:
            pulumi.set(__self__, "modification_date", modification_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if root_volume_id is not None:
            pulumi.set(__self__, "root_volume_id", root_volume_id)
        if root_volumes is not None:
            pulumi.set(__self__, "root_volumes", root_volumes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IDs of the snapshots of the additional volumes to be attached to the image.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @_builtins.property
    @pulumi.getter(name="additionalVolumes")
    def additional_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageAdditionalVolumeArgs']]]]:
        """
        The description of the extra volumes attached to the image.
        """
        return pulumi.get(self, "additional_volumes")

    @additional_volumes.setter
    def additional_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAdditionalVolumeArgs']]]]):
        pulumi.set(self, "additional_volumes", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of the image creation.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter(name="fromServerId")
    def from_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the server the image is based on (in case it is a backup).
        """
        return pulumi.get(self, "from_server_id")

    @from_server_id.setter
    def from_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "from_server_id", value)

    @_builtins.property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date of image latest update.
        """
        return pulumi.get(self, "modification_date")

    @modification_date.setter
    def modification_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_date", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization ID the image is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project the image is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` if the image is public.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeId")
    def root_volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot of the volume to be used as root in the image.
        """
        return pulumi.get(self, "root_volume_id")

    @root_volume_id.setter
    def root_volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_volume_id", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRootVolumeArgs']]]]:
        """
        The description of the root volume attached to the image.
        """
        return pulumi.get(self, "root_volumes")

    @root_volumes.setter
    def root_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRootVolumeArgs']]]]):
        pulumi.set(self, "root_volumes", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the image. Possible values are: `available`, `creating` or `error`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:instance/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Compute Images.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-images-list-instance-images).

        ## Example Usage

        ### From a volume

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        volume = scaleway.instance.Volume("volume",
            type="b_ssd",
            size_in_gb=20)
        volume_snapshot = scaleway.instance.Snapshot("volume_snapshot", volume_id=volume.id)
        volume_image = scaleway.instance.Image("volume_image",
            name="image_from_volume",
            root_volume_id=volume_snapshot.id)
        ```

        ### From a server

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            image="ubuntu_jammy",
            type="DEV1-S")
        server_snapshot = scaleway.instance.Snapshot("server_snapshot", volume_id=main["rootVolume"][0]["volumeId"])
        server_image = scaleway.instance.Image("server_image",
            name="image_from_server",
            root_volume_id=server_snapshot.id)
        ```

        ### With additional volumes

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            image="ubuntu_jammy",
            type="DEV1-S")
        volume = scaleway.instance.Volume("volume",
            type="b_ssd",
            size_in_gb=20)
        volume_snapshot = scaleway.instance.Snapshot("volume_snapshot", volume_id=volume.id)
        server_snapshot = scaleway.instance.Snapshot("server_snapshot", volume_id=main["rootVolume"][0]["volumeId"])
        image = scaleway.instance.Image("image",
            name="image_with_extra_volumes",
            root_volume_id=server_snapshot.id,
            additional_volume_ids=[volume_snapshot.id])
        ```

        ## Import

        Images can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:instance/image:Image main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_volume_ids: List of IDs of the snapshots of the additional volumes to be attached to the image.
        :param pulumi.Input[_builtins.str] architecture: The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project the image is associated with.
        :param pulumi.Input[_builtins.bool] public: Set to `true` if the image is public.
        :param pulumi.Input[_builtins.str] root_volume_id: The ID of the snapshot of the volume to be used as root in the image.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[_builtins.str] zone: The zone in which the image should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Compute Images.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-images-list-instance-images).

        ## Example Usage

        ### From a volume

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        volume = scaleway.instance.Volume("volume",
            type="b_ssd",
            size_in_gb=20)
        volume_snapshot = scaleway.instance.Snapshot("volume_snapshot", volume_id=volume.id)
        volume_image = scaleway.instance.Image("volume_image",
            name="image_from_volume",
            root_volume_id=volume_snapshot.id)
        ```

        ### From a server

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            image="ubuntu_jammy",
            type="DEV1-S")
        server_snapshot = scaleway.instance.Snapshot("server_snapshot", volume_id=main["rootVolume"][0]["volumeId"])
        server_image = scaleway.instance.Image("server_image",
            name="image_from_server",
            root_volume_id=server_snapshot.id)
        ```

        ### With additional volumes

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            image="ubuntu_jammy",
            type="DEV1-S")
        volume = scaleway.instance.Volume("volume",
            type="b_ssd",
            size_in_gb=20)
        volume_snapshot = scaleway.instance.Snapshot("volume_snapshot", volume_id=volume.id)
        server_snapshot = scaleway.instance.Snapshot("server_snapshot", volume_id=main["rootVolume"][0]["volumeId"])
        image = scaleway.instance.Image("image",
            name="image_with_extra_volumes",
            root_volume_id=server_snapshot.id,
            additional_volume_ids=[volume_snapshot.id])
        ```

        ## Import

        Images can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:instance/image:Image main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["additional_volume_ids"] = additional_volume_ids
            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public"] = public
            if root_volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'root_volume_id'")
            __props__.__dict__["root_volume_id"] = root_volume_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["additional_volumes"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["from_server_id"] = None
            __props__.__dict__["modification_date"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["root_volumes"] = None
            __props__.__dict__["state"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/instanceImage:InstanceImage")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Image, __self__).__init__(
            'scaleway:instance/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            additional_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageAdditionalVolumeArgs', 'ImageAdditionalVolumeArgsDict']]]]] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            from_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            modification_date: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public: Optional[pulumi.Input[_builtins.bool]] = None,
            root_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
            root_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageRootVolumeArgs', 'ImageRootVolumeArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_volume_ids: List of IDs of the snapshots of the additional volumes to be attached to the image.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageAdditionalVolumeArgs', 'ImageAdditionalVolumeArgsDict']]]] additional_volumes: The description of the extra volumes attached to the image.
        :param pulumi.Input[_builtins.str] architecture: The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        :param pulumi.Input[_builtins.str] creation_date: Date of the image creation.
        :param pulumi.Input[_builtins.str] from_server_id: ID of the server the image is based on (in case it is a backup).
        :param pulumi.Input[_builtins.str] modification_date: Date of image latest update.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The organization ID the image is associated with.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project the image is associated with.
        :param pulumi.Input[_builtins.bool] public: Set to `true` if the image is public.
        :param pulumi.Input[_builtins.str] root_volume_id: The ID of the snapshot of the volume to be used as root in the image.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageRootVolumeArgs', 'ImageRootVolumeArgsDict']]]] root_volumes: The description of the root volume attached to the image.
        :param pulumi.Input[_builtins.str] state: State of the image. Possible values are: `available`, `creating` or `error`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[_builtins.str] zone: The zone in which the image should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["additional_volume_ids"] = additional_volume_ids
        __props__.__dict__["additional_volumes"] = additional_volumes
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["from_server_id"] = from_server_id
        __props__.__dict__["modification_date"] = modification_date
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public"] = public
        __props__.__dict__["root_volume_id"] = root_volume_id
        __props__.__dict__["root_volumes"] = root_volumes
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of IDs of the snapshots of the additional volumes to be attached to the image.
        """
        return pulumi.get(self, "additional_volume_ids")

    @_builtins.property
    @pulumi.getter(name="additionalVolumes")
    def additional_volumes(self) -> pulumi.Output[Sequence['outputs.ImageAdditionalVolume']]:
        """
        The description of the extra volumes attached to the image.
        """
        return pulumi.get(self, "additional_volumes")

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The architecture the image is compatible with. Possible values are: `x86_64` or `arm`.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        Date of the image creation.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="fromServerId")
    def from_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the server the image is based on (in case it is a backup).
        """
        return pulumi.get(self, "from_server_id")

    @_builtins.property
    @pulumi.getter(name="modificationDate")
    def modification_date(self) -> pulumi.Output[_builtins.str]:
        """
        Date of image latest update.
        """
        return pulumi.get(self, "modification_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The organization ID the image is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project the image is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `true` if the image is public.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter(name="rootVolumeId")
    def root_volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the snapshot of the volume to be used as root in the image.
        """
        return pulumi.get(self, "root_volume_id")

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> pulumi.Output[Sequence['outputs.ImageRootVolume']]:
        """
        The description of the root volume attached to the image.
        """
        return pulumi.get(self, "root_volumes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the image. Possible values are: `available`, `creating` or `error`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone in which the image should be created.
        """
        return pulumi.get(self, "zone")

