# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IotRouteArgs', 'IotRoute']

@pulumi.input_type
class IotRouteArgs:
    def __init__(__self__, *,
                 hub_id: pulumi.Input[_builtins.str],
                 topic: pulumi.Input[_builtins.str],
                 database: Optional[pulumi.Input['IotRouteDatabaseArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest: Optional[pulumi.Input['IotRouteRestArgs']] = None,
                 s3: Optional[pulumi.Input['IotRouteS3Args']] = None):
        """
        The set of arguments for constructing a IotRoute resource.
        :param pulumi.Input[_builtins.str] hub_id: The hub ID to which the Route will be attached to.
        :param pulumi.Input[_builtins.str] topic: The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        :param pulumi.Input['IotRouteDatabaseArgs'] database: Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] name: The name of the IoT Route you want to create (e.g. `my-route`).
        :param pulumi.Input[_builtins.str] region: (Defaults to provider `region`) The region in which the Route is attached to.
        :param pulumi.Input['IotRouteRestArgs'] rest: Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input['IotRouteS3Args'] s3: Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        pulumi.set(__self__, "hub_id", hub_id)
        pulumi.set(__self__, "topic", topic)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest is not None:
            pulumi.set(__self__, "rest", rest)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The hub ID to which the Route will be attached to.
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['IotRouteDatabaseArgs']]:
        """
        Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['IotRouteDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IoT Route you want to create (e.g. `my-route`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Defaults to provider `region`) The region in which the Route is attached to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rest(self) -> Optional[pulumi.Input['IotRouteRestArgs']]:
        """
        Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "rest")

    @rest.setter
    def rest(self, value: Optional[pulumi.Input['IotRouteRestArgs']]):
        pulumi.set(self, "rest", value)

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['IotRouteS3Args']]:
        """
        Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['IotRouteS3Args']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class _IotRouteState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input['IotRouteDatabaseArgs']] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest: Optional[pulumi.Input['IotRouteRestArgs']] = None,
                 s3: Optional[pulumi.Input['IotRouteS3Args']] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IotRoute resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time the Route was created.
        :param pulumi.Input['IotRouteDatabaseArgs'] database: Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] hub_id: The hub ID to which the Route will be attached to.
        :param pulumi.Input[_builtins.str] name: The name of the IoT Route you want to create (e.g. `my-route`).
        :param pulumi.Input[_builtins.str] region: (Defaults to provider `region`) The region in which the Route is attached to.
        :param pulumi.Input['IotRouteRestArgs'] rest: Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input['IotRouteS3Args'] s3: Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] topic: The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest is not None:
            pulumi.set(__self__, "rest", rest)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Route was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['IotRouteDatabaseArgs']]:
        """
        Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['IotRouteDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hub ID to which the Route will be attached to.
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IoT Route you want to create (e.g. `my-route`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Defaults to provider `region`) The region in which the Route is attached to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rest(self) -> Optional[pulumi.Input['IotRouteRestArgs']]:
        """
        Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "rest")

    @rest.setter
    def rest(self, value: Optional[pulumi.Input['IotRouteRestArgs']]):
        pulumi.set(self, "rest", value)

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['IotRouteS3Args']]:
        """
        Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['IotRouteS3Args']]):
        pulumi.set(self, "s3", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


warnings.warn("""scaleway.index/iotroute.IotRoute has been deprecated in favor of scaleway.iot/route.Route""", DeprecationWarning)


@pulumi.type_token("scaleway:index/iotRoute:IotRoute")
class IotRoute(pulumi.CustomResource):
    warnings.warn("""scaleway.index/iotroute.IotRoute has been deprecated in favor of scaleway.iot/route.Route""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[Union['IotRouteDatabaseArgs', 'IotRouteDatabaseArgsDict']]] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest: Optional[pulumi.Input[Union['IotRouteRestArgs', 'IotRouteRestArgsDict']]] = None,
                 s3: Optional[pulumi.Input[Union['IotRouteS3Args', 'IotRouteS3ArgsDict']]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Database Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        iot = scaleway.databases.Instance("iot",
            name="iot",
            node_type="db-dev-s",
            engine="PostgreSQL-12",
            user_name="root",
            password="T3stP4ssw0rdD0N0tUs3!")
        main = scaleway.iot.Route("main",
            name="default",
            hub_id=main_hub.id,
            topic="#",
            database={
                "query": \"\"\"INSERT INTO measurements(
        \\tpush_time,
        \\treport_time,
        \\tstation_id,
        \\ttemperature,
        \\thumidity
        ) VALUES (
        \\tNOW(),
        \\tTIMESTAMP 'epoch' + (($PAYLOAD::jsonb->'last_reported')::integer * INTERVAL '1 second'),
        \\t($PAYLOAD::jsonb->'station_id')::uuid,
        \\t($PAYLOAD::jsonb->'temperature')::decimal,
        \\t($PAYLOAD::jsonb->'humidity'):decimal:
        );
        \"\"\",
                "host": iot.endpoint_ip,
                "port": iot.endpoint_port,
                "dbname": "rdb",
                "username": iot.user_name,
                "password": iot.password,
            })
        ```

        ### S3 Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        main_bucket = scaleway.object.Bucket("main",
            region="fr-par",
            name="my_awesome-bucket")
        main = scaleway.iot.Route("main",
            name="main",
            hub_id=main_hub.id,
            topic="#",
            s3={
                "bucket_region": main_bucket.region,
                "bucket_name": main_bucket.name,
                "object_prefix": "foo",
                "strategy": "per_topic",
            })
        ```

        ### Rest Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        main = scaleway.iot.Route("main",
            name="main",
            hub_id=main_hub.id,
            topic="#",
            rest={
                "verb": "get",
                "uri": "http://scaleway.com",
                "headers": {
                    "X-awesome-header": "my-awesome-value",
                },
            })
        ```

        ## Import

        IoT Routes can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/iotRoute:IotRoute route01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IotRouteDatabaseArgs', 'IotRouteDatabaseArgsDict']] database: Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] hub_id: The hub ID to which the Route will be attached to.
        :param pulumi.Input[_builtins.str] name: The name of the IoT Route you want to create (e.g. `my-route`).
        :param pulumi.Input[_builtins.str] region: (Defaults to provider `region`) The region in which the Route is attached to.
        :param pulumi.Input[Union['IotRouteRestArgs', 'IotRouteRestArgsDict']] rest: Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[Union['IotRouteS3Args', 'IotRouteS3ArgsDict']] s3: Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] topic: The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Database Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        iot = scaleway.databases.Instance("iot",
            name="iot",
            node_type="db-dev-s",
            engine="PostgreSQL-12",
            user_name="root",
            password="T3stP4ssw0rdD0N0tUs3!")
        main = scaleway.iot.Route("main",
            name="default",
            hub_id=main_hub.id,
            topic="#",
            database={
                "query": \"\"\"INSERT INTO measurements(
        \\tpush_time,
        \\treport_time,
        \\tstation_id,
        \\ttemperature,
        \\thumidity
        ) VALUES (
        \\tNOW(),
        \\tTIMESTAMP 'epoch' + (($PAYLOAD::jsonb->'last_reported')::integer * INTERVAL '1 second'),
        \\t($PAYLOAD::jsonb->'station_id')::uuid,
        \\t($PAYLOAD::jsonb->'temperature')::decimal,
        \\t($PAYLOAD::jsonb->'humidity'):decimal:
        );
        \"\"\",
                "host": iot.endpoint_ip,
                "port": iot.endpoint_port,
                "dbname": "rdb",
                "username": iot.user_name,
                "password": iot.password,
            })
        ```

        ### S3 Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        main_bucket = scaleway.object.Bucket("main",
            region="fr-par",
            name="my_awesome-bucket")
        main = scaleway.iot.Route("main",
            name="main",
            hub_id=main_hub.id,
            topic="#",
            s3={
                "bucket_region": main_bucket.region,
                "bucket_name": main_bucket.name,
                "object_prefix": "foo",
                "strategy": "per_topic",
            })
        ```

        ### Rest Route

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main_hub = scaleway.iot.Hub("main",
            name="main",
            product_plan="plan_shared")
        main = scaleway.iot.Route("main",
            name="main",
            hub_id=main_hub.id,
            topic="#",
            rest={
                "verb": "get",
                "uri": "http://scaleway.com",
                "headers": {
                    "X-awesome-header": "my-awesome-value",
                },
            })
        ```

        ## Import

        IoT Routes can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/iotRoute:IotRoute route01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param IotRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[Union['IotRouteDatabaseArgs', 'IotRouteDatabaseArgsDict']]] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rest: Optional[pulumi.Input[Union['IotRouteRestArgs', 'IotRouteRestArgsDict']]] = None,
                 s3: Optional[pulumi.Input[Union['IotRouteS3Args', 'IotRouteS3ArgsDict']]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""IotRoute is deprecated: scaleway.index/iotroute.IotRoute has been deprecated in favor of scaleway.iot/route.Route""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotRouteArgs.__new__(IotRouteArgs)

            __props__.__dict__["database"] = database
            if hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'hub_id'")
            __props__.__dict__["hub_id"] = hub_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["rest"] = rest
            __props__.__dict__["s3"] = s3
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["created_at"] = None
        super(IotRoute, __self__).__init__(
            'scaleway:index/iotRoute:IotRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[Union['IotRouteDatabaseArgs', 'IotRouteDatabaseArgsDict']]] = None,
            hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rest: Optional[pulumi.Input[Union['IotRouteRestArgs', 'IotRouteRestArgsDict']]] = None,
            s3: Optional[pulumi.Input[Union['IotRouteS3Args', 'IotRouteS3ArgsDict']]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None) -> 'IotRoute':
        """
        Get an existing IotRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time the Route was created.
        :param pulumi.Input[Union['IotRouteDatabaseArgs', 'IotRouteDatabaseArgsDict']] database: Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] hub_id: The hub ID to which the Route will be attached to.
        :param pulumi.Input[_builtins.str] name: The name of the IoT Route you want to create (e.g. `my-route`).
        :param pulumi.Input[_builtins.str] region: (Defaults to provider `region`) The region in which the Route is attached to.
        :param pulumi.Input[Union['IotRouteRestArgs', 'IotRouteRestArgsDict']] rest: Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[Union['IotRouteS3Args', 'IotRouteS3ArgsDict']] s3: Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        :param pulumi.Input[_builtins.str] topic: The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotRouteState.__new__(_IotRouteState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database"] = database
        __props__.__dict__["hub_id"] = hub_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["rest"] = rest
        __props__.__dict__["s3"] = s3
        __props__.__dict__["topic"] = topic
        return IotRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Route was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional['outputs.IotRouteDatabase']]:
        """
        Configuration block for the database routes. See  [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The hub ID to which the Route will be attached to.
        """
        return pulumi.get(self, "hub_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IoT Route you want to create (e.g. `my-route`).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Defaults to provider `region`) The region in which the Route is attached to.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rest(self) -> pulumi.Output[Optional['outputs.IotRouteRest']]:
        """
        Configuration block for the rest routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "rest")

    @_builtins.property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.IotRouteS3']]:
        """
        Configuration block for the S3 routes. See [product documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for a better understanding of the parameters.
        """
        return pulumi.get(self, "s3")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        The topic the Route subscribes to, wildcards allowed (e.g. `thelab/+/temperature/#`).
        """
        return pulumi.get(self, "topic")

