# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpsResult',
    'AwaitableGetIpsResult',
    'get_ips',
    'get_ips_output',
]

@pulumi.output_type
class GetIpsResult:
    """
    A collection of values returned by getIps.
    """
    def __init__(__self__, attached=None, id=None, ips=None, mac_address=None, organization_id=None, private_network_id=None, project_id=None, region=None, resource=None, tags=None, type=None, zonal=None):
        if attached and not isinstance(attached, bool):
            raise TypeError("Expected argument 'attached' to be a bool")
        pulumi.set(__self__, "attached", attached)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource and not isinstance(resource, dict):
            raise TypeError("Expected argument 'resource' to be a dict")
        pulumi.set(__self__, "resource", resource)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zonal and not isinstance(zonal, str):
            raise TypeError("Expected argument 'zonal' to be a str")
        pulumi.set(__self__, "zonal", zonal)

    @_builtins.property
    @pulumi.getter
    def attached(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "attached")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetIpsIpResult']:
        """
        List of found IPs.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        The associated MAC address.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the resource is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the IP.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.GetIpsResourceResult']:
        """
        The list of public IPs attached to the resource.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The tags associated with the IP.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zonal(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zonal")


class AwaitableGetIpsResult(GetIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsResult(
            attached=self.attached,
            id=self.id,
            ips=self.ips,
            mac_address=self.mac_address,
            organization_id=self.organization_id,
            private_network_id=self.private_network_id,
            project_id=self.project_id,
            region=self.region,
            resource=self.resource,
            tags=self.tags,
            type=self.type,
            zonal=self.zonal)


def get_ips(attached: Optional[_builtins.bool] = None,
            mac_address: Optional[_builtins.str] = None,
            private_network_id: Optional[_builtins.str] = None,
            project_id: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            resource: Optional[Union['GetIpsResourceArgs', 'GetIpsResourceArgsDict']] = None,
            tags: Optional[Sequence[_builtins.str]] = None,
            type: Optional[_builtins.str] = None,
            zonal: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsResult:
    """
    Gets information about multiple IP addresses managed by Scaleway's IP Address Management (IPAM) service.

    For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

    ## Examples

    ### By tag

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_tag = scaleway.ipam.get_ips(tags=["tag"])
    ```

    ### By type and resource

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
    pn01 = scaleway.network.PrivateNetwork("pn01",
        vpc_id=vpc01.id,
        ipv4_subnet={
            "subnet": "172.16.32.0/22",
        })
    redis01 = scaleway.redis.Cluster("redis01",
        name="my_redis_cluster",
        version="7.0.5",
        node_type="RED1-XS",
        user_name="my_initial_user",
        password="thiZ_is_v&ry_s3cret",
        cluster_size=3,
        private_networks=[{
            "id": pn01.id,
        }])
    by_type_and_resource = scaleway.ipam.get_ips_output(type="ipv4",
        resource={
            "id": redis01.id,
            "type": "redis_cluster",
        })
    ```


    :param _builtins.bool attached: Defines whether to filter only for IPs which are attached to a resource.
    :param _builtins.str mac_address: The linked MAC address to filter for.
    :param _builtins.str private_network_id: The ID of the Private Network to filter for.
    :param _builtins.str project_id: The ID of the Project to filter for.
    :param _builtins.str region: The region to filter for.
    :param Union['GetIpsResourceArgs', 'GetIpsResourceArgsDict'] resource: Filter for a resource attached to the IP, using resource ID, type or name.
    :param Sequence[_builtins.str] tags: The IP tags to filter for.
    :param _builtins.str type: The type of IP to filter for (`ipv4` or `ipv6`).
    :param _builtins.str zonal: Only IPs that are zonal, and in this zone, will be returned.
    """
    __args__ = dict()
    __args__['attached'] = attached
    __args__['macAddress'] = mac_address
    __args__['privateNetworkId'] = private_network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['resource'] = resource
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['zonal'] = zonal
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:ipam/getIps:getIps', __args__, opts=opts, typ=GetIpsResult).value

    return AwaitableGetIpsResult(
        attached=pulumi.get(__ret__, 'attached'),
        id=pulumi.get(__ret__, 'id'),
        ips=pulumi.get(__ret__, 'ips'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        resource=pulumi.get(__ret__, 'resource'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        zonal=pulumi.get(__ret__, 'zonal'))
def get_ips_output(attached: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                   mac_address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   private_network_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   resource: Optional[pulumi.Input[Optional[Union['GetIpsResourceArgs', 'GetIpsResourceArgsDict']]]] = None,
                   tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                   type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   zonal: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsResult]:
    """
    Gets information about multiple IP addresses managed by Scaleway's IP Address Management (IPAM) service.

    For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

    ## Examples

    ### By tag

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_tag = scaleway.ipam.get_ips(tags=["tag"])
    ```

    ### By type and resource

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
    pn01 = scaleway.network.PrivateNetwork("pn01",
        vpc_id=vpc01.id,
        ipv4_subnet={
            "subnet": "172.16.32.0/22",
        })
    redis01 = scaleway.redis.Cluster("redis01",
        name="my_redis_cluster",
        version="7.0.5",
        node_type="RED1-XS",
        user_name="my_initial_user",
        password="thiZ_is_v&ry_s3cret",
        cluster_size=3,
        private_networks=[{
            "id": pn01.id,
        }])
    by_type_and_resource = scaleway.ipam.get_ips_output(type="ipv4",
        resource={
            "id": redis01.id,
            "type": "redis_cluster",
        })
    ```


    :param _builtins.bool attached: Defines whether to filter only for IPs which are attached to a resource.
    :param _builtins.str mac_address: The linked MAC address to filter for.
    :param _builtins.str private_network_id: The ID of the Private Network to filter for.
    :param _builtins.str project_id: The ID of the Project to filter for.
    :param _builtins.str region: The region to filter for.
    :param Union['GetIpsResourceArgs', 'GetIpsResourceArgsDict'] resource: Filter for a resource attached to the IP, using resource ID, type or name.
    :param Sequence[_builtins.str] tags: The IP tags to filter for.
    :param _builtins.str type: The type of IP to filter for (`ipv4` or `ipv6`).
    :param _builtins.str zonal: Only IPs that are zonal, and in this zone, will be returned.
    """
    __args__ = dict()
    __args__['attached'] = attached
    __args__['macAddress'] = mac_address
    __args__['privateNetworkId'] = private_network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['resource'] = resource
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['zonal'] = zonal
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:ipam/getIps:getIps', __args__, opts=opts, typ=GetIpsResult)
    return __ret__.apply(lambda __response__: GetIpsResult(
        attached=pulumi.get(__response__, 'attached'),
        id=pulumi.get(__response__, 'id'),
        ips=pulumi.get(__response__, 'ips'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        private_network_id=pulumi.get(__response__, 'private_network_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        resource=pulumi.get(__response__, 'resource'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        zonal=pulumi.get(__response__, 'zonal')))
