# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IpamIpReverseDnsArgs', 'IpamIpReverseDns']

@pulumi.input_type
class IpamIpReverseDnsArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 hostname: pulumi.Input[_builtins.str],
                 ipam_ip_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpamIpReverseDns resource.
        :param pulumi.Input[_builtins.str] address: The IP corresponding to the hostname.
        :param pulumi.Input[_builtins.str] hostname: The reverse domain name.
        :param pulumi.Input[_builtins.str] ipam_ip_id: The IPAM IP ID.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the IP reverse DNS.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        The IP corresponding to the hostname.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> pulumi.Input[_builtins.str]:
        """
        The IPAM IP ID.
        """
        return pulumi.get(self, "ipam_ip_id")

    @ipam_ip_id.setter
    def ipam_ip_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipam_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the IP reverse DNS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IpamIpReverseDnsState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpamIpReverseDns resources.
        :param pulumi.Input[_builtins.str] address: The IP corresponding to the hostname.
        :param pulumi.Input[_builtins.str] hostname: The reverse domain name.
        :param pulumi.Input[_builtins.str] ipam_ip_id: The IPAM IP ID.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the IP reverse DNS.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ipam_ip_id is not None:
            pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP corresponding to the hostname.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPAM IP ID.
        """
        return pulumi.get(self, "ipam_ip_id")

    @ipam_ip_id.setter
    def ipam_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the IP reverse DNS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


warnings.warn("""scaleway.index/ipamipreversedns.IpamIpReverseDns has been deprecated in favor of scaleway.ipam/ipreversedns.IpReverseDns""", DeprecationWarning)


@pulumi.type_token("scaleway:index/ipamIpReverseDns:IpamIpReverseDns")
class IpamIpReverseDns(pulumi.CustomResource):
    warnings.warn("""scaleway.index/ipamipreversedns.IpamIpReverseDns has been deprecated in favor of scaleway.ipam/ipreversedns.IpReverseDns""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage the reverse DNS of IP addresses managed by Scaleway's IP Address Management (IPAM) service.

        For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

        ## Import

        IPAM IP reverse DNS can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/ipamIpReverseDns:IpamIpReverseDns main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP corresponding to the hostname.
        :param pulumi.Input[_builtins.str] hostname: The reverse domain name.
        :param pulumi.Input[_builtins.str] ipam_ip_id: The IPAM IP ID.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the IP reverse DNS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamIpReverseDnsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage the reverse DNS of IP addresses managed by Scaleway's IP Address Management (IPAM) service.

        For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

        ## Import

        IPAM IP reverse DNS can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/ipamIpReverseDns:IpamIpReverseDns main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param IpamIpReverseDnsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamIpReverseDnsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""IpamIpReverseDns is deprecated: scaleway.index/ipamipreversedns.IpamIpReverseDns has been deprecated in favor of scaleway.ipam/ipreversedns.IpReverseDns""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamIpReverseDnsArgs.__new__(IpamIpReverseDnsArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if ipam_ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_ip_id'")
            __props__.__dict__["ipam_ip_id"] = ipam_ip_id
            __props__.__dict__["region"] = region
        super(IpamIpReverseDns, __self__).__init__(
            'scaleway:index/ipamIpReverseDns:IpamIpReverseDns',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpamIpReverseDns':
        """
        Get an existing IpamIpReverseDns resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP corresponding to the hostname.
        :param pulumi.Input[_builtins.str] hostname: The reverse domain name.
        :param pulumi.Input[_builtins.str] ipam_ip_id: The IPAM IP ID.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the IP reverse DNS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpamIpReverseDnsState.__new__(_IpamIpReverseDnsState)

        __props__.__dict__["address"] = address
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ipam_ip_id"] = ipam_ip_id
        __props__.__dict__["region"] = region
        return IpamIpReverseDns(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP corresponding to the hostname.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The IPAM IP ID.
        """
        return pulumi.get(self, "ipam_ip_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the IP reverse DNS.
        """
        return pulumi.get(self, "region")

