# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAclsResult',
    'AwaitableGetAclsResult',
    'get_acls',
    'get_acls_output',
]

@pulumi.output_type
class GetAclsResult:
    """
    A collection of values returned by getAcls.
    """
    def __init__(__self__, acls=None, frontend_id=None, id=None, name=None, organization_id=None, project_id=None, zone=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if frontend_id and not isinstance(frontend_id, str):
            raise TypeError("Expected argument 'frontend_id' to be a str")
        pulumi.set(__self__, "frontend_id", frontend_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetAclsAclResult']:
        """
        List of retrieved ACLs
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> _builtins.str:
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetAclsResult(GetAclsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclsResult(
            acls=self.acls,
            frontend_id=self.frontend_id,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            zone=self.zone)


def get_acls(frontend_id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             project_id: Optional[_builtins.str] = None,
             zone: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclsResult:
    """
    Gets information about multiple Load Balancer ACLs.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/acls/) or [API reference](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-acls-get-an-acl).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Find acls that share the same frontend ID
    by_front_id = scaleway.loadbalancers.get_acls(frontend_id=frt01["id"])
    # Find acls by frontend ID and name
    by_front_id_and_name = scaleway.loadbalancers.get_acls(frontend_id=frt01["id"],
        name="tf-acls-datasource")
    ```


    :param _builtins.str frontend_id: The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
           > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
    :param _builtins.str name: The ACL name to filter for. ACLs with a matching name are listed.
    :param _builtins.str zone: `zone`) The zone in which the ACLs exist.
    """
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:loadbalancers/getAcls:getAcls', __args__, opts=opts, typ=GetAclsResult).value

    return AwaitableGetAclsResult(
        acls=pulumi.get(__ret__, 'acls'),
        frontend_id=pulumi.get(__ret__, 'frontend_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        zone=pulumi.get(__ret__, 'zone'))
def get_acls_output(frontend_id: Optional[pulumi.Input[_builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclsResult]:
    """
    Gets information about multiple Load Balancer ACLs.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/acls/) or [API reference](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-acls-get-an-acl).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Find acls that share the same frontend ID
    by_front_id = scaleway.loadbalancers.get_acls(frontend_id=frt01["id"])
    # Find acls by frontend ID and name
    by_front_id_and_name = scaleway.loadbalancers.get_acls(frontend_id=frt01["id"],
        name="tf-acls-datasource")
    ```


    :param _builtins.str frontend_id: The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
           > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
    :param _builtins.str name: The ACL name to filter for. ACLs with a matching name are listed.
    :param _builtins.str zone: `zone`) The zone in which the ACLs exist.
    """
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:loadbalancers/getAcls:getAcls', __args__, opts=opts, typ=GetAclsResult)
    return __ret__.apply(lambda __response__: GetAclsResult(
        acls=pulumi.get(__response__, 'acls'),
        frontend_id=pulumi.get(__response__, 'frontend_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        zone=pulumi.get(__response__, 'zone')))
