# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 assign_flexible_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_private_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[_builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[_builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[_builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[_builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[_builtins.bool] external_private_networks: A boolean to specify whether to use lb_private_network.
               If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        :param pulumi.Input[_builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[_builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[_builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        pulumi.set(__self__, "type", type)
        if assign_flexible_ip is not None:
            pulumi.set(__self__, "assign_flexible_ip", assign_flexible_ip)
        if assign_flexible_ipv6 is not None:
            pulumi.set(__self__, "assign_flexible_ipv6", assign_flexible_ipv6)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_private_networks is not None:
            pulumi.set(__self__, "external_private_networks", external_private_networks)
        if ip_id is not None:
            warnings.warn("""Please use ip_ids""", DeprecationWarning)
            pulumi.log.warn("""ip_id is deprecated: Please use ip_ids""")
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @assign_flexible_ip.setter
    def assign_flexible_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_flexible_ip", value)

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @assign_flexible_ipv6.setter
    def assign_flexible_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_flexible_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalPrivateNetworks")
    def external_private_networks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean to specify whether to use lb_private_network.
        If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        """
        return pulumi.get(self, "external_private_networks")

    @external_private_networks.setter
    def external_private_networks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_private_networks", value)

    @_builtins.property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_ip", value)

    @_builtins.property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 assign_flexible_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_private_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[_builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[_builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[_builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[_builtins.bool] external_private_networks: A boolean to specify whether to use lb_private_network.
               If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        :param pulumi.Input[_builtins.str] ip_address: The Load Balancer public IPv4 address.
        :param pulumi.Input[_builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[_builtins.str] ipv6_address: The Load Balancer public IPv6 address.
        :param pulumi.Input[_builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the Organization ID the Load Balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[_builtins.str] region: The region of the resource
        :param pulumi.Input[_builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        if assign_flexible_ip is not None:
            pulumi.set(__self__, "assign_flexible_ip", assign_flexible_ip)
        if assign_flexible_ipv6 is not None:
            pulumi.set(__self__, "assign_flexible_ipv6", assign_flexible_ipv6)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_private_networks is not None:
            pulumi.set(__self__, "external_private_networks", external_private_networks)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_id is not None:
            warnings.warn("""Please use ip_ids""", DeprecationWarning)
            pulumi.log.warn("""ip_id is deprecated: Please use ip_ids""")
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @assign_flexible_ip.setter
    def assign_flexible_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_flexible_ip", value)

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @assign_flexible_ipv6.setter
    def assign_flexible_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_flexible_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalPrivateNetworks")
    def external_private_networks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean to specify whether to use lb_private_network.
        If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        """
        return pulumi.get(self, "external_private_networks")

    @external_private_networks.setter
    def external_private_networks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_private_networks", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Load Balancer public IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Load Balancer public IPv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Organization ID the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release_ip", value)

    @_builtins.property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:loadbalancers/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_flexible_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_private_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateNetworkArgs', 'LoadBalancerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load Balancers.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/concepts/#load-balancers) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-list-load-balancers).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.Ip("main", zone="fr-par-1")
        base = scaleway.loadbalancers.LoadBalancer("base",
            ip_ids=[main.id],
            zone=main.zone,
            type="LB-S")
        ```

        ### Private LB

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        base = scaleway.loadbalancers.LoadBalancer("base",
            name="private-lb",
            type="LB-S",
            assign_flexible_ip=False)
        ```

        ### With IPv6

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        v4 = scaleway.loadbalancers.Ip("v4")
        v6 = scaleway.loadbalancers.Ip("v6", is_ipv6=True)
        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[
                v4.id,
                v6.id,
            ],
            name="ipv6-lb",
            type="LB-S")
        ```

        ### With IPAM IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        v4 = scaleway.loadbalancers.Ip("v4")
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            ip_ids=[v4.id],
            name="my-lb",
            type="LB-S",
            private_networks=[{
                "private_network_id": pn01.id,
                "ipam_ids": ip01.id,
            }])
        ```

        ## Migration

        In order to migrate to other Load Balancer types, you can check upwards or downwards migration via our CLI `scw lb lb-types list`.
        This change will not recreate your Load Balancer.

        Please check our [documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-migrate-a-load-balancer) for further details.

        ## Import

        Load Balancers can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:loadbalancers/loadBalancer:LoadBalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[_builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[_builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[_builtins.bool] external_private_networks: A boolean to specify whether to use lb_private_network.
               If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        :param pulumi.Input[_builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[_builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateNetworkArgs', 'LoadBalancerPrivateNetworkArgsDict']]]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[_builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load Balancers.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/concepts/#load-balancers) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-list-load-balancers).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.Ip("main", zone="fr-par-1")
        base = scaleway.loadbalancers.LoadBalancer("base",
            ip_ids=[main.id],
            zone=main.zone,
            type="LB-S")
        ```

        ### Private LB

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        base = scaleway.loadbalancers.LoadBalancer("base",
            name="private-lb",
            type="LB-S",
            assign_flexible_ip=False)
        ```

        ### With IPv6

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        v4 = scaleway.loadbalancers.Ip("v4")
        v6 = scaleway.loadbalancers.Ip("v6", is_ipv6=True)
        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[
                v4.id,
                v6.id,
            ],
            name="ipv6-lb",
            type="LB-S")
        ```

        ### With IPAM IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        v4 = scaleway.loadbalancers.Ip("v4")
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            ip_ids=[v4.id],
            name="my-lb",
            type="LB-S",
            private_networks=[{
                "private_network_id": pn01.id,
                "ipam_ids": ip01.id,
            }])
        ```

        ## Migration

        In order to migrate to other Load Balancer types, you can check upwards or downwards migration via our CLI `scw lb lb-types list`.
        This change will not recreate your Load Balancer.

        Please check our [documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-migrate-a-load-balancer) for further details.

        ## Import

        Load Balancers can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:loadbalancers/loadBalancer:LoadBalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_flexible_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_private_networks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateNetworkArgs', 'LoadBalancerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["assign_flexible_ip"] = assign_flexible_ip
            __props__.__dict__["assign_flexible_ipv6"] = assign_flexible_ipv6
            __props__.__dict__["description"] = description
            __props__.__dict__["external_private_networks"] = external_private_networks
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["ip_ids"] = ip_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["release_ip"] = release_ip
            __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["region"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/loadbalancer:Loadbalancer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(LoadBalancer, __self__).__init__(
            'scaleway:loadbalancers/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_flexible_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            assign_flexible_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_private_networks: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateIpArgs', 'LoadBalancerPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateNetworkArgs', 'LoadBalancerPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            release_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            ssl_compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[_builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[_builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[_builtins.bool] external_private_networks: A boolean to specify whether to use lb_private_network.
               If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        :param pulumi.Input[_builtins.str] ip_address: The Load Balancer public IPv4 address.
        :param pulumi.Input[_builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[_builtins.str] ipv6_address: The Load Balancer public IPv6 address.
        :param pulumi.Input[_builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the Organization ID the Load Balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateIpArgs', 'LoadBalancerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPrivateNetworkArgs', 'LoadBalancerPrivateNetworkArgsDict']]]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[_builtins.str] region: The region of the resource
        :param pulumi.Input[_builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[_builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["assign_flexible_ip"] = assign_flexible_ip
        __props__.__dict__["assign_flexible_ipv6"] = assign_flexible_ipv6
        __props__.__dict__["description"] = description
        __props__.__dict__["external_private_networks"] = external_private_networks
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["ip_ids"] = ip_ids
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["release_ip"] = release_ip
        __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @_builtins.property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalPrivateNetworks")
    def external_private_networks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean to specify whether to use lb_private_network.
        If `external_private_networks` is set to `true`, `private_network` can not be set directly in the Load Balancer.
        """
        return pulumi.get(self, "external_private_networks")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Load Balancer public IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Load Balancer public IPv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Organization ID the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.LoadBalancerPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Sequence['outputs.LoadBalancerPrivateNetwork']]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @_builtins.property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

