# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateNetworkArgs', 'PrivateNetwork']

@pulumi.input_type
class PrivateNetworkArgs:
    def __init__(__self__, *,
                 lb_id: pulumi.Input[_builtins.str],
                 private_network_id: pulumi.Input[_builtins.str],
                 ipam_ip_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateNetwork resource.
        :param pulumi.Input[_builtins.str] lb_id: The load-balancer ID to attach the private network to.
        :param pulumi.Input[_builtins.str] private_network_id: The private network ID to attach.
        :param pulumi.Input[_builtins.str] ipam_ip_ids: The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Private Network attachment is associated with.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Private Network should be attached.
        """
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "private_network_id", private_network_id)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Input[_builtins.str]:
        """
        The load-balancer ID to attach the private network to.
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lb_id", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The private network ID to attach.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @ipam_ip_ids.setter
    def ipam_ip_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Private Network attachment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Private Network should be attached.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _PrivateNetworkState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateNetwork resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Private Network attachment (RFC 3339 format).
        :param pulumi.Input[_builtins.str] ipam_ip_ids: The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param pulumi.Input[_builtins.str] lb_id: The load-balancer ID to attach the private network to.
        :param pulumi.Input[_builtins.str] private_network_id: The private network ID to attach.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Private Network attachment is associated with.
        :param pulumi.Input[_builtins.str] status: The status of the Private Network attachment.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Private Network attachment (RFC 3339 format).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Private Network should be attached.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if lb_id is not None:
            pulumi.set(__self__, "lb_id", lb_id)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the Private Network attachment (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @ipam_ip_ids.setter
    def ipam_ip_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load-balancer ID to attach the private network to.
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lb_id", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private network ID to attach.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Private Network attachment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Private Network attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the Private Network attachment (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Private Network should be attached.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:loadbalancers/privateNetwork:PrivateNetwork")
class PrivateNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_ip_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load Balancer Private Network attachments.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/use-with-private-network/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            name="test-lb-private-network",
            type="LB-S")
        lbpn01 = scaleway.loadbalancers.PrivateNetwork("lbpn01",
            lb_id=lb01.id,
            private_network_id=pn01.id,
            ipam_ip_ids=ip01.id)
        ```

        ## Import

        Private Network attachments can be imported using `{zone}/{lb-id}/{private-network-id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:loadbalancers/privateNetwork:PrivateNetwork lbpn01 fr-par-1/11111111-1111-1111-1111-111111111111/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipam_ip_ids: The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param pulumi.Input[_builtins.str] lb_id: The load-balancer ID to attach the private network to.
        :param pulumi.Input[_builtins.str] private_network_id: The private network ID to attach.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Private Network attachment is associated with.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Private Network should be attached.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load Balancer Private Network attachments.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/use-with-private-network/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            name="test-lb-private-network",
            type="LB-S")
        lbpn01 = scaleway.loadbalancers.PrivateNetwork("lbpn01",
            lb_id=lb01.id,
            private_network_id=pn01.id,
            ipam_ip_ids=ip01.id)
        ```

        ## Import

        Private Network attachments can be imported using `{zone}/{lb-id}/{private-network-id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:loadbalancers/privateNetwork:PrivateNetwork lbpn01 fr-par-1/11111111-1111-1111-1111-111111111111/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param PrivateNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_ip_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateNetworkArgs.__new__(PrivateNetworkArgs)

            __props__.__dict__["ipam_ip_ids"] = ipam_ip_ids
            if lb_id is None and not opts.urn:
                raise TypeError("Missing required property 'lb_id'")
            __props__.__dict__["lb_id"] = lb_id
            if private_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_network_id'")
            __props__.__dict__["private_network_id"] = private_network_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(PrivateNetwork, __self__).__init__(
            'scaleway:loadbalancers/privateNetwork:PrivateNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_ip_ids: Optional[pulumi.Input[_builtins.str]] = None,
            lb_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateNetwork':
        """
        Get an existing PrivateNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Private Network attachment (RFC 3339 format).
        :param pulumi.Input[_builtins.str] ipam_ip_ids: The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param pulumi.Input[_builtins.str] lb_id: The load-balancer ID to attach the private network to.
        :param pulumi.Input[_builtins.str] private_network_id: The private network ID to attach.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Private Network attachment is associated with.
        :param pulumi.Input[_builtins.str] status: The status of the Private Network attachment.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Private Network attachment (RFC 3339 format).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Private Network should be attached.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateNetworkState.__new__(_PrivateNetworkState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["ipam_ip_ids"] = ipam_ip_ids
        __props__.__dict__["lb_id"] = lb_id
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return PrivateNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the Private Network attachment (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> pulumi.Output[_builtins.str]:
        """
        The IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Output[_builtins.str]:
        """
        The load-balancer ID to attach the private network to.
        """
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The private network ID to attach.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project the Private Network attachment is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Private Network attachment.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the Private Network attachment (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the Private Network should be attached.
        """
        return pulumi.get(self, "zone")

