# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqsCredentialsArgs', 'SqsCredentials']

@pulumi.input_type
class SqsCredentialsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input['SqsCredentialsPermissionsArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqsCredentials resource.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS credentials.
        :param pulumi.Input['SqsCredentialsPermissionsArgs'] permissions: . List of permissions associated with these credentials.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the SQS credentials.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input['SqsCredentialsPermissionsArgs']]:
        """
        . List of permissions associated with these credentials.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input['SqsCredentialsPermissionsArgs']]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SqsCredentialsState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input['SqsCredentialsPermissionsArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqsCredentials resources.
        :param pulumi.Input[_builtins.str] access_key: The ID of the key.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS credentials.
        :param pulumi.Input['SqsCredentialsPermissionsArgs'] permissions: . List of permissions associated with these credentials.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret value of the key.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the SQS credentials.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input['SqsCredentialsPermissionsArgs']]:
        """
        . List of permissions associated with these credentials.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input['SqsCredentialsPermissionsArgs']]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret value of the key.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)


@pulumi.type_token("scaleway:mnq/sqsCredentials:SqsCredentials")
class SqsCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Union['SqsCredentialsPermissionsArgs', 'SqsCredentialsPermissionsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Messaging and Queuing SQS credentials.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sqs-overview/)

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": False,
                "can_receive": True,
                "can_publish": False,
            })
        ```

        ## Import

        SQS credentials can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/sqsCredentials:SqsCredentials main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS credentials.
        :param pulumi.Input[Union['SqsCredentialsPermissionsArgs', 'SqsCredentialsPermissionsArgsDict']] permissions: . List of permissions associated with these credentials.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SqsCredentialsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Messaging and Queuing SQS credentials.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sqs-overview/)

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": False,
                "can_receive": True,
                "can_publish": False,
            })
        ```

        ## Import

        SQS credentials can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/sqsCredentials:SqsCredentials main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param SqsCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqsCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Union['SqsCredentialsPermissionsArgs', 'SqsCredentialsPermissionsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqsCredentialsArgs.__new__(SqsCredentialsArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["access_key"] = None
            __props__.__dict__["secret_key"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/mnqSqsCredentials:MnqSqsCredentials")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SqsCredentials, __self__).__init__(
            'scaleway:mnq/sqsCredentials:SqsCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Union['SqsCredentialsPermissionsArgs', 'SqsCredentialsPermissionsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqsCredentials':
        """
        Get an existing SqsCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The ID of the key.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS credentials.
        :param pulumi.Input[Union['SqsCredentialsPermissionsArgs', 'SqsCredentialsPermissionsArgsDict']] permissions: . List of permissions associated with these credentials.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret value of the key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqsCredentialsState.__new__(_SqsCredentialsState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        return SqsCredentials(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the key.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the SQS credentials.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output['outputs.SqsCredentialsPermissions']:
        """
        . List of permissions associated with these credentials.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secret value of the key.
        """
        return pulumi.get(self, "secret_key")

