# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqsQueueArgs', 'SqsQueue']

@pulumi.input_type
class SqsQueueArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[_builtins.str],
                 secret_key: pulumi.Input[_builtins.str],
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_letter_queue: Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 message_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sqs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a SqsQueue resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SQS queue.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SQS queue.
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication. Defaults to `false`.
        :param pulumi.Input['SqsQueueDeadLetterQueueArgs'] dead_letter_queue: Configuration for the dead letter queue. See Dead Letter Queue below for details.
        :param pulumi.Input[_builtins.bool] fifo_queue: Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        :param pulumi.Input[_builtins.int] message_max_age: The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        :param pulumi.Input[_builtins.int] message_max_size: The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] sqs_endpoint: The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "secret_key", secret_key)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if message_max_age is not None:
            pulumi.set(__self__, "message_max_age", message_max_age)
        if message_max_size is not None:
            pulumi.set(__self__, "message_max_size", message_max_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if receive_wait_time_seconds is not None:
            pulumi.set(__self__, "receive_wait_time_seconds", receive_wait_time_seconds)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sqs_endpoint is not None:
            pulumi.set(__self__, "sqs_endpoint", sqs_endpoint)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[_builtins.str]:
        """
        The access key of the SQS queue.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        The secret key of the SQS queue.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable content-based deduplication. Defaults to `false`.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']]:
        """
        Configuration for the dead letter queue. See Dead Letter Queue below for details.
        """
        return pulumi.get(self, "dead_letter_queue")

    @dead_letter_queue.setter
    def dead_letter_queue(self, value: Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']]):
        pulumi.set(self, "dead_letter_queue", value)

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fifo_queue", value)

    @_builtins.property
    @pulumi.getter(name="messageMaxAge")
    def message_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        """
        return pulumi.get(self, "message_max_age")

    @message_max_age.setter
    def message_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_max_age", value)

    @_builtins.property
    @pulumi.getter(name="messageMaxSize")
    def message_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        """
        return pulumi.get(self, "message_max_size")

    @message_max_size.setter
    def message_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_max_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @receive_wait_time_seconds.setter
    def receive_wait_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "receive_wait_time_seconds", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sqsEndpoint")
    def sqs_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sqs_endpoint")

    @sqs_endpoint.setter
    def sqs_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sqs_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


@pulumi.input_type
class _SqsQueueState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_letter_queue: Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 message_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sqs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SqsQueue resources.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SQS queue.
        :param pulumi.Input[_builtins.str] arn: The ARN of the queue
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication. Defaults to `false`.
        :param pulumi.Input['SqsQueueDeadLetterQueueArgs'] dead_letter_queue: Configuration for the dead letter queue. See Dead Letter Queue below for details.
        :param pulumi.Input[_builtins.bool] fifo_queue: Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        :param pulumi.Input[_builtins.int] message_max_age: The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        :param pulumi.Input[_builtins.int] message_max_size: The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SQS queue.
        :param pulumi.Input[_builtins.str] sqs_endpoint: The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] url: The URL of the queue.
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if fifo_queue is not None:
            pulumi.set(__self__, "fifo_queue", fifo_queue)
        if message_max_age is not None:
            pulumi.set(__self__, "message_max_age", message_max_age)
        if message_max_size is not None:
            pulumi.set(__self__, "message_max_size", message_max_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if receive_wait_time_seconds is not None:
            pulumi.set(__self__, "receive_wait_time_seconds", receive_wait_time_seconds)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sqs_endpoint is not None:
            pulumi.set(__self__, "sqs_endpoint", sqs_endpoint)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if visibility_timeout_seconds is not None:
            pulumi.set(__self__, "visibility_timeout_seconds", visibility_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key of the SQS queue.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the queue
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable content-based deduplication. Defaults to `false`.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']]:
        """
        Configuration for the dead letter queue. See Dead Letter Queue below for details.
        """
        return pulumi.get(self, "dead_letter_queue")

    @dead_letter_queue.setter
    def dead_letter_queue(self, value: Optional[pulumi.Input['SqsQueueDeadLetterQueueArgs']]):
        pulumi.set(self, "dead_letter_queue", value)

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        """
        return pulumi.get(self, "fifo_queue")

    @fifo_queue.setter
    def fifo_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fifo_queue", value)

    @_builtins.property
    @pulumi.getter(name="messageMaxAge")
    def message_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        """
        return pulumi.get(self, "message_max_age")

    @message_max_age.setter
    def message_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_max_age", value)

    @_builtins.property
    @pulumi.getter(name="messageMaxSize")
    def message_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        """
        return pulumi.get(self, "message_max_size")

    @message_max_size.setter
    def message_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_max_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @receive_wait_time_seconds.setter
    def receive_wait_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "receive_wait_time_seconds", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key of the SQS queue.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="sqsEndpoint")
    def sqs_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sqs_endpoint")

    @sqs_endpoint.setter
    def sqs_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sqs_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the queue.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

    @visibility_timeout_seconds.setter
    def visibility_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_timeout_seconds", value)


@pulumi.type_token("scaleway:mnq/sqsQueue:SqsQueue")
class SqsQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_letter_queue: Optional[pulumi.Input[Union['SqsQueueDeadLetterQueueArgs', 'SqsQueueDeadLetterQueueArgsDict']]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 message_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sqs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Messaging and Queuing SQS queues.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/how-to/create-manage-queues/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": True,
                "can_receive": False,
                "can_publish": False,
            })
        main_sqs_queue = scaleway.mnq.SqsQueue("main",
            project_id=main.project_id,
            name="my-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key)
        ```

        ### With Dead Letter Queue

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": True,
                "can_receive": False,
                "can_publish": False,
            })
        dead_letter = scaleway.mnq.SqsQueue("dead_letter",
            project_id=main.project_id,
            name="dead-letter-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key)
        main_sqs_queue = scaleway.mnq.SqsQueue("main",
            project_id=main.project_id,
            name="my-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key,
            dead_letter_queue={
                "id": dead_letter.id,
                "max_receive_count": 3,
            })
        ```

        ## Dead Letter Queue

        The `dead_letter_queue` block supports the following:

        - `id` - (Required) The ID of the dead letter queue. Can be either in the format `{region}/{project-id}/{queue-name}` or `arn:scw:sqs:{region}:project-{project-id}:{queue-name}`.

        - `max_receive_count` - (Required) The number of times a message is delivered to the source queue before being moved to the dead letter queue. Must be between 1 and 1000.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SQS queue.
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication. Defaults to `false`.
        :param pulumi.Input[Union['SqsQueueDeadLetterQueueArgs', 'SqsQueueDeadLetterQueueArgsDict']] dead_letter_queue: Configuration for the dead letter queue. See Dead Letter Queue below for details.
        :param pulumi.Input[_builtins.bool] fifo_queue: Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        :param pulumi.Input[_builtins.int] message_max_age: The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        :param pulumi.Input[_builtins.int] message_max_size: The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SQS queue.
        :param pulumi.Input[_builtins.str] sqs_endpoint: The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqsQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Messaging and Queuing SQS queues.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/how-to/create-manage-queues/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": True,
                "can_receive": False,
                "can_publish": False,
            })
        main_sqs_queue = scaleway.mnq.SqsQueue("main",
            project_id=main.project_id,
            name="my-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key)
        ```

        ### With Dead Letter Queue

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        main_sqs_credentials = scaleway.mnq.SqsCredentials("main",
            project_id=main.project_id,
            name="sqs-credentials",
            permissions={
                "can_manage": True,
                "can_receive": False,
                "can_publish": False,
            })
        dead_letter = scaleway.mnq.SqsQueue("dead_letter",
            project_id=main.project_id,
            name="dead-letter-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key)
        main_sqs_queue = scaleway.mnq.SqsQueue("main",
            project_id=main.project_id,
            name="my-queue",
            sqs_endpoint=main.endpoint,
            access_key=main_sqs_credentials.access_key,
            secret_key=main_sqs_credentials.secret_key,
            dead_letter_queue={
                "id": dead_letter.id,
                "max_receive_count": 3,
            })
        ```

        ## Dead Letter Queue

        The `dead_letter_queue` block supports the following:

        - `id` - (Required) The ID of the dead letter queue. Can be either in the format `{region}/{project-id}/{queue-name}` or `arn:scw:sqs:{region}:project-{project-id}:{queue-name}`.

        - `max_receive_count` - (Required) The number of times a message is delivered to the source queue before being moved to the dead letter queue. Must be between 1 and 1000.

        :param str resource_name: The name of the resource.
        :param SqsQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqsQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_letter_queue: Optional[pulumi.Input[Union['SqsQueueDeadLetterQueueArgs', 'SqsQueueDeadLetterQueueArgsDict']]] = None,
                 fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 message_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 message_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sqs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqsQueueArgs.__new__(SqsQueueArgs)

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["dead_letter_queue"] = dead_letter_queue
            __props__.__dict__["fifo_queue"] = fifo_queue
            __props__.__dict__["message_max_age"] = message_max_age
            __props__.__dict__["message_max_size"] = message_max_size
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["receive_wait_time_seconds"] = receive_wait_time_seconds
            __props__.__dict__["region"] = region
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["sqs_endpoint"] = sqs_endpoint
            __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["url"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/mnqSqsQueue:MnqSqsQueue")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SqsQueue, __self__).__init__(
            'scaleway:mnq/sqsQueue:SqsQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            content_based_deduplication: Optional[pulumi.Input[_builtins.bool]] = None,
            dead_letter_queue: Optional[pulumi.Input[Union['SqsQueueDeadLetterQueueArgs', 'SqsQueueDeadLetterQueueArgsDict']]] = None,
            fifo_queue: Optional[pulumi.Input[_builtins.bool]] = None,
            message_max_age: Optional[pulumi.Input[_builtins.int]] = None,
            message_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            receive_wait_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            sqs_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            visibility_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'SqsQueue':
        """
        Get an existing SqsQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SQS queue.
        :param pulumi.Input[_builtins.str] arn: The ARN of the queue
        :param pulumi.Input[_builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication. Defaults to `false`.
        :param pulumi.Input[Union['SqsQueueDeadLetterQueueArgs', 'SqsQueueDeadLetterQueueArgsDict']] dead_letter_queue: Configuration for the dead letter queue. See Dead Letter Queue below for details.
        :param pulumi.Input[_builtins.bool] fifo_queue: Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        :param pulumi.Input[_builtins.int] message_max_age: The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        :param pulumi.Input[_builtins.int] message_max_size: The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        :param pulumi.Input[_builtins.str] name: The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS is enabled.
        :param pulumi.Input[_builtins.int] receive_wait_time_seconds: The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which SQS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SQS queue.
        :param pulumi.Input[_builtins.str] sqs_endpoint: The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] url: The URL of the queue.
        :param pulumi.Input[_builtins.int] visibility_timeout_seconds: The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqsQueueState.__new__(_SqsQueueState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["arn"] = arn
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["dead_letter_queue"] = dead_letter_queue
        __props__.__dict__["fifo_queue"] = fifo_queue
        __props__.__dict__["message_max_age"] = message_max_age
        __props__.__dict__["message_max_size"] = message_max_size
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["receive_wait_time_seconds"] = receive_wait_time_seconds
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["sqs_endpoint"] = sqs_endpoint
        __props__.__dict__["url"] = url
        __props__.__dict__["visibility_timeout_seconds"] = visibility_timeout_seconds
        return SqsQueue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The access key of the SQS queue.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the queue
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable content-based deduplication. Defaults to `false`.
        """
        return pulumi.get(self, "content_based_deduplication")

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> pulumi.Output[Optional['outputs.SqsQueueDeadLetterQueue']]:
        """
        Configuration for the dead letter queue. See Dead Letter Queue below for details.
        """
        return pulumi.get(self, "dead_letter_queue")

    @_builtins.property
    @pulumi.getter(name="fifoQueue")
    def fifo_queue(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the queue is a FIFO queue. If true, the queue name must end with .fifo. Defaults to `false`.
        """
        return pulumi.get(self, "fifo_queue")

    @_builtins.property
    @pulumi.getter(name="messageMaxAge")
    def message_max_age(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of seconds the queue retains a message. Must be between 60 and 1_209_600. Defaults to 345_600.
        """
        return pulumi.get(self, "message_max_age")

    @_builtins.property
    @pulumi.getter(name="messageMaxSize")
    def message_max_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum size of a message. Should be in bytes. Must be between 1024 and 262_144. Defaults to 262_144.
        """
        return pulumi.get(self, "message_max_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the SQS queue. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project in which SQS is enabled.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="receiveWaitTimeSeconds")
    def receive_wait_time_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of seconds to wait for a message to arrive in the queue before returning. Must be between 0 and 20. Defaults to 0.
        """
        return pulumi.get(self, "receive_wait_time_seconds")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region in which SQS is enabled.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secret key of the SQS queue.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="sqsEndpoint")
    def sqs_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint of the SQS queue. Can contain a {region} placeholder. Defaults to `https://sqs.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sqs_endpoint")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the queue.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="visibilityTimeoutSeconds")
    def visibility_timeout_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of seconds a message is hidden from other consumers. Must be between 0 and 43_200. Defaults to 30.
        """
        return pulumi.get(self, "visibility_timeout_seconds")

