# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MongoDbInstanceArgs', 'MongoDbInstance']

@pulumi.input_type
class MongoDbInstanceArgs:
    def __init__(__self__, *,
                 node_number: pulumi.Input[_builtins.int],
                 node_type: pulumi.Input[_builtins.str],
                 is_snapshot_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network: Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_schedule_frequency_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_schedule_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MongoDbInstance resource.
        :param pulumi.Input[_builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[_builtins.str] node_type: The type of MongoDB® instance to create.
        :param pulumi.Input[_builtins.bool] is_snapshot_schedule_enabled: Whether automatic snapshot scheduling is enabled.
        :param pulumi.Input[_builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[_builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input['MongoDbInstancePrivateNetworkArgs'] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the MongoDB® instance is associated with.
        :param pulumi.Input['MongoDbInstancePublicNetworkArgs'] public_network: Public network endpoint configuration (no arguments).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the MongoDB® instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[_builtins.int] snapshot_schedule_frequency_hours: Snapshot schedule frequency in hours.
        :param pulumi.Input[_builtins.int] snapshot_schedule_retention_days: Snapshot schedule retention in days.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[_builtins.str] user_name: Name of the user created when the instance is created.
        :param pulumi.Input[_builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[_builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[_builtins.str] volume_type: Volume type of the instance.
        """
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "node_type", node_type)
        if is_snapshot_schedule_enabled is not None:
            pulumi.set(__self__, "is_snapshot_schedule_enabled", is_snapshot_schedule_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_schedule_frequency_hours is not None:
            pulumi.set(__self__, "snapshot_schedule_frequency_hours", snapshot_schedule_frequency_hours)
        if snapshot_schedule_retention_days is not None:
            pulumi.set(__self__, "snapshot_schedule_retention_days", snapshot_schedule_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[_builtins.int]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of MongoDB® instance to create.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="isSnapshotScheduleEnabled")
    def is_snapshot_schedule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether automatic snapshot scheduling is enabled.
        """
        return pulumi.get(self, "is_snapshot_schedule_enabled")

    @is_snapshot_schedule_enabled.setter
    def is_snapshot_schedule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_snapshot_schedule_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the MongoDB® instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']]:
        """
        Public network endpoint configuration (no arguments).
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the MongoDB® instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleFrequencyHours")
    def snapshot_schedule_frequency_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Snapshot schedule frequency in hours.
        """
        return pulumi.get(self, "snapshot_schedule_frequency_hours")

    @snapshot_schedule_frequency_hours.setter
    def snapshot_schedule_frequency_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_schedule_frequency_hours", value)

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleRetentionDays")
    def snapshot_schedule_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Snapshot schedule retention in days.
        """
        return pulumi.get(self, "snapshot_schedule_retention_days")

    @snapshot_schedule_retention_days.setter
    def snapshot_schedule_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_schedule_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user created when the instance is created.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _MongoDbInstanceState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_snapshot_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network: Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_schedule_frequency_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_schedule_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MongoDbInstance resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the MongoDB® instance.
        :param pulumi.Input[_builtins.bool] is_snapshot_schedule_enabled: Whether automatic snapshot scheduling is enabled.
        :param pulumi.Input[_builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[_builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[_builtins.str] node_type: The type of MongoDB® instance to create.
        :param pulumi.Input[_builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input['MongoDbInstancePrivateNetworkArgs'] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the MongoDB® instance is associated with.
        :param pulumi.Input['MongoDbInstancePublicNetworkArgs'] public_network: Public network endpoint configuration (no arguments).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the MongoDB® instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[_builtins.int] snapshot_schedule_frequency_hours: Snapshot schedule frequency in hours.
        :param pulumi.Input[_builtins.int] snapshot_schedule_retention_days: Snapshot schedule retention in days.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[_builtins.str] tls_certificate: The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the MongoDB® instance.
        :param pulumi.Input[_builtins.str] user_name: Name of the user created when the instance is created.
        :param pulumi.Input[_builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[_builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[_builtins.str] volume_type: Volume type of the instance.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if is_snapshot_schedule_enabled is not None:
            pulumi.set(__self__, "is_snapshot_schedule_enabled", is_snapshot_schedule_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_number is not None:
            pulumi.set(__self__, "node_number", node_number)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_schedule_frequency_hours is not None:
            pulumi.set(__self__, "snapshot_schedule_frequency_hours", snapshot_schedule_frequency_hours)
        if snapshot_schedule_retention_days is not None:
            pulumi.set(__self__, "snapshot_schedule_retention_days", snapshot_schedule_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the MongoDB® instance.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="isSnapshotScheduleEnabled")
    def is_snapshot_schedule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether automatic snapshot scheduling is enabled.
        """
        return pulumi.get(self, "is_snapshot_schedule_enabled")

    @is_snapshot_schedule_enabled.setter
    def is_snapshot_schedule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_snapshot_schedule_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_number", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of MongoDB® instance to create.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoDbInstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['MongoDbInstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the MongoDB® instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']]:
        """
        Public network endpoint configuration (no arguments).
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['MongoDbInstancePublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the MongoDB® instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleFrequencyHours")
    def snapshot_schedule_frequency_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Snapshot schedule frequency in hours.
        """
        return pulumi.get(self, "snapshot_schedule_frequency_hours")

    @snapshot_schedule_frequency_hours.setter
    def snapshot_schedule_frequency_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_schedule_frequency_hours", value)

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleRetentionDays")
    def snapshot_schedule_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Snapshot schedule retention in days.
        """
        return pulumi.get(self, "snapshot_schedule_retention_days")

    @snapshot_schedule_retention_days.setter
    def snapshot_schedule_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_schedule_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        """
        return pulumi.get(self, "tls_certificate")

    @tls_certificate.setter
    def tls_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_certificate", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the MongoDB® instance.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user created when the instance is created.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


warnings.warn("""scaleway.index/mongodbinstance.MongoDbInstance has been deprecated in favor of scaleway.mongodb/instance.Instance""", DeprecationWarning)


@pulumi.type_token("scaleway:index/mongoDbInstance:MongoDbInstance")
class MongoDbInstance(pulumi.CustomResource):
    warnings.warn("""scaleway.index/mongodbinstance.MongoDbInstance has been deprecated in favor of scaleway.mongodb/instance.Instance""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_snapshot_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoDbInstancePrivateIpArgs', 'MongoDbInstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['MongoDbInstancePrivateNetworkArgs', 'MongoDbInstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['MongoDbInstancePublicNetworkArgs', 'MongoDbInstancePublicNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_schedule_frequency_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_schedule_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway MongoDB® instance.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5)
        ```

        ### Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            })
        ```

        ### Private Network and Public Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            },
            public_network={})
        ```

        ### With Snapshot Scheduling

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-with-snapshots",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            snapshot_schedule_frequency_hours=24,
            snapshot_schedule_retention_days=7,
            is_snapshot_schedule_enabled=True)
        ```

        ### Restore From Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        restored_instance = scaleway.mongodb.Instance("restored_instance",
            snapshot_id=pn["idscalewayMongodbSnapshot"]["mainSnapshot"]["id"],
            name="restored-mongodb-from-snapshot",
            node_type="MGDB-PLAY2-NANO",
            node_number=1)
        ```

        ## Import

        MongoDB® instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mongoDbInstance:MongoDbInstance main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_snapshot_schedule_enabled: Whether automatic snapshot scheduling is enabled.
        :param pulumi.Input[_builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[_builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[_builtins.str] node_type: The type of MongoDB® instance to create.
        :param pulumi.Input[_builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoDbInstancePrivateIpArgs', 'MongoDbInstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input[Union['MongoDbInstancePrivateNetworkArgs', 'MongoDbInstancePrivateNetworkArgsDict']] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the MongoDB® instance is associated with.
        :param pulumi.Input[Union['MongoDbInstancePublicNetworkArgs', 'MongoDbInstancePublicNetworkArgsDict']] public_network: Public network endpoint configuration (no arguments).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the MongoDB® instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[_builtins.int] snapshot_schedule_frequency_hours: Snapshot schedule frequency in hours.
        :param pulumi.Input[_builtins.int] snapshot_schedule_retention_days: Snapshot schedule retention in days.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[_builtins.str] user_name: Name of the user created when the instance is created.
        :param pulumi.Input[_builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[_builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[_builtins.str] volume_type: Volume type of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoDbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway MongoDB® instance.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5)
        ```

        ### Private Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            })
        ```

        ### Private Network and Public Network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="my_private_network",
            region="fr-par")
        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-basic1",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            private_network={
                "pn_id": pn02["id"],
            },
            public_network={})
        ```

        ### With Snapshot Scheduling

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-with-snapshots",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_size_in_gb=5,
            snapshot_schedule_frequency_hours=24,
            snapshot_schedule_retention_days=7,
            is_snapshot_schedule_enabled=True)
        ```

        ### Restore From Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        restored_instance = scaleway.mongodb.Instance("restored_instance",
            snapshot_id=pn["idscalewayMongodbSnapshot"]["mainSnapshot"]["id"],
            name="restored-mongodb-from-snapshot",
            node_type="MGDB-PLAY2-NANO",
            node_number=1)
        ```

        ## Import

        MongoDB® instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mongoDbInstance:MongoDbInstance main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param MongoDbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoDbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_snapshot_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_number: Optional[pulumi.Input[_builtins.int]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoDbInstancePrivateIpArgs', 'MongoDbInstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['MongoDbInstancePrivateNetworkArgs', 'MongoDbInstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network: Optional[pulumi.Input[Union['MongoDbInstancePublicNetworkArgs', 'MongoDbInstancePublicNetworkArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_schedule_frequency_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_schedule_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""MongoDbInstance is deprecated: scaleway.index/mongodbinstance.MongoDbInstance has been deprecated in favor of scaleway.mongodb/instance.Instance""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoDbInstanceArgs.__new__(MongoDbInstanceArgs)

            __props__.__dict__["is_snapshot_schedule_enabled"] = is_snapshot_schedule_enabled
            __props__.__dict__["name"] = name
            if node_number is None and not opts.urn:
                raise TypeError("Missing required property 'node_number'")
            __props__.__dict__["node_number"] = node_number
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_network"] = public_network
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["snapshot_schedule_frequency_hours"] = snapshot_schedule_frequency_hours
            __props__.__dict__["snapshot_schedule_retention_days"] = snapshot_schedule_retention_days
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["version"] = version
            __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tls_certificate"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MongoDbInstance, __self__).__init__(
            'scaleway:index/mongoDbInstance:MongoDbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            is_snapshot_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_number: Optional[pulumi.Input[_builtins.int]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoDbInstancePrivateIpArgs', 'MongoDbInstancePrivateIpArgsDict']]]]] = None,
            private_network: Optional[pulumi.Input[Union['MongoDbInstancePrivateNetworkArgs', 'MongoDbInstancePrivateNetworkArgsDict']]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_network: Optional[pulumi.Input[Union['MongoDbInstancePublicNetworkArgs', 'MongoDbInstancePublicNetworkArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_schedule_frequency_hours: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_schedule_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tls_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            volume_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'MongoDbInstance':
        """
        Get an existing MongoDbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the MongoDB® instance.
        :param pulumi.Input[_builtins.bool] is_snapshot_schedule_enabled: Whether automatic snapshot scheduling is enabled.
        :param pulumi.Input[_builtins.str] name: Name of the MongoDB® instance.
        :param pulumi.Input[_builtins.int] node_number: Number of nodes in the instance
        :param pulumi.Input[_builtins.str] node_type: The type of MongoDB® instance to create.
        :param pulumi.Input[_builtins.str] password: Password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoDbInstancePrivateIpArgs', 'MongoDbInstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the instance.
        :param pulumi.Input[Union['MongoDbInstancePrivateNetworkArgs', 'MongoDbInstancePrivateNetworkArgsDict']] private_network: Private Network endpoints of the Database Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the MongoDB® instance is associated with.
        :param pulumi.Input[Union['MongoDbInstancePublicNetworkArgs', 'MongoDbInstancePublicNetworkArgsDict']] public_network: Public network endpoint configuration (no arguments).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the MongoDB® instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of settings to define for the instance.
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID to restore the MongoDB® instance from.
        :param pulumi.Input[_builtins.int] snapshot_schedule_frequency_hours: Snapshot schedule frequency in hours.
        :param pulumi.Input[_builtins.int] snapshot_schedule_retention_days: Snapshot schedule retention in days.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags attached to the MongoDB® instance.
        :param pulumi.Input[_builtins.str] tls_certificate: The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the MongoDB® instance.
        :param pulumi.Input[_builtins.str] user_name: Name of the user created when the instance is created.
        :param pulumi.Input[_builtins.str] version: MongoDB® version of the instance.
        :param pulumi.Input[_builtins.int] volume_size_in_gb: Volume size in GB.
        :param pulumi.Input[_builtins.str] volume_type: Volume type of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoDbInstanceState.__new__(_MongoDbInstanceState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["is_snapshot_schedule_enabled"] = is_snapshot_schedule_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["node_number"] = node_number
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["region"] = region
        __props__.__dict__["settings"] = settings
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["snapshot_schedule_frequency_hours"] = snapshot_schedule_frequency_hours
        __props__.__dict__["snapshot_schedule_retention_days"] = snapshot_schedule_retention_days
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_certificate"] = tls_certificate
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["version"] = version
        __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
        __props__.__dict__["volume_type"] = volume_type
        return MongoDbInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the MongoDB® instance.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="isSnapshotScheduleEnabled")
    def is_snapshot_schedule_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether automatic snapshot scheduling is enabled.
        """
        return pulumi.get(self, "is_snapshot_schedule_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the MongoDB® instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes in the instance
        """
        return pulumi.get(self, "node_number")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of MongoDB® instance to create.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.MongoDbInstancePrivateIp']]:
        """
        The private IPv4 address associated with the instance.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional['outputs.MongoDbInstancePrivateNetwork']]:
        """
        Private Network endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the MongoDB® instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.MongoDbInstancePublicNetwork']:
        """
        Public network endpoint configuration (no arguments).
        """
        return pulumi.get(self, "public_network")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region in which the MongoDB® instance should be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of settings to define for the instance.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Snapshot ID to restore the MongoDB® instance from.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleFrequencyHours")
    def snapshot_schedule_frequency_hours(self) -> pulumi.Output[_builtins.int]:
        """
        Snapshot schedule frequency in hours.
        """
        return pulumi.get(self, "snapshot_schedule_frequency_hours")

    @_builtins.property
    @pulumi.getter(name="snapshotScheduleRetentionDays")
    def snapshot_schedule_retention_days(self) -> pulumi.Output[_builtins.int]:
        """
        Snapshot schedule retention in days.
        """
        return pulumi.get(self, "snapshot_schedule_retention_days")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags attached to the MongoDB® instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The PEM-encoded TLS certificate for the MongoDB® instance, if available.
        """
        return pulumi.get(self, "tls_certificate")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the MongoDB® instance.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the user created when the instance is created.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        MongoDB® version of the instance.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Volume size in GB.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Volume type of the instance.
        """
        return pulumi.get(self, "volume_type")

