# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayNetworkArgs', 'GatewayNetwork']

@pulumi.input_type
class GatewayNetworkArgs:
    def __init__(__self__, *,
                 gateway_id: pulumi.Input[_builtins.str],
                 private_network_id: pulumi.Input[_builtins.str],
                 cleanup_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_masquerade: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipam_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]] = None,
                 static_address: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayNetwork resource.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Public Gateway.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the Private Network.
        :param pulumi.Input[_builtins.bool] cleanup_dhcp: Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        :param pulumi.Input[_builtins.str] dhcp_id: Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.bool] enable_dhcp: Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        :param pulumi.Input[_builtins.bool] enable_masquerade: Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]] ipam_configs: Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[_builtins.str] static_address: Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the gateway network should be created.
               
               > **Important:**
               In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
               For more information, please refer to the dedicated guide.
        """
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "private_network_id", private_network_id)
        if cleanup_dhcp is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""cleanup_dhcp is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if cleanup_dhcp is not None:
            pulumi.set(__self__, "cleanup_dhcp", cleanup_dhcp)
        if dhcp_id is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""dhcp_id is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if dhcp_id is not None:
            pulumi.set(__self__, "dhcp_id", dhcp_id)
        if enable_dhcp is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""enable_dhcp is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if enable_masquerade is not None:
            pulumi.set(__self__, "enable_masquerade", enable_masquerade)
        if ipam_configs is not None:
            pulumi.set(__self__, "ipam_configs", ipam_configs)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if static_address is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""static_address is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if static_address is not None:
            pulumi.set(__self__, "static_address", static_address)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Public Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="cleanupDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def cleanup_dhcp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        """
        return pulumi.get(self, "cleanup_dhcp")

    @cleanup_dhcp.setter
    def cleanup_dhcp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cleanup_dhcp", value)

    @_builtins.property
    @pulumi.getter(name="dhcpId")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def dhcp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "dhcp_id")

    @dhcp_id.setter
    def dhcp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_id", value)

    @_builtins.property
    @pulumi.getter(name="enableDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def enable_dhcp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        """
        return pulumi.get(self, "enable_dhcp")

    @enable_dhcp.setter
    def enable_dhcp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dhcp", value)

    @_builtins.property
    @pulumi.getter(name="enableMasquerade")
    def enable_masquerade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        """
        return pulumi.get(self, "enable_masquerade")

    @enable_masquerade.setter
    def enable_masquerade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_masquerade", value)

    @_builtins.property
    @pulumi.getter(name="ipamConfigs")
    def ipam_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]]:
        """
        Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "ipam_configs")

    @ipam_configs.setter
    def ipam_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]]):
        pulumi.set(self, "ipam_configs", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="staticAddress")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def static_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "static_address")

    @static_address.setter
    def static_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_address", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the gateway network should be created.

        > **Important:**
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
        For more information, please refer to the dedicated guide.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _GatewayNetworkState:
    def __init__(__self__, *,
                 cleanup_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_masquerade: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_address: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayNetwork resources.
        :param pulumi.Input[_builtins.bool] cleanup_dhcp: Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the GatewayNetwork.
        :param pulumi.Input[_builtins.str] dhcp_id: Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.bool] enable_dhcp: Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        :param pulumi.Input[_builtins.bool] enable_masquerade: Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Public Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]] ipam_configs: Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the GatewayNetwork.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the Private Network.
        :param pulumi.Input[_builtins.str] static_address: Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] status: The status of the Public Gateway's connection to the Private Network.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the GatewayNetwork.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the gateway network should be created.
               
               > **Important:**
               In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
               For more information, please refer to the dedicated guide.
        """
        if cleanup_dhcp is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""cleanup_dhcp is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if cleanup_dhcp is not None:
            pulumi.set(__self__, "cleanup_dhcp", cleanup_dhcp)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dhcp_id is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""dhcp_id is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if dhcp_id is not None:
            pulumi.set(__self__, "dhcp_id", dhcp_id)
        if enable_dhcp is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""enable_dhcp is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if enable_masquerade is not None:
            pulumi.set(__self__, "enable_masquerade", enable_masquerade)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if ipam_configs is not None:
            pulumi.set(__self__, "ipam_configs", ipam_configs)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if static_address is not None:
            warnings.warn("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""", DeprecationWarning)
            pulumi.log.warn("""static_address is deprecated: Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
        if static_address is not None:
            pulumi.set(__self__, "static_address", static_address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="cleanupDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def cleanup_dhcp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        """
        return pulumi.get(self, "cleanup_dhcp")

    @cleanup_dhcp.setter
    def cleanup_dhcp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cleanup_dhcp", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the GatewayNetwork.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dhcpId")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def dhcp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "dhcp_id")

    @dhcp_id.setter
    def dhcp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_id", value)

    @_builtins.property
    @pulumi.getter(name="enableDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def enable_dhcp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        """
        return pulumi.get(self, "enable_dhcp")

    @enable_dhcp.setter
    def enable_dhcp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dhcp", value)

    @_builtins.property
    @pulumi.getter(name="enableMasquerade")
    def enable_masquerade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        """
        return pulumi.get(self, "enable_masquerade")

    @enable_masquerade.setter
    def enable_masquerade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_masquerade", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Public Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="ipamConfigs")
    def ipam_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]]:
        """
        Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "ipam_configs")

    @ipam_configs.setter
    def ipam_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkIpamConfigArgs']]]]):
        pulumi.set(self, "ipam_configs", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the GatewayNetwork.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayNetworkPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="staticAddress")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def static_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "static_address")

    @static_address.setter
    def static_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_address", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Public Gateway's connection to the Private Network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the GatewayNetwork.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the gateway network should be created.

        > **Important:**
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
        For more information, please refer to the dedicated guide.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:network/gatewayNetwork:GatewayNetwork")
class GatewayNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_masquerade: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkIpamConfigArgs', 'GatewayNetworkIpamConfigArgsDict']]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkPrivateIpArgs', 'GatewayNetworkPrivateIpArgsDict']]]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_address: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages GatewayNetworks (connections between a Public Gateway and a Private Network).

        It allows the attachment of Private Networks to Public Gateways.
        For more information, see [the API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#step-3-attach-private-networks-to-the-vpc-public-gateway).

        ## Example Usage

        ### Create a GatewayNetwork with IPAM configuration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="pn_test_network",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        pg01 = scaleway.network.PublicGateway("pg01",
            name="foobar",
            type="VPC-GW-S")
        main = scaleway.network.GatewayNetwork("main",
            gateway_id=pg01.id,
            private_network_id=pn01.id,
            enable_masquerade=True,
            ipam_configs=[{
                "push_default_route": True,
            }])
        ```

        ### Create a GatewayNetwork with a booked IPAM IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="pn_test_network",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.64.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        pg01 = scaleway.network.PublicGateway("pg01",
            name="foobar",
            type="VPC-GW-S")
        main = scaleway.network.GatewayNetwork("main",
            gateway_id=pg01.id,
            private_network_id=pn01.id,
            enable_masquerade=True,
            ipam_configs=[{
                "push_default_route": True,
                "ipam_ip_id": ip01.id,
            }])
        ```

        ## Import

        GatewayNetwork can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/gatewayNetwork:GatewayNetwork main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cleanup_dhcp: Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        :param pulumi.Input[_builtins.str] dhcp_id: Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.bool] enable_dhcp: Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        :param pulumi.Input[_builtins.bool] enable_masquerade: Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Public Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkIpamConfigArgs', 'GatewayNetworkIpamConfigArgsDict']]]] ipam_configs: Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkPrivateIpArgs', 'GatewayNetworkPrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the Private Network.
        :param pulumi.Input[_builtins.str] static_address: Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the gateway network should be created.
               
               > **Important:**
               In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
               For more information, please refer to the dedicated guide.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages GatewayNetworks (connections between a Public Gateway and a Private Network).

        It allows the attachment of Private Networks to Public Gateways.
        For more information, see [the API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#step-3-attach-private-networks-to-the-vpc-public-gateway).

        ## Example Usage

        ### Create a GatewayNetwork with IPAM configuration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="pn_test_network",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        pg01 = scaleway.network.PublicGateway("pg01",
            name="foobar",
            type="VPC-GW-S")
        main = scaleway.network.GatewayNetwork("main",
            gateway_id=pg01.id,
            private_network_id=pn01.id,
            enable_masquerade=True,
            ipam_configs=[{
                "push_default_route": True,
            }])
        ```

        ### Create a GatewayNetwork with a booked IPAM IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="pn_test_network",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.64.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        pg01 = scaleway.network.PublicGateway("pg01",
            name="foobar",
            type="VPC-GW-S")
        main = scaleway.network.GatewayNetwork("main",
            gateway_id=pg01.id,
            private_network_id=pn01.id,
            enable_masquerade=True,
            ipam_configs=[{
                "push_default_route": True,
                "ipam_ip_id": ip01.id,
            }])
        ```

        ## Import

        GatewayNetwork can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/gatewayNetwork:GatewayNetwork main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param GatewayNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_masquerade: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkIpamConfigArgs', 'GatewayNetworkIpamConfigArgsDict']]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkPrivateIpArgs', 'GatewayNetworkPrivateIpArgsDict']]]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_address: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayNetworkArgs.__new__(GatewayNetworkArgs)

            __props__.__dict__["cleanup_dhcp"] = cleanup_dhcp
            __props__.__dict__["dhcp_id"] = dhcp_id
            __props__.__dict__["enable_dhcp"] = enable_dhcp
            __props__.__dict__["enable_masquerade"] = enable_masquerade
            if gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_id'")
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["ipam_configs"] = ipam_configs
            __props__.__dict__["private_ips"] = private_ips
            if private_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_network_id'")
            __props__.__dict__["private_network_id"] = private_network_id
            __props__.__dict__["static_address"] = static_address
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/vpcGatewayNetwork:VpcGatewayNetwork")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(GatewayNetwork, __self__).__init__(
            'scaleway:network/gatewayNetwork:GatewayNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_dhcp: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_masquerade: Optional[pulumi.Input[_builtins.bool]] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkIpamConfigArgs', 'GatewayNetworkIpamConfigArgsDict']]]]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkPrivateIpArgs', 'GatewayNetworkPrivateIpArgsDict']]]]] = None,
            private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            static_address: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayNetwork':
        """
        Get an existing GatewayNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cleanup_dhcp: Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the GatewayNetwork.
        :param pulumi.Input[_builtins.str] dhcp_id: Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.bool] enable_dhcp: Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        :param pulumi.Input[_builtins.bool] enable_masquerade: Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the Public Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkIpamConfigArgs', 'GatewayNetworkIpamConfigArgsDict']]]] ipam_configs: Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the GatewayNetwork.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayNetworkPrivateIpArgs', 'GatewayNetworkPrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the Private Network.
        :param pulumi.Input[_builtins.str] static_address: Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        :param pulumi.Input[_builtins.str] status: The status of the Public Gateway's connection to the Private Network.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the GatewayNetwork.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the gateway network should be created.
               
               > **Important:**
               In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
               For more information, please refer to the dedicated guide.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayNetworkState.__new__(_GatewayNetworkState)

        __props__.__dict__["cleanup_dhcp"] = cleanup_dhcp
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dhcp_id"] = dhcp_id
        __props__.__dict__["enable_dhcp"] = enable_dhcp
        __props__.__dict__["enable_masquerade"] = enable_masquerade
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["ipam_configs"] = ipam_configs
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["static_address"] = static_address
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return GatewayNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cleanupDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def cleanup_dhcp(self) -> pulumi.Output[_builtins.bool]:
        """
        Please use `ipam_config`. Whether to remove DHCP configuration on this GatewayNetwork upon destroy. Requires DHCP ID.
        """
        return pulumi.get(self, "cleanup_dhcp")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the GatewayNetwork.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dhcpId")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def dhcp_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Please use `ipam_config`. The ID of the Public Gateway DHCP configuration. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "dhcp_id")

    @_builtins.property
    @pulumi.getter(name="enableDhcp")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def enable_dhcp(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Please use `ipam_config`. Whether a DHCP configuration should be enabled on this GatewayNetwork. Requires a DHCP ID.
        """
        return pulumi.get(self, "enable_dhcp")

    @_builtins.property
    @pulumi.getter(name="enableMasquerade")
    def enable_masquerade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether masquerade (dynamic NAT) should be enabled on this GatewayNetwork.
        """
        return pulumi.get(self, "enable_masquerade")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Public Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="ipamConfigs")
    def ipam_configs(self) -> pulumi.Output[Sequence['outputs.GatewayNetworkIpamConfig']]:
        """
        Auto-configure the GatewayNetwork using Scaleway's IPAM (IP address management service). Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "ipam_configs")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address of the GatewayNetwork.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.GatewayNetworkPrivateIp']]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="staticAddress")
    @_utilities.deprecated("""Please use ipam_config. For more information, please refer to the dedicated guide: https://github.com/scaleway/terraform-provider-scaleway/blob/master/docs/guides/migration_guide_vpcgw_v2.md""")
    def static_address(self) -> pulumi.Output[_builtins.str]:
        """
        Please use `ipam_config`. Enable DHCP configuration on this GatewayNetwork. Only one of `dhcp_id`, `static_address` and `ipam_config` should be specified.
        """
        return pulumi.get(self, "static_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Public Gateway's connection to the Private Network.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the GatewayNetwork.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the gateway network should be created.

        > **Important:**
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP fields are now deprecated.
        For more information, please refer to the dedicated guide.
        """
        return pulumi.get(self, "zone")

