# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPublicGatewayPatRuleResult',
    'AwaitableGetPublicGatewayPatRuleResult',
    'get_public_gateway_pat_rule',
    'get_public_gateway_pat_rule_output',
]

@pulumi.output_type
class GetPublicGatewayPatRuleResult:
    """
    A collection of values returned by getPublicGatewayPatRule.
    """
    def __init__(__self__, created_at=None, gateway_id=None, id=None, organization_id=None, pat_rule_id=None, private_ip=None, private_port=None, protocol=None, public_port=None, updated_at=None, zone=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if pat_rule_id and not isinstance(pat_rule_id, str):
            raise TypeError("Expected argument 'pat_rule_id' to be a str")
        pulumi.set(__self__, "pat_rule_id", pat_rule_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if private_port and not isinstance(private_port, int):
            raise TypeError("Expected argument 'private_port' to be a int")
        pulumi.set(__self__, "private_port", private_port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if public_port and not isinstance(public_port, int):
            raise TypeError("Expected argument 'public_port' to be a int")
        pulumi.set(__self__, "public_port", public_port)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        The ID of the Public Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="patRuleId")
    def pat_rule_id(self) -> _builtins.str:
        return pulumi.get(self, "pat_rule_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP address to forward data to.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> _builtins.int:
        """
        The private port to translate to.
        """
        return pulumi.get(self, "private_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol the rule should apply to. Possible values are `both`, `tcp` and `udp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> _builtins.int:
        """
        The public port to listen on.
        """
        return pulumi.get(self, "public_port")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetPublicGatewayPatRuleResult(GetPublicGatewayPatRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicGatewayPatRuleResult(
            created_at=self.created_at,
            gateway_id=self.gateway_id,
            id=self.id,
            organization_id=self.organization_id,
            pat_rule_id=self.pat_rule_id,
            private_ip=self.private_ip,
            private_port=self.private_port,
            protocol=self.protocol,
            public_port=self.public_port,
            updated_at=self.updated_at,
            zone=self.zone)


def get_public_gateway_pat_rule(pat_rule_id: Optional[_builtins.str] = None,
                                zone: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicGatewayPatRuleResult:
    """
    Gets information about a Public Gateway PAT rule. For further information, please see the
    [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#path-pat-rules-list-pat-rules).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    sg01 = scaleway.instance.SecurityGroup("sg01",
        inbound_default_policy="drop",
        outbound_default_policy="accept",
        inbound_rules=[{
            "action": "accept",
            "port": 22,
            "protocol": "TCP",
        }])
    srv01 = scaleway.instance.Server("srv01",
        name="my-server",
        type="PLAY2-NANO",
        image="ubuntu_jammy",
        security_group_id=sg01.id)
    pn01 = scaleway.network.PrivateNetwork("pn01", name="my-pn")
    pnic01 = scaleway.instance.PrivateNic("pnic01",
        server_id=srv01.id,
        private_network_id=pn01.id)
    dhcp01 = scaleway.network.PublicGatewayDhcp("dhcp01", subnet="192.168.0.0/24")
    ip01 = scaleway.network.PublicGatewayIp("ip01")
    pg01 = scaleway.network.PublicGateway("pg01",
        name="my-pg",
        type="VPC-GW-S",
        ip_id=ip01.id)
    gn01 = scaleway.network.GatewayNetwork("gn01",
        gateway_id=pg01.id,
        private_network_id=pn01.id,
        dhcp_id=dhcp01.id,
        cleanup_dhcp=True,
        enable_masquerade=True)
    rsv01 = scaleway.network.PublicGatewayDhcpReservation("rsv01",
        gateway_network_id=gn01.id,
        mac_address=pnic01.mac_address,
        ip_address="192.168.0.7")
    pat01 = scaleway.network.PublicGatewayPatRule("pat01",
        gateway_id=pg01.id,
        private_ip=rsv01.ip_address,
        private_port=22,
        public_port=2202,
        protocol="tcp")
    main = scaleway.network.get_public_gateway_pat_rule_output(pat_rule_id=pat01.id)
    ```


    :param _builtins.str pat_rule_id: The ID of the PAT rule to retrieve
    :param _builtins.str zone: `zone`) The zone in which
           the rule exists.
    """
    __args__ = dict()
    __args__['patRuleId'] = pat_rule_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:network/getPublicGatewayPatRule:getPublicGatewayPatRule', __args__, opts=opts, typ=GetPublicGatewayPatRuleResult).value

    return AwaitableGetPublicGatewayPatRuleResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        pat_rule_id=pulumi.get(__ret__, 'pat_rule_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        private_port=pulumi.get(__ret__, 'private_port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        public_port=pulumi.get(__ret__, 'public_port'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        zone=pulumi.get(__ret__, 'zone'))
def get_public_gateway_pat_rule_output(pat_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicGatewayPatRuleResult]:
    """
    Gets information about a Public Gateway PAT rule. For further information, please see the
    [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#path-pat-rules-list-pat-rules).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    sg01 = scaleway.instance.SecurityGroup("sg01",
        inbound_default_policy="drop",
        outbound_default_policy="accept",
        inbound_rules=[{
            "action": "accept",
            "port": 22,
            "protocol": "TCP",
        }])
    srv01 = scaleway.instance.Server("srv01",
        name="my-server",
        type="PLAY2-NANO",
        image="ubuntu_jammy",
        security_group_id=sg01.id)
    pn01 = scaleway.network.PrivateNetwork("pn01", name="my-pn")
    pnic01 = scaleway.instance.PrivateNic("pnic01",
        server_id=srv01.id,
        private_network_id=pn01.id)
    dhcp01 = scaleway.network.PublicGatewayDhcp("dhcp01", subnet="192.168.0.0/24")
    ip01 = scaleway.network.PublicGatewayIp("ip01")
    pg01 = scaleway.network.PublicGateway("pg01",
        name="my-pg",
        type="VPC-GW-S",
        ip_id=ip01.id)
    gn01 = scaleway.network.GatewayNetwork("gn01",
        gateway_id=pg01.id,
        private_network_id=pn01.id,
        dhcp_id=dhcp01.id,
        cleanup_dhcp=True,
        enable_masquerade=True)
    rsv01 = scaleway.network.PublicGatewayDhcpReservation("rsv01",
        gateway_network_id=gn01.id,
        mac_address=pnic01.mac_address,
        ip_address="192.168.0.7")
    pat01 = scaleway.network.PublicGatewayPatRule("pat01",
        gateway_id=pg01.id,
        private_ip=rsv01.ip_address,
        private_port=22,
        public_port=2202,
        protocol="tcp")
    main = scaleway.network.get_public_gateway_pat_rule_output(pat_rule_id=pat01.id)
    ```


    :param _builtins.str pat_rule_id: The ID of the PAT rule to retrieve
    :param _builtins.str zone: `zone`) The zone in which
           the rule exists.
    """
    __args__ = dict()
    __args__['patRuleId'] = pat_rule_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:network/getPublicGatewayPatRule:getPublicGatewayPatRule', __args__, opts=opts, typ=GetPublicGatewayPatRuleResult)
    return __ret__.apply(lambda __response__: GetPublicGatewayPatRuleResult(
        created_at=pulumi.get(__response__, 'created_at'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        pat_rule_id=pulumi.get(__response__, 'pat_rule_id'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        private_port=pulumi.get(__response__, 'private_port'),
        protocol=pulumi.get(__response__, 'protocol'),
        public_port=pulumi.get(__response__, 'public_port'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        zone=pulumi.get(__response__, 'zone')))
