# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicGatewayDhcpReservationArgs', 'PublicGatewayDhcpReservation']

@pulumi.input_type
class PublicGatewayDhcpReservationArgs:
    def __init__(__self__, *,
                 gateway_network_id: pulumi.Input[_builtins.str],
                 ip_address: pulumi.Input[_builtins.str],
                 mac_address: pulumi.Input[_builtins.str],
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PublicGatewayDhcpReservation resource.
        :param pulumi.Input[_builtins.str] gateway_network_id: The ID of the owning GatewayNetwork.
        :param pulumi.Input[_builtins.str] ip_address: The IP address to give to the machine.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address for the static entry.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        pulumi.set(__self__, "gateway_network_id", gateway_network_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the owning GatewayNetwork.
        """
        return pulumi.get(self, "gateway_network_id")

    @gateway_network_id.setter
    def gateway_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_network_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address to give to the machine.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Input[_builtins.str]:
        """
        The MAC address for the static entry.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _PublicGatewayDhcpReservationState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicGatewayDhcpReservation resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] gateway_network_id: The ID of the owning GatewayNetwork.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the client machine.
        :param pulumi.Input[_builtins.str] ip_address: The IP address to give to the machine.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address for the static entry.
        :param pulumi.Input[_builtins.str] type: The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are `reservation` and `lease`.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if gateway_network_id is not None:
            pulumi.set(__self__, "gateway_network_id", gateway_network_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the owning GatewayNetwork.
        """
        return pulumi.get(self, "gateway_network_id")

    @gateway_network_id.setter
    def gateway_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_network_id", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the client machine.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address to give to the machine.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address for the static entry.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are `reservation` and `lease`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:network/publicGatewayDhcpReservation:PublicGatewayDhcpReservation")
class PublicGatewayDhcpReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Important:**  The resource `network.PublicGatewayDhcpReservation` has been deprecated and will no longer be supported.
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP resources are now no longer needed.
        You can use IPAM to manage your IPs. For more information, please refer to the dedicated guide.

        Creates and manages [Scaleway DHCP Reservations](https://www.scaleway.com/en/docs/vpc/concepts/#dhcp).

        These static associations are used to assign IP addresses based on the MAC addresses of the resource.

        Statically assigned IP addresses should fall within the configured subnet, but be outside of the dynamic range.

        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-c05544).

        [DHCP reservations](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-entries-e40fb6) hold both dynamic DHCP leases (IP addresses dynamically assigned by the gateway to resources) and static user-created DHCP reservations.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PrivateNetwork("main", name="your_private_network")
        main_server = scaleway.instance.Server("main",
            image="ubuntu_jammy",
            type="DEV1-S",
            zone="fr-par-1",
            private_networks=[{
                "pn_id": main.id,
            }])
        main_public_gateway_ip = scaleway.network.PublicGatewayIp("main")
        main_public_gateway_dhcp = scaleway.network.PublicGatewayDhcp("main", subnet="192.168.1.0/24")
        main_public_gateway = scaleway.network.PublicGateway("main",
            name="foobar",
            type="VPC-GW-S",
            ip_id=main_public_gateway_ip.id)
        main_gateway_network = scaleway.network.GatewayNetwork("main",
            gateway_id=main_public_gateway.id,
            private_network_id=main.id,
            dhcp_id=main_public_gateway_dhcp.id,
            cleanup_dhcp=True,
            enable_masquerade=True,
            opts = pulumi.ResourceOptions(depends_on=[
                    main_public_gateway_ip,
                    main,
                ]))
        main_public_gateway_dhcp_reservation = scaleway.network.PublicGatewayDhcpReservation("main",
            gateway_network_id=main_gateway_network.id,
            mac_address=main_server.private_networks[0].mac_address,
            ip_address="192.168.1.1")
        ```

        ## Import

        Public Gateway DHCP reservation configurations can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/publicGatewayDhcpReservation:PublicGatewayDhcpReservation main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_network_id: The ID of the owning GatewayNetwork.
        :param pulumi.Input[_builtins.str] ip_address: The IP address to give to the machine.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address for the static entry.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicGatewayDhcpReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Important:**  The resource `network.PublicGatewayDhcpReservation` has been deprecated and will no longer be supported.
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP resources are now no longer needed.
        You can use IPAM to manage your IPs. For more information, please refer to the dedicated guide.

        Creates and manages [Scaleway DHCP Reservations](https://www.scaleway.com/en/docs/vpc/concepts/#dhcp).

        These static associations are used to assign IP addresses based on the MAC addresses of the resource.

        Statically assigned IP addresses should fall within the configured subnet, but be outside of the dynamic range.

        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-c05544).

        [DHCP reservations](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-entries-e40fb6) hold both dynamic DHCP leases (IP addresses dynamically assigned by the gateway to resources) and static user-created DHCP reservations.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PrivateNetwork("main", name="your_private_network")
        main_server = scaleway.instance.Server("main",
            image="ubuntu_jammy",
            type="DEV1-S",
            zone="fr-par-1",
            private_networks=[{
                "pn_id": main.id,
            }])
        main_public_gateway_ip = scaleway.network.PublicGatewayIp("main")
        main_public_gateway_dhcp = scaleway.network.PublicGatewayDhcp("main", subnet="192.168.1.0/24")
        main_public_gateway = scaleway.network.PublicGateway("main",
            name="foobar",
            type="VPC-GW-S",
            ip_id=main_public_gateway_ip.id)
        main_gateway_network = scaleway.network.GatewayNetwork("main",
            gateway_id=main_public_gateway.id,
            private_network_id=main.id,
            dhcp_id=main_public_gateway_dhcp.id,
            cleanup_dhcp=True,
            enable_masquerade=True,
            opts = pulumi.ResourceOptions(depends_on=[
                    main_public_gateway_ip,
                    main,
                ]))
        main_public_gateway_dhcp_reservation = scaleway.network.PublicGatewayDhcpReservation("main",
            gateway_network_id=main_gateway_network.id,
            mac_address=main_server.private_networks[0].mac_address,
            ip_address="192.168.1.1")
        ```

        ## Import

        Public Gateway DHCP reservation configurations can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/publicGatewayDhcpReservation:PublicGatewayDhcpReservation main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param PublicGatewayDhcpReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicGatewayDhcpReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicGatewayDhcpReservationArgs.__new__(PublicGatewayDhcpReservationArgs)

            if gateway_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_network_id'")
            __props__.__dict__["gateway_network_id"] = gateway_network_id
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            if mac_address is None and not opts.urn:
                raise TypeError("Missing required property 'mac_address'")
            __props__.__dict__["mac_address"] = mac_address
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/vpcPublicGatewayDhcpReservation:VpcPublicGatewayDhcpReservation")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(PublicGatewayDhcpReservation, __self__).__init__(
            'scaleway:network/publicGatewayDhcpReservation:PublicGatewayDhcpReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'PublicGatewayDhcpReservation':
        """
        Get an existing PublicGatewayDhcpReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] gateway_network_id: The ID of the owning GatewayNetwork.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the client machine.
        :param pulumi.Input[_builtins.str] ip_address: The IP address to give to the machine.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address for the static entry.
        :param pulumi.Input[_builtins.str] type: The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are `reservation` and `lease`.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the public gateway DHCP config should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicGatewayDhcpReservationState.__new__(_PublicGatewayDhcpReservationState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["gateway_network_id"] = gateway_network_id
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return PublicGatewayDhcpReservation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the owning GatewayNetwork.
        """
        return pulumi.get(self, "gateway_network_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the client machine.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address to give to the machine.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address for the static entry.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are `reservation` and `lease`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the public gateway DHCP config should be created.
        """
        return pulumi.get(self, "zone")

