# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketWebsiteConfigurationArgs', 'BucketWebsiteConfiguration']

@pulumi.input_type
class BucketWebsiteConfigurationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 index_document: pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs'],
                 error_document: Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketWebsiteConfiguration resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs'] index_document: The name of the index file for the website detailed below.
        :param pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs'] error_document: The name of the error file for the website detailed below.
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "index_document", index_document)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs']:
        """
        The name of the index file for the website detailed below.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs']):
        pulumi.set(self, "index_document", value)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']]:
        """
        The name of the error file for the website detailed below.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']]):
        pulumi.set(self, "error_document", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BucketWebsiteConfigurationState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']] = None,
                 index_document: Optional[pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketWebsiteConfiguration resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs'] error_document: The name of the error file for the website detailed below.
        :param pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs'] index_document: The name of the index file for the website detailed below.
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint. This is used to create DNS alias [records](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']]:
        """
        The name of the error file for the website detailed below.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input['BucketWebsiteConfigurationErrorDocumentArgs']]):
        pulumi.set(self, "error_document", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs']]:
        """
        The name of the index file for the website detailed below.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input['BucketWebsiteConfigurationIndexDocumentArgs']]):
        pulumi.set(self, "index_document", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of the website endpoint. This is used to create DNS alias [records](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_domain", value)

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website endpoint.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_endpoint", value)


@pulumi.type_token("scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration")
class BucketWebsiteConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationErrorDocumentArgs', 'BucketWebsiteConfigurationErrorDocumentArgsDict']]] = None,
                 index_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationIndexDocumentArgs', 'BucketWebsiteConfigurationIndexDocumentArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `object.BucketWebsiteConfiguration` resource allows you to deploy and manage a bucket website with [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/use-bucket-website/) for more information on bucket websites.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.object.Bucket("test",
            name="my-bucket",
            acl="public-read")
        some_file = scaleway.object.Item("some_file",
            bucket=test.name,
            key="index.html",
            file="index.html",
            visibility="public-read",
            content_type="text/html")
        test_bucket_website_configuration = scaleway.object.BucketWebsiteConfiguration("test",
            bucket=test.name,
            index_document={
                "suffix": "index.html",
            },
            error_document={
                "key": "error.html",
            })
        ```

        ### With A Bucket Policy

        ```python
        import pulumi
        import json
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="MyBucket",
            acl="public-read")
        main_bucket_policy = scaleway.object.BucketPolicy("main",
            bucket=main.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Id": "MyPolicy",
                "Statement": [{
                    "Sid": "GrantToEveryone",
                    "Effect": "Allow",
                    "Principal": "*",
                    "Action": ["s3:GetObject"],
                    "Resource": ["<bucket-name>/*"],
                }],
            }))
        main_bucket_website_configuration = scaleway.object.BucketWebsiteConfiguration("main",
            bucket=main.id,
            index_document={
                "suffix": "index.html",
            })
        ```

        ## Import

        Bucket website configurations can be imported using the `{region}/{bucketName}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration some_bucket fr-par/some-bucket
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration some_bucket fr-par/some-bucket@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[Union['BucketWebsiteConfigurationErrorDocumentArgs', 'BucketWebsiteConfigurationErrorDocumentArgsDict']] error_document: The name of the error file for the website detailed below.
        :param pulumi.Input[Union['BucketWebsiteConfigurationIndexDocumentArgs', 'BucketWebsiteConfigurationIndexDocumentArgsDict']] index_document: The name of the index file for the website detailed below.
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketWebsiteConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `object.BucketWebsiteConfiguration` resource allows you to deploy and manage a bucket website with [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/use-bucket-website/) for more information on bucket websites.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.object.Bucket("test",
            name="my-bucket",
            acl="public-read")
        some_file = scaleway.object.Item("some_file",
            bucket=test.name,
            key="index.html",
            file="index.html",
            visibility="public-read",
            content_type="text/html")
        test_bucket_website_configuration = scaleway.object.BucketWebsiteConfiguration("test",
            bucket=test.name,
            index_document={
                "suffix": "index.html",
            },
            error_document={
                "key": "error.html",
            })
        ```

        ### With A Bucket Policy

        ```python
        import pulumi
        import json
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="MyBucket",
            acl="public-read")
        main_bucket_policy = scaleway.object.BucketPolicy("main",
            bucket=main.id,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Id": "MyPolicy",
                "Statement": [{
                    "Sid": "GrantToEveryone",
                    "Effect": "Allow",
                    "Principal": "*",
                    "Action": ["s3:GetObject"],
                    "Resource": ["<bucket-name>/*"],
                }],
            }))
        main_bucket_website_configuration = scaleway.object.BucketWebsiteConfiguration("main",
            bucket=main.id,
            index_document={
                "suffix": "index.html",
            })
        ```

        ## Import

        Bucket website configurations can be imported using the `{region}/{bucketName}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration some_bucket fr-par/some-bucket
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration some_bucket fr-par/some-bucket@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param BucketWebsiteConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketWebsiteConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 error_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationErrorDocumentArgs', 'BucketWebsiteConfigurationErrorDocumentArgsDict']]] = None,
                 index_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationIndexDocumentArgs', 'BucketWebsiteConfigurationIndexDocumentArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketWebsiteConfigurationArgs.__new__(BucketWebsiteConfigurationArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["error_document"] = error_document
            if index_document is None and not opts.urn:
                raise TypeError("Missing required property 'index_document'")
            __props__.__dict__["index_document"] = index_document
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["website_domain"] = None
            __props__.__dict__["website_endpoint"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/objectBucketWebsiteConfiguration:ObjectBucketWebsiteConfiguration")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketWebsiteConfiguration, __self__).__init__(
            'scaleway:object/bucketWebsiteConfiguration:BucketWebsiteConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            error_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationErrorDocumentArgs', 'BucketWebsiteConfigurationErrorDocumentArgsDict']]] = None,
            index_document: Optional[pulumi.Input[Union['BucketWebsiteConfigurationIndexDocumentArgs', 'BucketWebsiteConfigurationIndexDocumentArgsDict']]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            website_domain: Optional[pulumi.Input[_builtins.str]] = None,
            website_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketWebsiteConfiguration':
        """
        Get an existing BucketWebsiteConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket.
        :param pulumi.Input[Union['BucketWebsiteConfigurationErrorDocumentArgs', 'BucketWebsiteConfigurationErrorDocumentArgsDict']] error_document: The name of the error file for the website detailed below.
        :param pulumi.Input[Union['BucketWebsiteConfigurationIndexDocumentArgs', 'BucketWebsiteConfigurationIndexDocumentArgsDict']] index_document: The name of the index file for the website detailed below.
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] website_domain: The domain of the website endpoint. This is used to create DNS alias [records](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).
        :param pulumi.Input[_builtins.str] website_endpoint: The website endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketWebsiteConfigurationState.__new__(_BucketWebsiteConfigurationState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["error_document"] = error_document
        __props__.__dict__["index_document"] = index_document
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["website_domain"] = website_domain
        __props__.__dict__["website_endpoint"] = website_endpoint
        return BucketWebsiteConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> pulumi.Output[Optional['outputs.BucketWebsiteConfigurationErrorDocument']]:
        """
        The name of the error file for the website detailed below.
        """
        return pulumi.get(self, "error_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> pulumi.Output['outputs.BucketWebsiteConfigurationIndexDocument']:
        """
        The name of the index file for the website detailed below.
        """
        return pulumi.get(self, "index_document")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain of the website endpoint. This is used to create DNS alias [records](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).
        """
        return pulumi.get(self, "website_domain")

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The website endpoint.
        """
        return pulumi.get(self, "website_endpoint")

