# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBucketPolicyResult',
    'AwaitableGetBucketPolicyResult',
    'get_bucket_policy',
    'get_bucket_policy_output',
]

@pulumi.output_type
class GetBucketPolicyResult:
    """
    A collection of values returned by getBucketPolicy.
    """
    def __init__(__self__, bucket=None, id=None, policy=None, project_id=None, region=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The content of the bucket policy in JSON format.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetBucketPolicyResult(GetBucketPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketPolicyResult(
            bucket=self.bucket,
            id=self.id,
            policy=self.policy,
            project_id=self.project_id,
            region=self.region)


def get_bucket_policy(bucket: Optional[_builtins.str] = None,
                      project_id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketPolicyResult:
    """
    The `object.BucketPolicy` data source is used to retrieve information about the bucket policy of an Object Storage bucket.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/bucket-policy/) for more information.

    ## Retrieve the bucket policy of a bucket

    The following command allows you to retrieve a bucket policy by its bucket.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.object.get_bucket_policy(bucket="bucket.test.com")
    ```


    :param _builtins.str bucket: The name of the bucket.
    :param _builtins.str region: `region`) The region in which the Object Storage exists.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:object/getBucketPolicy:getBucketPolicy', __args__, opts=opts, typ=GetBucketPolicyResult).value

    return AwaitableGetBucketPolicyResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        id=pulumi.get(__ret__, 'id'),
        policy=pulumi.get(__ret__, 'policy'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'))
def get_bucket_policy_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
                             project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketPolicyResult]:
    """
    The `object.BucketPolicy` data source is used to retrieve information about the bucket policy of an Object Storage bucket.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/bucket-policy/) for more information.

    ## Retrieve the bucket policy of a bucket

    The following command allows you to retrieve a bucket policy by its bucket.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.object.get_bucket_policy(bucket="bucket.test.com")
    ```


    :param _builtins.str bucket: The name of the bucket.
    :param _builtins.str region: `region`) The region in which the Object Storage exists.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:object/getBucketPolicy:getBucketPolicy', __args__, opts=opts, typ=GetBucketPolicyResult)
    return __ret__.apply(lambda __response__: GetBucketPolicyResult(
        bucket=pulumi.get(__response__, 'bucket'),
        id=pulumi.get(__response__, 'id'),
        policy=pulumi.get(__response__, 'policy'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region')))
