# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BucketAclAccessControlPolicy',
    'BucketAclAccessControlPolicyGrant',
    'BucketAclAccessControlPolicyGrantGrantee',
    'BucketAclAccessControlPolicyOwner',
    'BucketCorsRule',
    'BucketLifecycleRule',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleTransition',
    'BucketLockConfigurationRule',
    'BucketLockConfigurationRuleDefaultRetention',
    'BucketVersioning',
    'BucketWebsiteConfigurationErrorDocument',
    'BucketWebsiteConfigurationIndexDocument',
    'GetBucketCorsRuleResult',
    'GetBucketLifecycleRuleResult',
    'GetBucketLifecycleRuleExpirationResult',
    'GetBucketLifecycleRuleTransitionResult',
    'GetBucketVersioningResult',
]

@pulumi.output_type
class BucketAclAccessControlPolicy(dict):
    def __init__(__self__, *,
                 owner: 'outputs.BucketAclAccessControlPolicyOwner',
                 grants: Optional[Sequence['outputs.BucketAclAccessControlPolicyGrant']] = None):
        """
        :param 'BucketAclAccessControlPolicyOwnerArgs' owner: Configuration block of the bucket project owner's display organization ID.
        :param Sequence['BucketAclAccessControlPolicyGrantArgs'] grants: Grant
        """
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> 'outputs.BucketAclAccessControlPolicyOwner':
        """
        Configuration block of the bucket project owner's display organization ID.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def grants(self) -> Optional[Sequence['outputs.BucketAclAccessControlPolicyGrant']]:
        """
        Grant
        """
        return pulumi.get(self, "grants")


@pulumi.output_type
class BucketAclAccessControlPolicyGrant(dict):
    def __init__(__self__, *,
                 permission: _builtins.str,
                 grantee: Optional['outputs.BucketAclAccessControlPolicyGrantGrantee'] = None):
        """
        :param _builtins.str permission: Logging permissions assigned to the grantee for the bucket.
        :param 'BucketAclAccessControlPolicyGrantGranteeArgs' grantee: Configuration block for the project being granted permissions.
        """
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Logging permissions assigned to the grantee for the bucket.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def grantee(self) -> Optional['outputs.BucketAclAccessControlPolicyGrantGrantee']:
        """
        Configuration block for the project being granted permissions.
        """
        return pulumi.get(self, "grantee")


@pulumi.output_type
class BucketAclAccessControlPolicyGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAclAccessControlPolicyGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Display name of the grantee to grant access to.
        :param _builtins.str id: The `region`, `bucket` and `acl` separated by (`/`).
        :param _builtins.str type: Type of grantee. Valid values: `CanonicalUser`, `Group`
        :param _builtins.str uri: The uri of the grantee if you are granting permissions to a predefined group.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name of the grantee to grant access to.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of grantee. Valid values: `CanonicalUser`, `Group`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        The uri of the grantee if you are granting permissions to a predefined group.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketAclAccessControlPolicyOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAclAccessControlPolicyOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The `region`, `bucket` and `acl` separated by (`/`).
        :param _builtins.str display_name: The project ID of the grantee.
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The project ID of the grantee.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 expose_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_methods: Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        :param Sequence[_builtins.str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[_builtins.str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[_builtins.str] expose_headers: Specifies header exposure in the response.
        :param _builtins.int max_age_seconds: Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies header exposure in the response.
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 abort_incomplete_multipart_upload_days: Optional[_builtins.int] = None,
                 expiration: Optional['outputs.BucketLifecycleRuleExpiration'] = None,
                 id: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param _builtins.bool enabled: The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        :param _builtins.int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
               
               > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        :param 'BucketLifecycleRuleExpirationArgs' expiration: Specifies a period in the object's expire
        :param _builtins.str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param _builtins.str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, _builtins.str] tags: Specifies object tags key and value.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Define when objects transition to another storage class
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.

        > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleRuleExpiration']:
        """
        Specifies a period in the object's expire
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Define when objects transition to another storage class
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: _builtins.str,
                 days: Optional[_builtins.int] = None):
        """
        :param _builtins.str storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
               
               
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               
               
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.


        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.


        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.BucketLockConfigurationRuleDefaultRetention'):
        """
        :param 'BucketLockConfigurationRuleDefaultRetentionArgs' default_retention: The default retention for the lock.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @_builtins.property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.BucketLockConfigurationRuleDefaultRetention':
        """
        The default retention for the lock.
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 days: Optional[_builtins.int] = None,
                 years: Optional[_builtins.int] = None):
        """
        :param _builtins.str mode: The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        :param _builtins.int days: The number of days you want to specify for the default retention period.
        :param _builtins.int years: The number of years you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        The number of days you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter
    def years(self) -> Optional[_builtins.int]:
        """
        The number of years you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketWebsiteConfigurationErrorDocument(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: The object key name to use when a 4XX class error occurs.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The object key name to use when a 4XX class error occurs.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class BucketWebsiteConfigurationIndexDocument(dict):
    def __init__(__self__, *,
                 suffix: _builtins.str):
        """
        :param _builtins.str suffix: A suffix that is appended to a request targeting a specific directory on the website endpoint.
               
               > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        pulumi.set(__self__, "suffix", suffix)

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        A suffix that is appended to a request targeting a specific directory on the website endpoint.

        > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class GetBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 expose_headers: Sequence[_builtins.str],
                 max_age_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: Allowed headers in the CORS rule
        :param Sequence[_builtins.str] allowed_methods: Allowed HTTP methods allowed in the CORS rule
        :param Sequence[_builtins.str] allowed_origins: Allowed origins allowed in the CORS rule
        :param Sequence[_builtins.str] expose_headers: Exposed headers in the CORS rule
        :param _builtins.int max_age_seconds: Max age of the CORS rule
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        Allowed headers in the CORS rule
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Allowed HTTP methods allowed in the CORS rule
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Allowed origins allowed in the CORS rule
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[_builtins.str]:
        """
        Exposed headers in the CORS rule
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> _builtins.int:
        """
        Max age of the CORS rule
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 abort_incomplete_multipart_upload_days: _builtins.int,
                 enabled: _builtins.bool,
                 expirations: Sequence['outputs.GetBucketLifecycleRuleExpirationResult'],
                 id: _builtins.str,
                 prefix: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 transitions: Sequence['outputs.GetBucketLifecycleRuleTransitionResult']):
        """
        :param _builtins.int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed
        :param _builtins.bool enabled: Specifies if the configuration rule is Enabled or Disabled
        :param Sequence['GetBucketLifecycleRuleExpirationArgs'] expirations: Specifies a period in the object's expire
        :param _builtins.str id: The unique identifier of the bucket.
        :param _builtins.str prefix: The prefix identifying one or more objects to which the rule applies
        :param Mapping[str, _builtins.str] tags: The tags associated with the bucket lifecycle
        :param Sequence['GetBucketLifecycleRuleTransitionArgs'] transitions: Define when objects transition to another storage class
        """
        pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expirations", expirations)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> _builtins.int:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies if the configuration rule is Enabled or Disabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expirations(self) -> Sequence['outputs.GetBucketLifecycleRuleExpirationResult']:
        """
        Specifies a period in the object's expire
        """
        return pulumi.get(self, "expirations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the bucket.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The prefix identifying one or more objects to which the rule applies
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags associated with the bucket lifecycle
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Sequence['outputs.GetBucketLifecycleRuleTransitionResult']:
        """
        Define when objects transition to another storage class
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class GetBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class GetBucketLifecycleRuleTransitionResult(dict):
    def __init__(__self__, *,
                 days: _builtins.int,
                 storage_class: _builtins.str):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect
        :param _builtins.str storage_class: Specifies the Scaleway Object Storage class to which you want the object to transition
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Specifies the Scaleway Object Storage class to which you want the object to transition
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state
        """
        return pulumi.get(self, "enabled")


