# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectBucketArgs', 'ObjectBucket']

@pulumi.input_type
class ObjectBucketArgs:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['ObjectBucketVersioningArgs']] = None):
        """
        The set of arguments for constructing a ObjectBucket resource.
        :param pulumi.Input[_builtins.str] acl: (Deprecated) The canned ACL you want to apply to the bucket.
               
               > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]] cors_rules: List of CORS rules
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]] lifecycle_rules: Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Enable object lock
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the bucket is associated with.
        :param pulumi.Input[_builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags (key/value) for the bucket.
               
               * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
               If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        :param pulumi.Input['ObjectBucketVersioningArgs'] versioning: Allow multiple versions of an object in the same bucket
        """
        if acl is not None:
            warnings.warn("""ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The canned ACL you want to apply to the bucket.

        > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]]:
        """
        List of CORS rules
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]]:
        """
        Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable object lock
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_lock_enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the bucket is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of tags (key/value) for the bucket.

        * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
        If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['ObjectBucketVersioningArgs']]:
        """
        Allow multiple versions of an object in the same bucket
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['ObjectBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)


@pulumi.input_type
class _ObjectBucketState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['ObjectBucketVersioningArgs']] = None):
        """
        Input properties used for looking up and filtering ObjectBucket resources.
        :param pulumi.Input[_builtins.str] acl: (Deprecated) The canned ACL you want to apply to the bucket.
               
               > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        :param pulumi.Input[_builtins.str] api_endpoint: API URL of the bucket
        :param pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]] cors_rules: List of CORS rules
        :param pulumi.Input[_builtins.str] endpoint: The endpoint URL of the bucket.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]] lifecycle_rules: Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Enable object lock
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the bucket is associated with.
        :param pulumi.Input[_builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags (key/value) for the bucket.
               
               * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
               If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        :param pulumi.Input['ObjectBucketVersioningArgs'] versioning: Allow multiple versions of an object in the same bucket
        """
        if acl is not None:
            warnings.warn("""ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if api_endpoint is not None:
            pulumi.set(__self__, "api_endpoint", api_endpoint)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The canned ACL you want to apply to the bucket.

        > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API URL of the bucket
        """
        return pulumi.get(self, "api_endpoint")

    @api_endpoint.setter
    def api_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]]:
        """
        List of CORS rules
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint URL of the bucket.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]]:
        """
        Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable object lock
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_lock_enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the bucket is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of tags (key/value) for the bucket.

        * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
        If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['ObjectBucketVersioningArgs']]:
        """
        Allow multiple versions of an object in the same bucket
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['ObjectBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)


warnings.warn("""scaleway.index/objectbucket.ObjectBucket has been deprecated in favor of scaleway.object/bucket.Bucket""", DeprecationWarning)


@pulumi.type_token("scaleway:index/objectBucket:ObjectBucket")
class ObjectBucket(pulumi.CustomResource):
    warnings.warn("""scaleway.index/objectbucket.ObjectBucket has been deprecated in favor of scaleway.object/bucket.Bucket""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketCorsRuleArgs', 'ObjectBucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketLifecycleRuleArgs', 'ObjectBucketLifecycleRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['ObjectBucketVersioningArgs', 'ObjectBucketVersioningArgsDict']]] = None,
                 __props__=None):
        """
        The `object.Bucket` resource allows you to create and manage buckets for [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information on Object Storage buckets.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket",
            name="some-unique-name",
            tags={
                "key": "value",
            })
        ```

        ### Creating the bucket in a specific project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket",
            name="some-unique-name",
            project_id="11111111-1111-1111-1111-111111111111")
        ```

        ### Using object lifecycle

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="mybuckectid",
            region="fr-par",
            lifecycle_rules=[
                {
                    "id": "id1",
                    "prefix": "path1/",
                    "enabled": True,
                    "expiration": {
                        "days": 365,
                    },
                    "transitions": [{
                        "days": 120,
                        "storage_class": "GLACIER",
                    }],
                },
                {
                    "id": "id2",
                    "prefix": "path2/",
                    "enabled": True,
                    "expiration": {
                        "days": 50,
                    },
                },
                {
                    "id": "id3",
                    "prefix": "path3/",
                    "enabled": False,
                    "tags": {
                        "tagKey": "tagValue",
                        "terraform": "hashicorp",
                    },
                    "expiration": {
                        "days": 1,
                    },
                },
                {
                    "id": "id4",
                    "enabled": True,
                    "tags": {
                        "tag1": "value1",
                    },
                    "transitions": [{
                        "days": 1,
                        "storage_class": "GLACIER",
                    }],
                },
                {
                    "enabled": True,
                    "abort_incomplete_multipart_upload_days": 30,
                },
            ])
        ```

        ## Import

        Buckets can be imported using the `{region}/{bucketName}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/objectBucket:ObjectBucket some_bucket fr-par/some-bucket
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:index/objectBucket:ObjectBucket some_bucket fr-par/some-bucket@11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: (Deprecated) The canned ACL you want to apply to the bucket.
               
               > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketCorsRuleArgs', 'ObjectBucketCorsRuleArgsDict']]]] cors_rules: List of CORS rules
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketLifecycleRuleArgs', 'ObjectBucketLifecycleRuleArgsDict']]]] lifecycle_rules: Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Enable object lock
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the bucket is associated with.
        :param pulumi.Input[_builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags (key/value) for the bucket.
               
               * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
               If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        :param pulumi.Input[Union['ObjectBucketVersioningArgs', 'ObjectBucketVersioningArgsDict']] versioning: Allow multiple versions of an object in the same bucket
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ObjectBucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `object.Bucket` resource allows you to create and manage buckets for [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information on Object Storage buckets.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket",
            name="some-unique-name",
            tags={
                "key": "value",
            })
        ```

        ### Creating the bucket in a specific project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket",
            name="some-unique-name",
            project_id="11111111-1111-1111-1111-111111111111")
        ```

        ### Using object lifecycle

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="mybuckectid",
            region="fr-par",
            lifecycle_rules=[
                {
                    "id": "id1",
                    "prefix": "path1/",
                    "enabled": True,
                    "expiration": {
                        "days": 365,
                    },
                    "transitions": [{
                        "days": 120,
                        "storage_class": "GLACIER",
                    }],
                },
                {
                    "id": "id2",
                    "prefix": "path2/",
                    "enabled": True,
                    "expiration": {
                        "days": 50,
                    },
                },
                {
                    "id": "id3",
                    "prefix": "path3/",
                    "enabled": False,
                    "tags": {
                        "tagKey": "tagValue",
                        "terraform": "hashicorp",
                    },
                    "expiration": {
                        "days": 1,
                    },
                },
                {
                    "id": "id4",
                    "enabled": True,
                    "tags": {
                        "tag1": "value1",
                    },
                    "transitions": [{
                        "days": 1,
                        "storage_class": "GLACIER",
                    }],
                },
                {
                    "enabled": True,
                    "abort_incomplete_multipart_upload_days": 30,
                },
            ])
        ```

        ## Import

        Buckets can be imported using the `{region}/{bucketName}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/objectBucket:ObjectBucket some_bucket fr-par/some-bucket
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:index/objectBucket:ObjectBucket some_bucket fr-par/some-bucket@11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ObjectBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketCorsRuleArgs', 'ObjectBucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketLifecycleRuleArgs', 'ObjectBucketLifecycleRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['ObjectBucketVersioningArgs', 'ObjectBucketVersioningArgsDict']]] = None,
                 __props__=None):
        pulumi.log.warn("""ObjectBucket is deprecated: scaleway.index/objectbucket.ObjectBucket has been deprecated in favor of scaleway.object/bucket.Bucket""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectBucketArgs.__new__(ObjectBucketArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["name"] = name
            __props__.__dict__["object_lock_enabled"] = object_lock_enabled
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["api_endpoint"] = None
            __props__.__dict__["endpoint"] = None
        super(ObjectBucket, __self__).__init__(
            'scaleway:index/objectBucket:ObjectBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketCorsRuleArgs', 'ObjectBucketCorsRuleArgsDict']]]]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketLifecycleRuleArgs', 'ObjectBucketLifecycleRuleArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            versioning: Optional[pulumi.Input[Union['ObjectBucketVersioningArgs', 'ObjectBucketVersioningArgsDict']]] = None) -> 'ObjectBucket':
        """
        Get an existing ObjectBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: (Deprecated) The canned ACL you want to apply to the bucket.
               
               > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        :param pulumi.Input[_builtins.str] api_endpoint: API URL of the bucket
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketCorsRuleArgs', 'ObjectBucketCorsRuleArgsDict']]]] cors_rules: List of CORS rules
        :param pulumi.Input[_builtins.str] endpoint: The endpoint URL of the bucket.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectBucketLifecycleRuleArgs', 'ObjectBucketLifecycleRuleArgsDict']]]] lifecycle_rules: Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Enable object lock
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the bucket is associated with.
        :param pulumi.Input[_builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A list of tags (key/value) for the bucket.
               
               * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
               If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        :param pulumi.Input[Union['ObjectBucketVersioningArgs', 'ObjectBucketVersioningArgsDict']] versioning: Allow multiple versions of an object in the same bucket
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectBucketState.__new__(_ObjectBucketState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["api_endpoint"] = api_endpoint
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["object_lock_enabled"] = object_lock_enabled
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["versioning"] = versioning
        return ObjectBucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""ACL attribute is deprecated. Please use the resource object.BucketAcl instead.""")
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Deprecated) The canned ACL you want to apply to the bucket.

        > **Note:** The `acl` attribute is deprecated. See object.BucketAcl resource documentation. Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        API URL of the bucket
        """
        return pulumi.get(self, "api_endpoint")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> pulumi.Output[Sequence['outputs.ObjectBucketCorsRule']]:
        """
        List of CORS rules
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint URL of the bucket.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that, when set to true, allows the deletion of all objects (including locked objects) when the bucket is destroyed. This operation is irreversible, and the objects cannot be recovered. The default is false.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ObjectBucketLifecycleRule']]]:
        """
        Lifecycle configuration is a set of rules that define actions that Scaleway Object Storage applies to a group of objects
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable object lock
        """
        return pulumi.get(self, "object_lock_enabled")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the bucket is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#region-definition) in which the bucket will be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A list of tags (key/value) for the bucket.

        * > **Important:** The Scaleway console does not support `key/value` tags yet, so only the tags' values will be displayed.
        If you make any change to your bucket's tags using the console, it will overwrite them with the format `value/value`.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> pulumi.Output['outputs.ObjectBucketVersioning']:
        """
        Allow multiple versions of an object in the same bucket
        """
        return pulumi.get(self, "versioning")

