# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGrafanaResult',
    'AwaitableGetGrafanaResult',
    'get_grafana',
    'get_grafana_output',
]

@pulumi.output_type
class GetGrafanaResult:
    """
    A collection of values returned by getGrafana.
    """
    def __init__(__self__, grafana_url=None, id=None, project_id=None):
        if grafana_url and not isinstance(grafana_url, str):
            raise TypeError("Expected argument 'grafana_url' to be a str")
        pulumi.set(__self__, "grafana_url", grafana_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> _builtins.str:
        """
        The URL to access the Grafana dashboard. Use your Scaleway IAM credentials to authenticate.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")


class AwaitableGetGrafanaResult(GetGrafanaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGrafanaResult(
            grafana_url=self.grafana_url,
            id=self.id,
            project_id=self.project_id)


def get_grafana(project_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGrafanaResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str project_id: The ID of the project the Grafana instance is associated with. If not provided, the default project configured in the provider is used.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:observability/getGrafana:getGrafana', __args__, opts=opts, typ=GetGrafanaResult).value

    return AwaitableGetGrafanaResult(
        grafana_url=pulumi.get(__ret__, 'grafana_url'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_grafana_output(project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGrafanaResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str project_id: The ID of the project the Grafana instance is associated with. If not provided, the default project configured in the provider is used.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:observability/getGrafana:getGrafana', __args__, opts=opts, typ=GetGrafanaResult)
    return __ret__.apply(lambda __response__: GetGrafanaResult(
        grafana_url=pulumi.get(__response__, 'grafana_url'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id')))
