# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_key: The Scaleway access key.
        :param pulumi.Input[_builtins.str] api_url: The Scaleway API URL to use.
        :param pulumi.Input[_builtins.str] organization_id: The Scaleway organization ID.
        :param pulumi.Input[_builtins.str] profile: The Scaleway profile to use.
        :param pulumi.Input[_builtins.str] project_id: The Scaleway project ID.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] secret_key: The Scaleway secret Key.
        :param pulumi.Input[_builtins.str] zone: The zone you want to attach the resource to
        """
        if access_key is None:
            access_key = _utilities.get_env('SCW_ACCESS_KEY')
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if organization_id is None:
            organization_id = _utilities.get_env('SCW_ORGANIZATION_ID')
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if project_id is None:
            project_id = _utilities.get_env('SCW_DEFAULT_PROJECT_ID')
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is None:
            region = _utilities.get_env('SCW_DEFAULT_REGION')
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is None:
            secret_key = _utilities.get_env('SCW_SECRET_KEY')
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if zone is None:
            zone = _utilities.get_env('SCW_DEFAULT_ZONE')
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway access key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway API URL to use.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway organization ID.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway profile to use.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway secret Key.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("pulumi:providers:scaleway")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the scaleway package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The Scaleway access key.
        :param pulumi.Input[_builtins.str] api_url: The Scaleway API URL to use.
        :param pulumi.Input[_builtins.str] organization_id: The Scaleway organization ID.
        :param pulumi.Input[_builtins.str] profile: The Scaleway profile to use.
        :param pulumi.Input[_builtins.str] project_id: The Scaleway project ID.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] secret_key: The Scaleway secret Key.
        :param pulumi.Input[_builtins.str] zone: The zone you want to attach the resource to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the scaleway package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if access_key is None:
                access_key = _utilities.get_env('SCW_ACCESS_KEY')
            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["api_url"] = api_url
            if organization_id is None:
                organization_id = _utilities.get_env('SCW_ORGANIZATION_ID')
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["profile"] = profile
            if project_id is None:
                project_id = _utilities.get_env('SCW_DEFAULT_PROJECT_ID')
            __props__.__dict__["project_id"] = project_id
            if region is None:
                region = _utilities.get_env('SCW_DEFAULT_REGION')
            __props__.__dict__["region"] = region
            if secret_key is None:
                secret_key = _utilities.get_env('SCW_SECRET_KEY')
            __props__.__dict__["secret_key"] = secret_key
            if zone is None:
                zone = _utilities.get_env('SCW_DEFAULT_ZONE')
            __props__.__dict__["zone"] = zone
        super(Provider, __self__).__init__(
            'scaleway',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway access key.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway API URL to use.
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway organization ID.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway profile to use.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway project ID.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway secret Key.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:scaleway/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

