# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpcPublicGatewayArgs', 'VpcPublicGateway']

@pulumi.input_type
class VpcPublicGatewayArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bastion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bastion_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_smtp: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 move_to_ipam: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_ssh_keys: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcPublicGateway resource.
        :param pulumi.Input[_builtins.str] type: The gateway type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        :param pulumi.Input[_builtins.bool] bastion_enabled: Enable SSH bastion on the gateway.
        :param pulumi.Input[_builtins.int] bastion_port: The port on which the SSH bastion will listen.
        :param pulumi.Input[_builtins.bool] enable_smtp: Enable SMTP on the gateway.
        :param pulumi.Input[_builtins.str] ip_id: Attach an existing flexible IP to the gateway.
        :param pulumi.Input[_builtins.bool] move_to_ipam: Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        :param pulumi.Input[_builtins.str] name: The name for the Public Gateway. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the public gateway is associated with.
        :param pulumi.Input[_builtins.str] refresh_ssh_keys: Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the Public Gateway.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway should be created.
        """
        pulumi.set(__self__, "type", type)
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)
        if bastion_enabled is not None:
            pulumi.set(__self__, "bastion_enabled", bastion_enabled)
        if bastion_port is not None:
            pulumi.set(__self__, "bastion_port", bastion_port)
        if enable_smtp is not None:
            pulumi.set(__self__, "enable_smtp", enable_smtp)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if move_to_ipam is not None:
            pulumi.set(__self__, "move_to_ipam", move_to_ipam)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh_ssh_keys is not None:
            pulumi.set(__self__, "refresh_ssh_keys", refresh_ssh_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The gateway type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="bastionEnabled")
    def bastion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSH bastion on the gateway.
        """
        return pulumi.get(self, "bastion_enabled")

    @bastion_enabled.setter
    def bastion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bastion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bastionPort")
    def bastion_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the SSH bastion will listen.
        """
        return pulumi.get(self, "bastion_port")

    @bastion_port.setter
    def bastion_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bastion_port", value)

    @_builtins.property
    @pulumi.getter(name="enableSmtp")
    def enable_smtp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMTP on the gateway.
        """
        return pulumi.get(self, "enable_smtp")

    @enable_smtp.setter
    def enable_smtp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_smtp", value)

    @_builtins.property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attach an existing flexible IP to the gateway.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @_builtins.property
    @pulumi.getter(name="moveToIpam")
    def move_to_ipam(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        """
        return pulumi.get(self, "move_to_ipam")

    @move_to_ipam.setter
    def move_to_ipam(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "move_to_ipam", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Public Gateway. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the public gateway is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="refreshSshKeys")
    def refresh_ssh_keys(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        """
        return pulumi.get(self, "refresh_ssh_keys")

    @refresh_ssh_keys.setter
    def refresh_ssh_keys(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_ssh_keys", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the Public Gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpcPublicGatewayState:
    def __init__(__self__, *,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bastion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bastion_port: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_smtp: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 move_to_ipam: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_ssh_keys: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcPublicGateway resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth available of the gateway
        :param pulumi.Input[_builtins.bool] bastion_enabled: Enable SSH bastion on the gateway.
        :param pulumi.Input[_builtins.int] bastion_port: The port on which the SSH bastion will listen.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway.
        :param pulumi.Input[_builtins.bool] enable_smtp: Enable SMTP on the gateway.
        :param pulumi.Input[_builtins.str] ip_id: Attach an existing flexible IP to the gateway.
        :param pulumi.Input[_builtins.bool] move_to_ipam: Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        :param pulumi.Input[_builtins.str] name: The name for the Public Gateway. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the Public Gateway is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the public gateway is associated with.
        :param pulumi.Input[_builtins.str] refresh_ssh_keys: Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        :param pulumi.Input[_builtins.str] status: The status of the public gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the Public Gateway.
        :param pulumi.Input[_builtins.str] type: The gateway type.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] upstream_dns_servers: Override the gateway's default recursive DNS servers, if DNS features are enabled.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway should be created.
        """
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bastion_enabled is not None:
            pulumi.set(__self__, "bastion_enabled", bastion_enabled)
        if bastion_port is not None:
            pulumi.set(__self__, "bastion_port", bastion_port)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enable_smtp is not None:
            pulumi.set(__self__, "enable_smtp", enable_smtp)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if move_to_ipam is not None:
            pulumi.set(__self__, "move_to_ipam", move_to_ipam)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh_ssh_keys is not None:
            pulumi.set(__self__, "refresh_ssh_keys", refresh_ssh_keys)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upstream_dns_servers is not None:
            pulumi.set(__self__, "upstream_dns_servers", upstream_dns_servers)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_ranges", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth available of the gateway
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bastionEnabled")
    def bastion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SSH bastion on the gateway.
        """
        return pulumi.get(self, "bastion_enabled")

    @bastion_enabled.setter
    def bastion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bastion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bastionPort")
    def bastion_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which the SSH bastion will listen.
        """
        return pulumi.get(self, "bastion_port")

    @bastion_port.setter
    def bastion_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bastion_port", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the Public Gateway.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enableSmtp")
    def enable_smtp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMTP on the gateway.
        """
        return pulumi.get(self, "enable_smtp")

    @enable_smtp.setter
    def enable_smtp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_smtp", value)

    @_builtins.property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attach an existing flexible IP to the gateway.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @_builtins.property
    @pulumi.getter(name="moveToIpam")
    def move_to_ipam(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        """
        return pulumi.get(self, "move_to_ipam")

    @move_to_ipam.setter
    def move_to_ipam(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "move_to_ipam", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Public Gateway. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID the Public Gateway is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the public gateway is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="refreshSshKeys")
    def refresh_ssh_keys(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        """
        return pulumi.get(self, "refresh_ssh_keys")

    @refresh_ssh_keys.setter
    def refresh_ssh_keys(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_ssh_keys", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the public gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the Public Gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The gateway type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the Public Gateway.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="upstreamDnsServers")
    def upstream_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Override the gateway's default recursive DNS servers, if DNS features are enabled.
        """
        return pulumi.get(self, "upstream_dns_servers")

    @upstream_dns_servers.setter
    def upstream_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "upstream_dns_servers", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/vpcpublicgateway.VpcPublicGateway has been deprecated in favor of scaleway.network/publicgateway.PublicGateway""", DeprecationWarning)


@pulumi.type_token("scaleway:index/vpcPublicGateway:VpcPublicGateway")
class VpcPublicGateway(pulumi.CustomResource):
    warnings.warn("""scaleway.index/vpcpublicgateway.VpcPublicGateway has been deprecated in favor of scaleway.network/publicgateway.PublicGateway""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bastion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bastion_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_smtp: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 move_to_ipam: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_ssh_keys: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Public Gateways.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PublicGateway("main",
            name="public_gateway_demo",
            type="VPC-GW-S",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ## Import

        Public Gateways can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPublicGateway:VpcPublicGateway main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        :param pulumi.Input[_builtins.bool] bastion_enabled: Enable SSH bastion on the gateway.
        :param pulumi.Input[_builtins.int] bastion_port: The port on which the SSH bastion will listen.
        :param pulumi.Input[_builtins.bool] enable_smtp: Enable SMTP on the gateway.
        :param pulumi.Input[_builtins.str] ip_id: Attach an existing flexible IP to the gateway.
        :param pulumi.Input[_builtins.bool] move_to_ipam: Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        :param pulumi.Input[_builtins.str] name: The name for the Public Gateway. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the public gateway is associated with.
        :param pulumi.Input[_builtins.str] refresh_ssh_keys: Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the Public Gateway.
        :param pulumi.Input[_builtins.str] type: The gateway type.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPublicGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Public Gateways.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PublicGateway("main",
            name="public_gateway_demo",
            type="VPC-GW-S",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ## Import

        Public Gateways can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPublicGateway:VpcPublicGateway main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcPublicGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPublicGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bastion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bastion_port: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_smtp: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 move_to_ipam: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_ssh_keys: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""VpcPublicGateway is deprecated: scaleway.index/vpcpublicgateway.VpcPublicGateway has been deprecated in favor of scaleway.network/publicgateway.PublicGateway""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPublicGatewayArgs.__new__(VpcPublicGatewayArgs)

            __props__.__dict__["allowed_ip_ranges"] = allowed_ip_ranges
            __props__.__dict__["bastion_enabled"] = bastion_enabled
            __props__.__dict__["bastion_port"] = bastion_port
            __props__.__dict__["enable_smtp"] = enable_smtp
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["move_to_ipam"] = move_to_ipam
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["refresh_ssh_keys"] = refresh_ssh_keys
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["bandwidth"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["upstream_dns_servers"] = None
        super(VpcPublicGateway, __self__).__init__(
            'scaleway:index/vpcPublicGateway:VpcPublicGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            bastion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            bastion_port: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enable_smtp: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            move_to_ipam: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_ssh_keys: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            upstream_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcPublicGateway':
        """
        Get an existing VpcPublicGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth available of the gateway
        :param pulumi.Input[_builtins.bool] bastion_enabled: Enable SSH bastion on the gateway.
        :param pulumi.Input[_builtins.int] bastion_port: The port on which the SSH bastion will listen.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway.
        :param pulumi.Input[_builtins.bool] enable_smtp: Enable SMTP on the gateway.
        :param pulumi.Input[_builtins.str] ip_id: Attach an existing flexible IP to the gateway.
        :param pulumi.Input[_builtins.bool] move_to_ipam: Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        :param pulumi.Input[_builtins.str] name: The name for the Public Gateway. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the Public Gateway is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the public gateway is associated with.
        :param pulumi.Input[_builtins.str] refresh_ssh_keys: Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        :param pulumi.Input[_builtins.str] status: The status of the public gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the Public Gateway.
        :param pulumi.Input[_builtins.str] type: The gateway type.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] upstream_dns_servers: Override the gateway's default recursive DNS servers, if DNS features are enabled.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPublicGatewayState.__new__(_VpcPublicGatewayState)

        __props__.__dict__["allowed_ip_ranges"] = allowed_ip_ranges
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bastion_enabled"] = bastion_enabled
        __props__.__dict__["bastion_port"] = bastion_port
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enable_smtp"] = enable_smtp
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["move_to_ipam"] = move_to_ipam
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["refresh_ssh_keys"] = refresh_ssh_keys
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upstream_dns_servers"] = upstream_dns_servers
        __props__.__dict__["zone"] = zone
        return VpcPublicGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Set a definitive list of IP ranges (in CIDR notation) allowed to connect to the SSH bastion.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth available of the gateway
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bastionEnabled")
    def bastion_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable SSH bastion on the gateway.
        """
        return pulumi.get(self, "bastion_enabled")

    @_builtins.property
    @pulumi.getter(name="bastionPort")
    def bastion_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port on which the SSH bastion will listen.
        """
        return pulumi.get(self, "bastion_port")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the Public Gateway.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enableSmtp")
    def enable_smtp(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable SMTP on the gateway.
        """
        return pulumi.get(self, "enable_smtp")

    @_builtins.property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        Attach an existing flexible IP to the gateway.
        """
        return pulumi.get(self, "ip_id")

    @_builtins.property
    @pulumi.getter(name="moveToIpam")
    def move_to_ipam(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Put a Public Gateway in IPAM mode, so that it can be used with the Public Gateways API v2
        """
        return pulumi.get(self, "move_to_ipam")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the Public Gateway. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Organization ID the Public Gateway is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the public gateway is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="refreshSshKeys")
    def refresh_ssh_keys(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Trigger a refresh of the SSH keys on the Public Gateway by changing this field's value.
        """
        return pulumi.get(self, "refresh_ssh_keys")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the public gateway.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags to associate with the Public Gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The gateway type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the Public Gateway.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="upstreamDnsServers")
    def upstream_dns_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Override the gateway's default recursive DNS servers, if DNS features are enabled.
        """
        return pulumi.get(self, "upstream_dns_servers")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway should be created.
        """
        return pulumi.get(self, "zone")

