# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpcPublicGatewayDhcpArgs', 'VpcPublicGatewayDhcp']

@pulumi.input_type
class VpcPublicGatewayDhcpArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[_builtins.str],
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_local_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
                 pool_high: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_low: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 push_default_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_dns_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 rebind_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcPublicGatewayDhcp resource.
        :param pulumi.Input[_builtins.str] subnet: The subnet to associate with the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] address: The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        :param pulumi.Input[_builtins.str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        :param pulumi.Input[_builtins.bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[_builtins.str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[_builtins.str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        :param pulumi.Input[_builtins.bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
               
               > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        :param pulumi.Input[_builtins.bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[_builtins.int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[_builtins.int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[_builtins.int] valid_lifetime: How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        pulumi.set(__self__, "subnet", subnet)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if dns_local_name is not None:
            pulumi.set(__self__, "dns_local_name", dns_local_name)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if dns_servers_overrides is not None:
            pulumi.set(__self__, "dns_servers_overrides", dns_servers_overrides)
        if enable_dynamic is not None:
            pulumi.set(__self__, "enable_dynamic", enable_dynamic)
        if pool_high is not None:
            pulumi.set(__self__, "pool_high", pool_high)
        if pool_low is not None:
            pulumi.set(__self__, "pool_low", pool_low)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)
        if push_dns_server is not None:
            pulumi.set(__self__, "push_dns_server", push_dns_server)
        if rebind_timer is not None:
            pulumi.set(__self__, "rebind_timer", rebind_timer)
        if renew_timer is not None:
            pulumi.set(__self__, "renew_timer", renew_timer)
        if valid_lifetime is not None:
            pulumi.set(__self__, "valid_lifetime", valid_lifetime)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet to associate with the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @dns_local_name.setter
    def dns_local_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_local_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_searches", value)

    @_builtins.property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        """
        return pulumi.get(self, "dns_servers_overrides")

    @dns_servers_overrides.setter
    def dns_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers_overrides", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @enable_dynamic.setter
    def enable_dynamic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic", value)

    @_builtins.property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @pool_high.setter
    def pool_high(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_high", value)

    @_builtins.property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @pool_low.setter
    def pool_low(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_low", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.

        > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        """
        return pulumi.get(self, "push_default_route")

    @push_default_route.setter
    def push_default_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_default_route", value)

    @_builtins.property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @push_dns_server.setter
    def push_dns_server(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_dns_server", value)

    @_builtins.property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @rebind_timer.setter
    def rebind_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rebind_timer", value)

    @_builtins.property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @renew_timer.setter
    def renew_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_timer", value)

    @_builtins.property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @valid_lifetime.setter
    def valid_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpcPublicGatewayDhcpState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_local_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_high: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_low: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 push_default_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_dns_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 rebind_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcPublicGatewayDhcp resources.
        :param pulumi.Input[_builtins.str] address: The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        :param pulumi.Input[_builtins.bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the Public Gateway DHCP config is associated with.
        :param pulumi.Input[_builtins.str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[_builtins.str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        :param pulumi.Input[_builtins.bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
               
               > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        :param pulumi.Input[_builtins.bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[_builtins.int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[_builtins.int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[_builtins.str] subnet: The subnet to associate with the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.int] valid_lifetime: How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dns_local_name is not None:
            pulumi.set(__self__, "dns_local_name", dns_local_name)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if dns_servers_overrides is not None:
            pulumi.set(__self__, "dns_servers_overrides", dns_servers_overrides)
        if enable_dynamic is not None:
            pulumi.set(__self__, "enable_dynamic", enable_dynamic)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if pool_high is not None:
            pulumi.set(__self__, "pool_high", pool_high)
        if pool_low is not None:
            pulumi.set(__self__, "pool_low", pool_low)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)
        if push_dns_server is not None:
            pulumi.set(__self__, "push_dns_server", push_dns_server)
        if rebind_timer is not None:
            pulumi.set(__self__, "rebind_timer", rebind_timer)
        if renew_timer is not None:
            pulumi.set(__self__, "renew_timer", renew_timer)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if valid_lifetime is not None:
            pulumi.set(__self__, "valid_lifetime", valid_lifetime)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @dns_local_name.setter
    def dns_local_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_local_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_searches", value)

    @_builtins.property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        """
        return pulumi.get(self, "dns_servers_overrides")

    @dns_servers_overrides.setter
    def dns_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers_overrides", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @enable_dynamic.setter
    def enable_dynamic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID the Public Gateway DHCP config is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @pool_high.setter
    def pool_high(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_high", value)

    @_builtins.property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @pool_low.setter
    def pool_low(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_low", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.

        > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        """
        return pulumi.get(self, "push_default_route")

    @push_default_route.setter
    def push_default_route(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_default_route", value)

    @_builtins.property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @push_dns_server.setter
    def push_dns_server(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "push_dns_server", value)

    @_builtins.property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @rebind_timer.setter
    def rebind_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rebind_timer", value)

    @_builtins.property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @renew_timer.setter
    def renew_timer(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_timer", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet to associate with the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @valid_lifetime.setter
    def valid_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/vpcpublicgatewaydhcp.VpcPublicGatewayDhcp has been deprecated in favor of scaleway.network/publicgatewaydhcp.PublicGatewayDhcp""", DeprecationWarning)


@pulumi.type_token("scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp")
class VpcPublicGatewayDhcp(pulumi.CustomResource):
    warnings.warn("""scaleway.index/vpcpublicgatewaydhcp.VpcPublicGatewayDhcp has been deprecated in favor of scaleway.network/publicgatewaydhcp.PublicGatewayDhcp""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_local_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
                 pool_high: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_low: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 push_default_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_dns_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 rebind_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Important:**  The resource `network.PublicGatewayDhcp` has been deprecated and will no longer be supported.
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP resources are now no longer needed.
        For more information, please refer to the dedicated guide.

        Creates and manages Scaleway VPC Public Gateway DHCP configurations.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-c05544).

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PublicGatewayDhcp("main", subnet="192.168.1.0/24")
        ```

        ## Import

        Public Gateway DHCP configuration can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        :param pulumi.Input[_builtins.str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        :param pulumi.Input[_builtins.bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[_builtins.str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[_builtins.str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        :param pulumi.Input[_builtins.bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
               
               > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        :param pulumi.Input[_builtins.bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[_builtins.int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[_builtins.int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[_builtins.str] subnet: The subnet to associate with the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.int] valid_lifetime: How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPublicGatewayDhcpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Important:**  The resource `network.PublicGatewayDhcp` has been deprecated and will no longer be supported.
        In 2023, DHCP functionality was moved from Public Gateways to Private Networks, DHCP resources are now no longer needed.
        For more information, please refer to the dedicated guide.

        Creates and manages Scaleway VPC Public Gateway DHCP configurations.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#dhcp-c05544).

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.PublicGatewayDhcp("main", subnet="192.168.1.0/24")
        ```

        ## Import

        Public Gateway DHCP configuration can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcPublicGatewayDhcpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPublicGatewayDhcpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_local_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
                 pool_high: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_low: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 push_default_route: Optional[pulumi.Input[_builtins.bool]] = None,
                 push_dns_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 rebind_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_timer: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""VpcPublicGatewayDhcp is deprecated: scaleway.index/vpcpublicgatewaydhcp.VpcPublicGatewayDhcp has been deprecated in favor of scaleway.network/publicgatewaydhcp.PublicGatewayDhcp""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPublicGatewayDhcpArgs.__new__(VpcPublicGatewayDhcpArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["dns_local_name"] = dns_local_name
            __props__.__dict__["dns_searches"] = dns_searches
            __props__.__dict__["dns_servers_overrides"] = dns_servers_overrides
            __props__.__dict__["enable_dynamic"] = enable_dynamic
            __props__.__dict__["pool_high"] = pool_high
            __props__.__dict__["pool_low"] = pool_low
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["push_default_route"] = push_default_route
            __props__.__dict__["push_dns_server"] = push_dns_server
            __props__.__dict__["rebind_timer"] = rebind_timer
            __props__.__dict__["renew_timer"] = renew_timer
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["valid_lifetime"] = valid_lifetime
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcPublicGatewayDhcp, __self__).__init__(
            'scaleway:index/vpcPublicGatewayDhcp:VpcPublicGatewayDhcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dns_local_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dns_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable_dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            pool_high: Optional[pulumi.Input[_builtins.str]] = None,
            pool_low: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            push_default_route: Optional[pulumi.Input[_builtins.bool]] = None,
            push_dns_server: Optional[pulumi.Input[_builtins.bool]] = None,
            rebind_timer: Optional[pulumi.Input[_builtins.int]] = None,
            renew_timer: Optional[pulumi.Input[_builtins.int]] = None,
            subnet: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcPublicGatewayDhcp':
        """
        Get an existing VpcPublicGatewayDhcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] dns_local_name: TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_searches: Additional DNS search paths
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers_overrides: Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        :param pulumi.Input[_builtins.bool] enable_dynamic: Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the Public Gateway DHCP config is associated with.
        :param pulumi.Input[_builtins.str] pool_high: High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        :param pulumi.Input[_builtins.str] pool_low: Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        :param pulumi.Input[_builtins.bool] push_default_route: Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.
               
               > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        :param pulumi.Input[_builtins.bool] push_dns_server: Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        :param pulumi.Input[_builtins.int] rebind_timer: After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        :param pulumi.Input[_builtins.int] renew_timer: After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        :param pulumi.Input[_builtins.str] subnet: The subnet to associate with the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Public Gateway DHCP configuration.
        :param pulumi.Input[_builtins.int] valid_lifetime: How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPublicGatewayDhcpState.__new__(_VpcPublicGatewayDhcpState)

        __props__.__dict__["address"] = address
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dns_local_name"] = dns_local_name
        __props__.__dict__["dns_searches"] = dns_searches
        __props__.__dict__["dns_servers_overrides"] = dns_servers_overrides
        __props__.__dict__["enable_dynamic"] = enable_dynamic
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["pool_high"] = pool_high
        __props__.__dict__["pool_low"] = pool_low
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["push_default_route"] = push_default_route
        __props__.__dict__["push_dns_server"] = push_dns_server
        __props__.__dict__["rebind_timer"] = rebind_timer
        __props__.__dict__["renew_timer"] = renew_timer
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["valid_lifetime"] = valid_lifetime
        __props__.__dict__["zone"] = zone
        return VpcPublicGatewayDhcp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the DHCP server. This will be the gateway's address in the Private Network.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dnsLocalName")
    def dns_local_name(self) -> pulumi.Output[_builtins.str]:
        """
        TLD given to hostnames in the Private Network. Allowed characters are `a-z0-9-.`. Defaults to the slugified Private Network name if created along a GatewayNetwork, or else to `priv`.
        """
        return pulumi.get(self, "dns_local_name")

    @_builtins.property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Additional DNS search paths
        """
        return pulumi.get(self, "dns_searches")

    @_builtins.property
    @pulumi.getter(name="dnsServersOverrides")
    def dns_servers_overrides(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Override the DNS server list pushed to DHCP clients, instead of the gateway itself.
        """
        return pulumi.get(self, "dns_servers_overrides")

    @_builtins.property
    @pulumi.getter(name="enableDynamic")
    def enable_dynamic(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable dynamic pooling of IPs. By turning the dynamic pool off, only pre-existing DHCP reservations will be handed out. Defaults to `true`.
        """
        return pulumi.get(self, "enable_dynamic")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Organization ID the Public Gateway DHCP config is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="poolHigh")
    def pool_high(self) -> pulumi.Output[_builtins.str]:
        """
        High IP (excluded) of the dynamic address pool. Defaults to the last address of the subnet.
        """
        return pulumi.get(self, "pool_high")

    @_builtins.property
    @pulumi.getter(name="poolLow")
    def pool_low(self) -> pulumi.Output[_builtins.str]:
        """
        Low IP (included) of the dynamic address pool. Defaults to the second address of the subnet.
        """
        return pulumi.get(self, "pool_low")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project the Public Gateway DHCP configuration is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the gateway should push a default route to DHCP clients or only hand out IPs. Defaults to `true`.

        > **Warning**: If you need to setup a default route, it's recommended to use the `network.GatewayNetwork` resource instead.
        """
        return pulumi.get(self, "push_default_route")

    @_builtins.property
    @pulumi.getter(name="pushDnsServer")
    def push_dns_server(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the gateway should push custom DNS servers to clients. This allows for instance hostname > IP resolution. Defaults to `true`.
        """
        return pulumi.get(self, "push_dns_server")

    @_builtins.property
    @pulumi.getter(name="rebindTimer")
    def rebind_timer(self) -> pulumi.Output[_builtins.int]:
        """
        After how long, in seconds, a DHCP client will query for a new lease if previous renews fail. Must be 30s lower than `valid_lifetime`. Defaults to 51m (3060s).
        """
        return pulumi.get(self, "rebind_timer")

    @_builtins.property
    @pulumi.getter(name="renewTimer")
    def renew_timer(self) -> pulumi.Output[_builtins.int]:
        """
        After how long, in seconds, a renewal will be attempted. Must be 30s lower than `rebind_timer`. Defaults to 50m (3000s).
        """
        return pulumi.get(self, "renew_timer")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet to associate with the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the Public Gateway DHCP configuration.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="validLifetime")
    def valid_lifetime(self) -> pulumi.Output[_builtins.int]:
        """
        How long, in seconds, DHCP entries will be valid. Defaults to 1h (3600s).
        """
        return pulumi.get(self, "valid_lifetime")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the Public Gateway DHCP configuration should be created.
        """
        return pulumi.get(self, "zone")

