# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpcRouteArgs', 'VpcRoute']

@pulumi.input_type
class VpcRouteArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VpcRoute resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the route belongs to.
        :param pulumi.Input[_builtins.str] description: The route description.
        :param pulumi.Input[_builtins.str] destination: The destination of the route.
        :param pulumi.Input[_builtins.str] nexthop_private_network_id: The ID of the nexthop private network.
        :param pulumi.Input[_builtins.str] nexthop_resource_id: The ID of the nexthop resource.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the route.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the route.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop_private_network_id is not None:
            pulumi.set(__self__, "nexthop_private_network_id", nexthop_private_network_id)
        if nexthop_resource_id is not None:
            pulumi.set(__self__, "nexthop_resource_id", nexthop_resource_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID the route belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination of the route.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="nexthopPrivateNetworkId")
    def nexthop_private_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the nexthop private network.
        """
        return pulumi.get(self, "nexthop_private_network_id")

    @nexthop_private_network_id.setter
    def nexthop_private_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="nexthopResourceId")
    def nexthop_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the nexthop resource.
        """
        return pulumi.get(self, "nexthop_resource_id")

    @nexthop_resource_id.setter
    def nexthop_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the route.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the route.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcRouteState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcRoute resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the route (RFC 3339 format).
        :param pulumi.Input[_builtins.str] description: The route description.
        :param pulumi.Input[_builtins.str] destination: The destination of the route.
        :param pulumi.Input[_builtins.str] nexthop_private_network_id: The ID of the nexthop private network.
        :param pulumi.Input[_builtins.str] nexthop_resource_id: The ID of the nexthop resource.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the route.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the route.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the creation of the route (RFC 3339 format).
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the route belongs to.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop_private_network_id is not None:
            pulumi.set(__self__, "nexthop_private_network_id", nexthop_private_network_id)
        if nexthop_resource_id is not None:
            pulumi.set(__self__, "nexthop_resource_id", nexthop_resource_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the route (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination of the route.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="nexthopPrivateNetworkId")
    def nexthop_private_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the nexthop private network.
        """
        return pulumi.get(self, "nexthop_private_network_id")

    @nexthop_private_network_id.setter
    def nexthop_private_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="nexthopResourceId")
    def nexthop_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the nexthop resource.
        """
        return pulumi.get(self, "nexthop_resource_id")

    @nexthop_resource_id.setter
    def nexthop_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the route.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the route.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the route (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID the route belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


warnings.warn("""scaleway.index/vpcroute.VpcRoute has been deprecated in favor of scaleway.network/route.Route""", DeprecationWarning)


@pulumi.type_token("scaleway:index/vpcRoute:VpcRoute")
class VpcRoute(pulumi.CustomResource):
    warnings.warn("""scaleway.index/vpcroute.VpcRoute has been deprecated in favor of scaleway.network/route.Route""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway VPC Routes.
        For more information, see [the main documentation](https://www.scaleway.com/en/docs/vpc/concepts/).

        ## Example Usage

        ### With Instance

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-vpn")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="tf-pn-vpn",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        server01 = scaleway.instance.Server("server01",
            name="tf-server-vpn",
            type="PLAY2-MICRO",
            image="openvpn")
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            private_network_id=pn01.id,
            server_id=server01.id)
        rt01 = scaleway.network.Route("rt01",
            vpc_id=vpc01.id,
            description="tf-route-vpn",
            tags=[
                "tf",
                "route",
            ],
            destination="10.0.0.0/24",
            nexthop_resource_id=pnic01.id)
        ```

        ### With Baremetal

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-vpn")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="tf-pn-vpn",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        my_os = scaleway.elasticmetal.get_os(zone="fr-par-2",
            name="Ubuntu",
            version="22.04 LTS (Jammy Jellyfish)")
        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        private_network = scaleway.elasticmetal.get_option(zone="fr-par-2",
            name="Private Network")
        my_key = scaleway.iam.get_ssh_key(name="main")
        my_server = scaleway.elasticmetal.Server("my_server",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            os=my_os.os_id,
            ssh_key_ids=[my_key.id],
            options=[{
                "id": private_network.option_id,
            }],
            private_networks=[{
                "id": pn01.id,
            }])
        rt01 = scaleway.network.Route("rt01",
            vpc_id=vpc01.id,
            description="tf-route-vpn",
            tags=[
                "tf",
                "route",
            ],
            destination="10.0.0.0/24",
            nexthop_resource_id=my_server.private_networks[0].mapping_id)
        ```

        ## Import

        Routes can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcRoute:VpcRoute main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The route description.
        :param pulumi.Input[_builtins.str] destination: The destination of the route.
        :param pulumi.Input[_builtins.str] nexthop_private_network_id: The ID of the nexthop private network.
        :param pulumi.Input[_builtins.str] nexthop_resource_id: The ID of the nexthop resource.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the route.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the route.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the route belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway VPC Routes.
        For more information, see [the main documentation](https://www.scaleway.com/en/docs/vpc/concepts/).

        ## Example Usage

        ### With Instance

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-vpn")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="tf-pn-vpn",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        server01 = scaleway.instance.Server("server01",
            name="tf-server-vpn",
            type="PLAY2-MICRO",
            image="openvpn")
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            private_network_id=pn01.id,
            server_id=server01.id)
        rt01 = scaleway.network.Route("rt01",
            vpc_id=vpc01.id,
            description="tf-route-vpn",
            tags=[
                "tf",
                "route",
            ],
            destination="10.0.0.0/24",
            nexthop_resource_id=pnic01.id)
        ```

        ### With Baremetal

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-vpn")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="tf-pn-vpn",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        my_os = scaleway.elasticmetal.get_os(zone="fr-par-2",
            name="Ubuntu",
            version="22.04 LTS (Jammy Jellyfish)")
        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        private_network = scaleway.elasticmetal.get_option(zone="fr-par-2",
            name="Private Network")
        my_key = scaleway.iam.get_ssh_key(name="main")
        my_server = scaleway.elasticmetal.Server("my_server",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            os=my_os.os_id,
            ssh_key_ids=[my_key.id],
            options=[{
                "id": private_network.option_id,
            }],
            private_networks=[{
                "id": pn01.id,
            }])
        rt01 = scaleway.network.Route("rt01",
            vpc_id=vpc01.id,
            description="tf-route-vpn",
            tags=[
                "tf",
                "route",
            ],
            destination="10.0.0.0/24",
            nexthop_resource_id=my_server.private_networks[0].mapping_id)
        ```

        ## Import

        Routes can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcRoute:VpcRoute main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""VpcRoute is deprecated: scaleway.index/vpcroute.VpcRoute has been deprecated in favor of scaleway.network/route.Route""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcRouteArgs.__new__(VpcRouteArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["destination"] = destination
            __props__.__dict__["nexthop_private_network_id"] = nexthop_private_network_id
            __props__.__dict__["nexthop_resource_id"] = nexthop_resource_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcRoute, __self__).__init__(
            'scaleway:index/vpcRoute:VpcRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            nexthop_private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            nexthop_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcRoute':
        """
        Get an existing VpcRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the route (RFC 3339 format).
        :param pulumi.Input[_builtins.str] description: The route description.
        :param pulumi.Input[_builtins.str] destination: The destination of the route.
        :param pulumi.Input[_builtins.str] nexthop_private_network_id: The ID of the nexthop private network.
        :param pulumi.Input[_builtins.str] nexthop_resource_id: The ID of the nexthop resource.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the route.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the route.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the creation of the route (RFC 3339 format).
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the route belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcRouteState.__new__(_VpcRouteState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["nexthop_private_network_id"] = nexthop_private_network_id
        __props__.__dict__["nexthop_resource_id"] = nexthop_resource_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the route (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The route description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="nexthopPrivateNetworkId")
    def nexthop_private_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the nexthop private network.
        """
        return pulumi.get(self, "nexthop_private_network_id")

    @_builtins.property
    @pulumi.getter(name="nexthopResourceId")
    def nexthop_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the nexthop resource.
        """
        return pulumi.get(self, "nexthop_resource_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the route.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags to associate with the route.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the route (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID the route belongs to.
        """
        return pulumi.get(self, "vpc_id")

