# Generated by Django 4.1.5 on 2023-02-23 12:23

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid
import zs_utils.json_utils


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="APIRequestLog",
            fields=[
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "id",
                    model_utils.fields.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False),
                ),
                ("url", models.TextField(verbose_name="URL запроса")),
                (
                    "method",
                    models.CharField(
                        choices=[
                            ("GET", "GET"),
                            ("POST", "POST"),
                            ("DELETE", "DELETE"),
                            ("PUT", "PUT"),
                            ("PATCH", "PATCH"),
                        ],
                        max_length=6,
                        verbose_name="Метод запроса",
                    ),
                ),
                (
                    "params",
                    models.JSONField(
                        blank=True,
                        encoder=zs_utils.json_utils.CustomJSONEncoder,
                        null=True,
                        verbose_name="Параметры URL",
                    ),
                ),
                (
                    "request_headers",
                    models.JSONField(
                        blank=True,
                        encoder=zs_utils.json_utils.CustomJSONEncoder,
                        null=True,
                        verbose_name="Хедеры запроса",
                    ),
                ),
                (
                    "request_body",
                    models.JSONField(
                        blank=True,
                        encoder=zs_utils.json_utils.CustomJSONEncoder,
                        null=True,
                        verbose_name="Тело запроса",
                    ),
                ),
                ("response_time", models.IntegerField(verbose_name="Время ответа (миллисекунда)")),
                ("status_code", models.IntegerField(verbose_name="Код ответа")),
                (
                    "response_headers",
                    models.JSONField(
                        blank=True,
                        encoder=zs_utils.json_utils.CustomJSONEncoder,
                        null=True,
                        verbose_name="Хедеры ответа",
                    ),
                ),
                (
                    "response_body",
                    models.JSONField(
                        blank=True, encoder=zs_utils.json_utils.CustomJSONEncoder, null=True, verbose_name="Тело ответа"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_request_logs",
                        related_query_name="api_request_log",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
            },
        ),
    ]
