from model_utils import Choices

from django.utils.translation import gettext_lazy as _


__all__ = [
    "OTHER_COUNTRIES",
    "MARKETPLACE_COUNTRIES",
    "COUNTRIES",
    "COUNTRY_CODE_TO_NAME",
    "COUNTRY_NAME_TO_CODE",
    "COUNTRIES_NAME",
    "COUNTRY_CODE_ALPHA_TO_NUM",
    "NUM_TO_COUNTRY_CODE_ALPHA",
]


OTHER_COUNTRIES = Choices(
    ("AD", _("Андорра")),
    ("AE", _("Объединённые Арабские Эмираты")),
    ("AF", _("Афганистан")),
    ("AG", _("Антигуа И Барбуда")),
    ("AI", _("Ангвилла")),
    ("AL", _("Албания")),
    ("AM", _("Армения")),
    ("AN", _("Нидерландские Антильские острова")),
    ("AO", _("Ангола")),
    ("AQ", _("Антарктика")),
    ("AR", _("Аргентина")),
    ("AS", _("Американские Самоа")),
    ("AW", _("Аруба")),
    ("AX", _("Аландские Острова")),
    ("AZ", _("Азербайджан")),
    ("BA", _("Босния И Герцеговина")),
    ("BB", _("Барбадос")),
    ("BD", _("Бангладеш")),
    ("BE", _("Бельгия")),
    ("BF", _("Буркина-Фасо")),
    ("BG", _("Болгария")),
    ("BH", _("Бахрейн")),
    ("BI", _("Бурунди")),
    ("BJ", _("Бенин")),
    ("BL", _("Сен-Бартельми")),
    ("BM", _("Бермуды")),
    ("BN", _("Бруней Даруссалам")),
    ("BO", _("Боливия")),
    ("BQ", _("Бонайре, Синт-Эстатиус И Саба")),
    ("BR", _("Бразилия")),
    ("BS", _("Багамы")),
    ("BT", _("Бутан")),
    ("BV", _("Остров Буве")),
    ("BW", _("Ботсвана")),
    ("BY", _("Беларусь")),
    ("BZ", _("Белиз")),
    ("CC", _("Кокосовые Острова ")),
    ("CD", _("Демократическая Республика Конго")),
    ("CF", _("Центрально-Африканская Республика")),
    ("CG", _("Конго")),
    ("CI", _("Кот-Д'Ивуар")),
    ("CK", _("Острова Кука")),
    ("CL", _("Чили")),
    ("CM", _("Камерун")),
    ("CO", _("Колумбия")),
    ("CR", _("Коста-Рика")),
    ("CU", _("Куба")),
    ("CV", _("Кабо-Верде")),
    ("CW", _("Кюрасао")),
    ("CX", _("Остров Рождества")),
    ("CY", _("Кипр")),
    ("DJ", _("Джибути")),
    ("DM", _("Доминика")),
    ("DO", _("Доминиканская Республика")),
    ("DZ", _("Алжир")),
    ("EC", _("Эквадор")),
    ("EE", _("Эстония")),
    ("EG", _("Египет")),
    ("EH", _("Западная Сахара")),
    ("ER", _("Эритрея")),
    ("ET", _("Эфиопия")),
    ("FJ", _("Фиджи")),
    ("FK", _("Фолклендские (Мальвинские) Острова")),
    ("FM", _("Федеративные Штаты Микронезии")),
    ("FO", _("Фарерские Острова")),
    ("GA", _("Габон")),
    ("GD", _("Гренада")),
    ("GE", _("Грузия")),
    ("GF", _("Французская Гвиана")),
    ("GG", _("Гернси")),
    ("GH", _("Гана")),
    ("GI", _("Гибралтар")),
    ("GL", _("Гренландия")),
    ("GM", _("Гамбия")),
    ("GN", _("Гвинея")),
    ("GP", _("Гваделупа")),
    ("GQ", _("Экваториальная Гвинея")),
    ("GS", _("Южная Джорджия И Южные Сандвичевы Острова ")),
    ("GT", _("Гватемала")),
    ("GU", _("Гуам")),
    ("GW", _("Гвинея-Бисау")),
    ("GY", _("Гайана")),
    ("HM", _("Остров Херд И Острова Макдональд")),
    ("HN", _("Гондурас")),
    ("HR", _("Хорватия")),
    ("HT", _("Гаити")),
    ("IM", _("Остров Мэн")),
    ("IO", _("Британская Территория Индийского Океана")),
    ("IQ", _("Ирак")),
    ("IR", _("Иран")),
    ("IS", _("Исландия")),
    ("JE", _("Джерси")),
    ("JM", _("Ямайка")),
    ("JO", _("Иордания")),
    ("KE", _("Кения")),
    ("KG", _("Кыргызстан")),
    ("KH", _("Камбоджа")),
    ("KI", _("Кирибати")),
    ("KM", _("Коморские Острова")),
    ("KN", _("Сент-Китс И Невис")),
    ("KP", _("Корейская Народно-Демократическая Республика")),
    ("KR", _("Республика Корея")),
    ("KW", _("Кувейт")),
    ("KY", _("Каймановы Острова")),
    ("KZ", _("Казахстан")),
    ("LA", _("Лаосская Народно-Демократическая Республика")),
    ("LB", _("Ливан")),
    ("LC", _("Сент-Люсия")),
    ("LI", _("Лихтенштейн")),
    ("LK", _("Шри-Ланка")),
    ("LR", _("Либерия")),
    ("LS", _("Лесото")),
    ("LT", _("Литва")),
    ("LU", _("Люксембург")),
    ("LV", _("Латвия")),
    ("LY", _("Ливия")),
    ("MA", _("Марокко")),
    ("MC", _("Монако")),
    ("MD", _("Республика Молдова")),
    ("ME", _("Черногория")),
    ("MF", _("Сен-Мартен (Франция)")),
    ("MG", _("Мадагаскар")),
    ("MH", _("Маршалловы Острова")),
    ("MK", _("Северная Македония")),
    ("ML", _("Мали")),
    ("MM", _("Мьянма")),
    ("MN", _("Монголия")),
    ("MO", _("Аомынь")),
    ("MP", _("Острова Северной Марианы")),
    ("MQ", _("Мартиника")),
    ("MR", _("Мавритания")),
    ("MS", _("Монсеррат")),
    ("MT", _("Мальта")),
    ("MU", _("Маврикий")),
    ("MV", _("Мальдивы")),
    ("MW", _("Малави")),
    ("MX", _("Мексика")),
    ("MZ", _("Мозамбик")),
    ("NA", _("Намибия")),
    ("NC", _("Новая Каледония")),
    ("NE", _("Нигер")),
    ("NF", _("Остров Норфолк")),
    ("NG", _("Нигерия")),
    ("NI", _("Никарагуа")),
    ("NP", _("Непал")),
    ("NR", _("Науру")),
    ("NU", _("Ниуэ")),
    ("OM", _("Оман")),
    ("PA", _("Панама")),
    ("PF", _("Французская Полинезия")),
    ("PG", _("Папуа — Новая Гвинея")),
    ("PK", _("Пакистан")),
    ("PM", _("Сен-Пьер И Микелон")),
    ("PN", _("Питкэрн")),
    ("PS", _("Палестина")),
    ("PW", _("Палау")),
    ("PY", _("Парагвай")),
    ("QA", _("Катар")),
    ("RE", _("Реюньон")),
    ("RO", _("Румыния")),
    ("RS", _("Сербия")),
    ("RW", _("Руанда")),
    ("SA", _("Саудовская Аравия")),
    ("SB", _("Соломоновы Острова")),
    ("SC", _("Сейшельские Острова")),
    ("SD", _("Судан")),
    ("SH", _("Остров Святой Елены, Остров Вознесения И Тристан-Да-Кунья")),
    ("SI", _("Словения")),
    ("SJ", _("Шпицберген И Ян-Майен")),
    ("SK", _("Словакия")),
    ("SL", _("Сьерра-Леоне")),
    ("SM", _("Сан-Марино")),
    ("SN", _("Сенегал")),
    ("SO", _("Сомали")),
    ("SR", _("Суринам")),
    ("ST", _("Сан-Томе И Принсипи")),
    ("SV", _("Сальвадор")),
    ("SX", _("Синт-Мартен (Голландская Часть)")),
    ("SY", _("Сирийская Арабская Республика")),
    ("SZ", _("Эсватини")),
    ("TC", _("Острова Туркс И Каикос")),
    ("TD", _("Чад")),
    ("TF", _("Французские Южные Территории")),
    ("TG", _("Того")),
    ("TJ", _("Таджикистан")),
    ("TK", _("Токелау")),
    ("TL", _("Восточный Тимор")),
    ("TM", _("Туркменистан")),
    ("TN", _("Тунис")),
    ("TO", _("Тонга")),
    ("TR", _("Турция")),
    ("TT", _("Тринидад И Тобаго")),
    ("TV", _("Тувалу")),
    ("TZ", _("Танзания")),
    ("UA", _("Украина")),
    ("UG", _("Уганда")),
    ("UM", _("Соединенные Штаты Малых  Удаленных Островов")),
    ("UY", _("Уругвай")),
    ("UZ", _("Узбекистан")),
    ("VA", _("Государство-Город Ватикан")),
    ("VC", _("Сент-Винсент И Гренадины")),
    ("VE", _("Боливарианская Республика Венесуэла")),
    ("VG", _("Виргинские Острова (Британия)")),
    ("VI", _("Виргинские Острова (CША)")),
    ("VU", _("Вануату")),
    ("WF", _("Уоллес И Футана")),
    ("WS", _("Самоа")),
    ("YE", _("Йемен")),
    ("YT", _("Майот")),
    ("ZM", _("Замбия")),
    ("ZW", _("Зимбабве")),
    ("ZR", _("Заир")),
)


MARKETPLACE_COUNTRIES = Choices(
    ("RU", _("Российская Федерация")),
    ("US", _("Соединённые Штаты")),
    ("AU", _("Австралия")),
    ("GB", _("Соединённое Королевство")),
    ("DE", _("Германия")),
    ("FR", _("Франция")),
    ("CZ", _("Чехия")),
    ("PL", _("Польша")),
    ("ES", _("Испания")),
    ("HK", _("Гонконг")),
    ("JP", _("Япония")),
    ("MY", _("Малайзия")),
    ("SG", _("Сингапур")),
    ("DK", _("Дания")),
    ("PE", _("Перу")),
    ("NZ", _("Новая Зеландия")),
    ("TW", _("Китайская Провинция Тайвань")),
    ("NO", _("Норвегия")),
    ("IL", _("Израиль")),
    ("SE", _("Швеция")),
    ("ZA", _("Южная Африка")),
    ("IT", _("Италия")),
    ("NL", _("Нидерланды")),
    ("ID", _("Индонезия")),
    ("TH", _("Таиланд")),
    ("PT", _("Португалия")),
    ("FI", _("Финляндия")),
    ("GR", _("Греция")),
    ("HU", _("Венгрия")),
    ("PR", _("Пуэрто-Рико")),
    ("IN", _("Индия")),
    ("VN", _("Вьетнам")),
    ("CN", _("Китай")),
    ("PH", _("Филиппины")),
    ("CA", _("Канада")),
    ("CH", _("Швейцария")),
    ("IE", _("Ирландия")),
    ("AT", _("Австрия")),
)

COUNTRIES = MARKETPLACE_COUNTRIES + OTHER_COUNTRIES

COUNTRY_CODE_TO_NAME = dict(COUNTRIES)

COUNTRY_NAME_TO_CODE = dict((v, k) for k, v in COUNTRY_CODE_TO_NAME.items())

COUNTRIES_NAME = [country for __, country in COUNTRIES]

COUNTRY_CODE_ALPHA_TO_NUM = {
    "AW": 533,
    "AF": 4,
    "AO": 24,
    "AI": 660,
    "AX": 248,
    "AL": 8,
    "AD": 20,
    "AE": 784,
    "AR": 32,
    "AM": 51,
    "AS": 16,
    "AQ": 10,
    "TF": 260,
    "AG": 28,
    "AU": 36,
    "AT": 40,
    "AZ": 31,
    "BI": 108,
    "BE": 56,
    "BJ": 204,
    "BQ": 535,
    "BF": 854,
    "BD": 50,
    "BG": 100,
    "BH": 48,
    "BS": 44,
    "BA": 70,
    "BL": 652,
    "BY": 112,
    "BZ": 84,
    "BM": 60,
    "BO": 68,
    "BR": 76,
    "BB": 52,
    "BN": 96,
    "BT": 64,
    "BV": 74,
    "BW": 72,
    "CF": 140,
    "CA": 124,
    "CC": 166,
    "CH": 756,
    "CL": 152,
    "CN": 156,
    "CI": 384,
    "CM": 120,
    "CD": 180,
    "CG": 178,
    "CK": 184,
    "CO": 170,
    "KM": 174,
    "CV": 132,
    "CR": 188,
    "CU": 192,
    "CW": 531,
    "CX": 162,
    "KY": 136,
    "CY": 196,
    "CZ": 203,
    "DE": 276,
    "DJ": 262,
    "DM": 212,
    "DK": 208,
    "DO": 214,
    "DZ": 12,
    "EC": 218,
    "EG": 818,
    "ER": 232,
    "EH": 732,
    "ES": 724,
    "EE": 233,
    "ET": 231,
    "FI": 246,
    "FJ": 242,
    "FK": 238,
    "FR": 250,
    "FO": 234,
    "FM": 583,
    "GA": 266,
    "GB": 826,
    "GE": 268,
    "GG": 831,
    "GH": 288,
    "GI": 292,
    "GN": 324,
    "GP": 312,
    "GM": 270,
    "GW": 624,
    "GQ": 226,
    "GR": 300,
    "GD": 308,
    "GL": 304,
    "GT": 320,
    "GF": 254,
    "GU": 316,
    "GY": 328,
    "HK": 344,
    "HM": 334,
    "HN": 340,
    "HR": 191,
    "HT": 332,
    "HU": 348,
    "ID": 360,
    "IM": 833,
    "IN": 356,
    "IO": 86,
    "IE": 372,
    "IR": 364,
    "IQ": 368,
    "IS": 352,
    "IL": 376,
    "IT": 380,
    "JM": 388,
    "JE": 832,
    "JO": 400,
    "JP": 392,
    "KZ": 398,
    "KE": 404,
    "KG": 417,
    "KH": 116,
    "KI": 296,
    "KN": 659,
    "KR": 410,
    "KW": 414,
    "LA": 418,
    "LB": 422,
    "LR": 430,
    "LY": 434,
    "LC": 662,
    "LI": 438,
    "LK": 144,
    "LS": 426,
    "LT": 440,
    "LU": 442,
    "LV": 428,
    "MO": 446,
    "MF": 663,
    "MA": 504,
    "MC": 492,
    "MD": 498,
    "MG": 450,
    "MV": 462,
    "MX": 484,
    "MH": 584,
    "MK": 807,
    "ML": 466,
    "MT": 470,
    "MM": 104,
    "ME": 499,
    "MN": 496,
    "MP": 580,
    "MZ": 508,
    "MR": 478,
    "MS": 500,
    "MQ": 474,
    "MU": 480,
    "MW": 454,
    "MY": 458,
    "YT": 175,
    "NA": 516,
    "NC": 540,
    "NE": 562,
    "NF": 574,
    "NG": 566,
    "NI": 558,
    "NU": 570,
    "NL": 528,
    "NO": 578,
    "NP": 524,
    "NR": 520,
    "NZ": 554,
    "OM": 512,
    "PK": 586,
    "PA": 591,
    "PN": 612,
    "PE": 604,
    "PH": 608,
    "PW": 585,
    "PG": 598,
    "PL": 616,
    "PR": 630,
    "KP": 408,
    "PT": 620,
    "PY": 600,
    "PS": 275,
    "PF": 258,
    "QA": 634,
    "RE": 638,
    "RO": 642,
    "RU": 643,
    "RW": 646,
    "SA": 682,
    "SD": 729,
    "SN": 686,
    "SG": 702,
    "GS": 239,
    "SH": 654,
    "SJ": 744,
    "SB": 90,
    "SL": 694,
    "SV": 222,
    "SM": 674,
    "SO": 706,
    "PM": 666,
    "RS": 688,
    "SS": 728,
    "ST": 678,
    "SR": 740,
    "SK": 703,
    "SI": 705,
    "SE": 752,
    "SZ": 748,
    "SX": 534,
    "SC": 690,
    "SY": 760,
    "TC": 796,
    "TD": 148,
    "TG": 768,
    "TH": 764,
    "TJ": 762,
    "TK": 772,
    "TM": 795,
    "TL": 626,
    "TO": 776,
    "TT": 780,
    "TN": 788,
    "TR": 792,
    "TV": 798,
    "TW": 158,
    "TZ": 834,
    "UG": 800,
    "UA": 804,
    "UM": 581,
    "UY": 858,
    "US": 840,
    "UZ": 860,
    "VA": 336,
    "VC": 670,
    "VE": 862,
    "VG": 92,
    "VI": 850,
    "VN": 704,
    "VU": 548,
    "WF": 876,
    "WS": 882,
    "YE": 887,
    "ZA": 710,
    "ZM": 894,
    "ZW": 716,
}

NUM_TO_COUNTRY_CODE_ALPHA = {value: key for key, value in COUNTRY_CODE_ALPHA_TO_NUM.items()}
